/*
 * Decompiled with CFR 0.152.
 */
package gov.llnl.babel.symbols;

import gov.llnl.babel.symbols.Comment;
import gov.llnl.babel.symbols.Metadata;
import gov.llnl.babel.symbols.SymbolID;
import java.util.Date;
import java.util.Set;

public abstract class Symbol
implements Comparable {
    public static final int ENUM = 11;
    public static final int CLASS = 12;
    public static final int INTERFACE = 13;
    public static final int PACKAGE = 14;
    public static final String[] s_type = new String[]{"class", "enum", "interface", "package"};
    public static final String SCOPE = ".";
    private Comment d_comment;
    private Metadata d_metadata;
    private SymbolID d_symbol_id;
    private int d_symbol_type;
    private boolean d_user_specified;

    public Symbol(SymbolID id, int type, Comment comment) {
        this.d_comment = comment;
        this.d_metadata = new Metadata(new Date());
        this.d_symbol_id = id;
        this.d_symbol_type = type;
        this.d_user_specified = false;
    }

    public Symbol(SymbolID id, int type, Comment comment, Metadata metadata) {
        this.d_comment = comment;
        this.d_metadata = metadata;
        this.d_symbol_id = id;
        this.d_symbol_type = type;
        this.d_user_specified = false;
    }

    public Comment getComment() {
        return this.d_comment;
    }

    public void setComment(Comment comment) {
        this.d_comment = comment;
    }

    public boolean getUserSpecified() {
        return this.d_user_specified;
    }

    public void setUserSpecified(boolean val) {
        this.d_user_specified = val;
    }

    public Metadata getMetadata() {
        return this.d_metadata;
    }

    public void addMetadata(String keyword, String value) {
        this.d_metadata.addMetadata(keyword, value);
    }

    public SymbolID getSymbolID() {
        return this.d_symbol_id;
    }

    public String getFullName() {
        return this.d_symbol_id.getFullName();
    }

    public int getSymbolType() {
        return this.d_symbol_type;
    }

    public boolean isPackage() {
        return this.d_symbol_type == 14;
    }

    public boolean isInterface() {
        return this.d_symbol_type == 13;
    }

    public String getSymbolTypeString() {
        String s = null;
        if (12 <= this.d_symbol_type && this.d_symbol_type <= 14) {
            s = s_type[this.d_symbol_type];
        }
        return s;
    }

    public abstract Set getSymbolReferences();

    public abstract Set getAllSymbolReferences();

    public abstract Set getBasicArrayRefs();

    public int compareTo(Object o) {
        Symbol sym = (Symbol)o;
        return this.d_symbol_id.compareTo(sym.d_symbol_id);
    }
}

