/*
 * Decompiled with CFR 0.152.
 */
package gov.llnl.babel.symbols;

import gov.llnl.babel.symbols.Comment;
import gov.llnl.babel.symbols.Metadata;
import gov.llnl.babel.symbols.Symbol;
import gov.llnl.babel.symbols.SymbolID;
import gov.llnl.babel.symbols.SymbolTable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class Package
extends Symbol {
    private boolean d_final = false;
    private ArrayList d_ordered_refs = new ArrayList();
    private HashMap d_references = new HashMap();

    public Package(SymbolID id, Comment comment) {
        super(id, 14, comment);
    }

    public Package(SymbolID id, Comment comment, Metadata metadata) {
        super(id, 14, comment, metadata);
    }

    public void addSymbol(SymbolID id, int type) {
        this.d_references.put(id, new Integer(type));
        this.d_ordered_refs.add(id);
    }

    public String getScopedName(String name) {
        return this.getFullName() + "." + name;
    }

    public Set getSymbolReferences() {
        return this.d_references.keySet();
    }

    public Set getAllSymbolReferences() {
        SymbolTable table = SymbolTable.getInstance();
        HashSet result = new HashSet();
        Set local = this.getSymbolReferences();
        result.addAll(local);
        Iterator i = local.iterator();
        while (i.hasNext()) {
            SymbolID id = (SymbolID)i.next();
            Symbol sym = table.lookupSymbol(id);
            result.addAll(sym.getAllSymbolReferences());
        }
        return result;
    }

    public Collection getOrderedSymbolReferences() {
        return this.d_ordered_refs;
    }

    public Set getBasicArrayRefs() {
        return new HashSet(0);
    }

    public Map getSymbols() {
        return this.d_references;
    }

    public boolean getFinal() {
        return this.d_final;
    }

    public void setFinal(boolean isFinal) {
        this.d_final = isFinal;
    }
}

