/*
 * Decompiled with CFR 0.152.
 */
package gov.llnl.babel.symbols;

import gov.llnl.babel.symbols.AssertionException;
import gov.llnl.babel.symbols.AssertionExpression;
import gov.llnl.babel.symbols.Extendable;
import gov.llnl.babel.symbols.Method;
import java.util.ArrayList;

public class DoubleLiteral
extends AssertionExpression {
    private String d_image = null;
    private Double d_value = null;

    public DoubleLiteral(Double value, String image) throws AssertionException {
        super(true);
        if (image == null || image.equals("")) {
            throw new AssertionException("DoubleLiteral", "Cannot create a double literal using a null string image.");
        }
        this.d_image = image;
        this.d_value = value;
        this.setReturnToDouble();
    }

    public String getImage() {
        return this.d_image;
    }

    public Double getValue() {
        return this.d_value;
    }

    public boolean hasPure() {
        return false;
    }

    public boolean hasResult() {
        return false;
    }

    public boolean hasMethodCall() {
        return false;
    }

    public boolean hasReservedMethod(int type) {
        return false;
    }

    public boolean hasUnreservedMethod(boolean any) {
        return false;
    }

    public boolean requiresExtendableContext() {
        return false;
    }

    public boolean requiresMethodContext() {
        return false;
    }

    protected void validateSemantics(Extendable ext, Method m) throws AssertionException {
    }

    public ArrayList getArrayIterMacros(String epvVar, int[] startInd) {
        return null;
    }

    public int getNumArrayIterMacrosByType(char type) {
        return 0;
    }

    public String cExpression(String epvVar, int[] startInd) {
        return this.d_value.toString();
    }

    public String toString() {
        return this.hasParens() ? "(" + this.d_image + ")" : this.d_image;
    }
}

