/*
 * Decompiled with CFR 0.152.
 */
package gov.llnl.babel.backend.jdk;

import gov.llnl.babel.BabelConfiguration;
import gov.llnl.babel.backend.CodeGenerationException;
import gov.llnl.babel.backend.IOR;
import gov.llnl.babel.backend.LevelComparator;
import gov.llnl.babel.backend.jdk.Java;
import gov.llnl.babel.backend.writers.LanguageWriterForC;
import gov.llnl.babel.symbols.Argument;
import gov.llnl.babel.symbols.Class;
import gov.llnl.babel.symbols.Extendable;
import gov.llnl.babel.symbols.Method;
import gov.llnl.babel.symbols.SymbolID;
import gov.llnl.babel.symbols.SymbolTable;
import gov.llnl.babel.symbols.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class ClientJNI {
    private LanguageWriterForC d_writer;

    public static void generateCode(Extendable symbol, LanguageWriterForC writer) throws CodeGenerationException {
        ClientJNI jni = new ClientJNI(writer);
        jni.generateCode(symbol);
    }

    public ClientJNI(LanguageWriterForC writer) {
        this.d_writer = writer;
    }

    private int countMethods(Extendable ext) {
        int count;
        boolean isInterface = ext.isInterface();
        List methods = null;
        methods = ext.isInterface() ? (List)ext.getMethods(true) : (ext.isAbstract() ? (List)ext.getAbstractAndLocalMethods() : (List)ext.getMethods(false));
        if (isInterface || ext.isAbstract()) {
            count = methods.size();
        } else {
            count = 0;
            Iterator i = methods.iterator();
            while (i.hasNext()) {
                Method m = (Method)i.next();
                if (m.isAbstract()) continue;
                ++count;
            }
        }
        return count;
    }

    public void generateCode(Extendable ext) throws CodeGenerationException {
        String fSymName;
        Collection overwritten;
        if (ext == null) {
            throw new CodeGenerationException("Unexpected null extendable object");
        }
        SymbolID id = ext.getSymbolID();
        String file = Java.getClientJNIFile(id);
        this.d_writer.writeBanner(ext, file, false, "Client-side JNI glue code for " + id.getFullName());
        this.d_writer.generateInclude("sidl_Java.h", false);
        this.d_writer.generateInclude("sidl_Loader.h", false);
        this.d_writer.generateInclude("sidl_String.h", false);
        this.d_writer.generateInclude(IOR.getHeaderFile(id), false);
        this.d_writer.generateInclude("babel_config.h", false);
        this.d_writer.println();
        this.d_writer.writeComment("Convert between jlong and void* pointers.", false);
        this.d_writer.disableLineBreak();
        this.d_writer.println("#if (SIZEOF_VOID_P == 8)");
        this.d_writer.println("#define JLONG_TO_POINTER(x) ((void*)(x))");
        this.d_writer.println("#define POINTER_TO_JLONG(x) ((jlong)(x))");
        this.d_writer.println("#else");
        this.d_writer.println("#define JLONG_TO_POINTER(x) ((void*)(int32_t)(x))");
        this.d_writer.println("#define POINTER_TO_JLONG(x) ((jlong)(int32_t)(x))");
        this.d_writer.println("#endif");
        this.d_writer.println();
        this.d_writer.println("#ifndef NULL");
        this.d_writer.println("#define NULL 0");
        this.d_writer.println("#endif");
        this.d_writer.println();
        this.d_writer.enableLineBreak();
        boolean need_ior_function = ext.isInterface();
        if (!need_ior_function) {
            Iterator m = ext.getMethods(false).iterator();
            while (m.hasNext()) {
                Method method = (Method)m.next();
                if (method.isStatic()) continue;
                need_ior_function = true;
                break;
            }
        }
        if (need_ior_function) {
            this.d_writer.writeComment("Function to extract IOR reference from the Java object.", false);
            this.d_writer.println("static " + IOR.getObjectName(id) + "* _get_ior(");
            this.d_writer.tab();
            this.d_writer.println("JNIEnv* env,");
            this.d_writer.println("jobject obj)");
            this.d_writer.backTab();
            this.d_writer.println("{");
            this.d_writer.tab();
            this.d_writer.println("void* ptr = NULL;");
            this.d_writer.println("static jmethodID mid = (jmethodID) NULL;");
            this.d_writer.println();
            this.d_writer.println("if (mid == (jmethodID) NULL) {");
            this.d_writer.tab();
            this.d_writer.println("jclass cls = (*env)->GetObjectClass(env, obj);");
            this.d_writer.println("mid = (*env)->GetMethodID(env, cls, \"_get_ior\", \"()J\");");
            this.d_writer.println("(*env)->DeleteLocalRef(env, cls);");
            this.d_writer.backTab();
            this.d_writer.println("}");
            this.d_writer.println();
            this.d_writer.println("ptr = JLONG_TO_POINTER((*env)->CallLongMethod(env, obj, mid));");
            this.d_writer.println("return (" + IOR.getObjectName(id) + "*) ptr;");
            this.d_writer.backTab();
            this.d_writer.println("}");
            this.d_writer.println();
        }
        if (!ext.isAbstract()) {
            this.d_writer.writeComment("External reference to IOR methods.", false);
            this.d_writer.println("static const " + IOR.getExternalName(id) + "* s_external = NULL;");
            this.d_writer.println();
            Class cls = (Class)ext;
            if (cls.hasOverwrittenMethods()) {
                this.d_writer.writeComment("External reference to IOR methods.", false);
                this.d_writer.println("static const " + IOR.getEPVName(cls.getParentClass().getSymbolID()) + "* superEPV = NULL;");
            }
        }
        if (ext.hasStaticMethod(false)) {
            this.d_writer.writeComment("External reference to static EPV.", false);
            this.d_writer.println("static const " + IOR.getSEPVName(id) + "* s_sepv = NULL;");
            this.d_writer.println();
        }
        if (!ext.isAbstract()) {
            this.d_writer.writeComment("Create object instance and return reference.", false);
            this.d_writer.println("static jlong jni__create_ior(");
            this.d_writer.tab();
            this.d_writer.println("JNIEnv* env,");
            this.d_writer.println("jclass  cls)");
            this.d_writer.backTab();
            this.d_writer.println("{");
            this.d_writer.tab();
            this.d_writer.println("(void) env;");
            this.d_writer.println("(void) cls;");
            this.d_writer.println("return POINTER_TO_JLONG((*s_external->createObject)());");
            this.d_writer.backTab();
            this.d_writer.println("}");
            this.d_writer.println();
        }
        List methods = null;
        methods = ext.isInterface() ? (List)ext.getMethods(true) : (ext.isAbstract() ? (List)ext.getAbstractAndLocalMethods() : (List)ext.getMethods(false));
        Iterator m = methods.iterator();
        while (m.hasNext()) {
            Method method = (Method)m.next();
            this.generateMethod(ext, method, false);
            this.d_writer.println();
        }
        if (!ext.isAbstract()) {
            Class cls = (Class)ext;
            overwritten = cls.getOverwrittenClassMethods();
            Iterator m2 = overwritten.iterator();
            while (m2.hasNext()) {
                Method method = (Method)m2.next();
                this.generateMethod(ext, method, true);
                this.d_writer.println();
            }
        }
        if ((fSymName = Java.getFullJavaSymbolName(id)).compareTo(BabelConfiguration.getBaseInterface()) == 0) {
            this.generateBaseInterfaceArrayFunctions(id);
        }
        overwritten = null;
        int numOverwritten = 0;
        if (!ext.isAbstract()) {
            Class cls = (Class)ext;
            overwritten = cls.getOverwrittenClassMethods();
            numOverwritten = overwritten.size();
        } else {
            overwritten = new ArrayList();
        }
        int nmethods = this.countMethods(ext) + (ext.isAbstract() ? 0 : 1) + numOverwritten;
        if (!ext.isAbstract()) {
            Class cls = (Class)ext;
            overwritten = cls.getOverwrittenClassMethods();
            numOverwritten = overwritten.size();
        }
        this.d_writer.writeComment("Register JNI methods with the Java JVM.", false);
        this.d_writer.println("void " + Java.getRegisterFunction(id) + "(JNIEnv* env)");
        this.d_writer.println("{");
        this.d_writer.tab();
        if (nmethods > 0) {
            String prefix;
            Method method;
            this.d_writer.println("JNINativeMethod methods[" + Integer.toString(nmethods) + "];");
            this.d_writer.println("jclass cls;");
            this.d_writer.println();
            if (!ext.isAbstract()) {
                if (BabelConfiguration.isSIDLBaseClass(id)) {
                    this.d_writer.println("s_external = " + IOR.getExternalFunc(id) + "();");
                } else {
                    String ext_name = IOR.getExternalName(id);
                    this.d_writer.printlnUnformatted("#ifdef SIDL_STATIC_LIBRARY");
                    this.d_writer.println("s_external = " + IOR.getExternalFunc(id) + "();");
                    this.d_writer.printlnUnformatted("#else");
                    this.d_writer.println("sidl_DLL dll = sidl_DLL__create();");
                    this.d_writer.println("const " + ext_name + "*(*dll_f)(void);");
                    this.d_writer.writeCommentLine("check global namespace for symbol first");
                    this.d_writer.println("if (dll && sidl_DLL_loadLibrary(dll, \"main:\", TRUE, FALSE)) {");
                    this.d_writer.tab();
                    this.d_writer.println("dll_f =");
                    this.d_writer.tab();
                    this.d_writer.print("(const " + ext_name + "*(*)(void)) ");
                    this.d_writer.println("sidl_DLL_lookupSymbol(");
                    this.d_writer.tab();
                    this.d_writer.println("dll, \"" + IOR.getExternalFunc(id) + "\");");
                    this.d_writer.backTab();
                    this.d_writer.backTab();
                    this.d_writer.println("s_external = (dll_f ? (*dll_f)() : NULL);");
                    this.d_writer.backTab();
                    this.d_writer.println("}");
                    this.d_writer.println("if (dll) sidl_DLL_deleteRef(dll);");
                    this.d_writer.println("if (!s_external) {");
                    this.d_writer.tab();
                    this.d_writer.println("dll = sidl_Loader_findLibrary(\"" + id.getFullName() + "\",");
                    this.d_writer.tab();
                    this.d_writer.println("\"ior/impl\", sidl_Scope_SCLSCOPE,");
                    this.d_writer.println("sidl_Resolve_SCLRESOLVE);");
                    this.d_writer.backTab();
                    this.d_writer.println("if (dll) {");
                    this.d_writer.tab();
                    this.d_writer.println("dll_f =");
                    this.d_writer.tab();
                    this.d_writer.print("(const " + ext_name + "*(*)(void)) ");
                    this.d_writer.println("sidl_DLL_lookupSymbol(");
                    this.d_writer.tab();
                    this.d_writer.println("dll, \"" + IOR.getExternalFunc(id) + "\");");
                    this.d_writer.backTab();
                    this.d_writer.backTab();
                    this.d_writer.println("s_external = (dll_f ? (*dll_f)() : NULL);");
                    this.d_writer.println("sidl_DLL_deleteRef(dll);");
                    this.d_writer.backTab();
                    this.d_writer.println("}");
                    this.d_writer.backTab();
                    this.d_writer.println("}");
                    this.d_writer.println("if (!s_external) {");
                    this.d_writer.tab();
                    this.d_writer.println("jclass e = (*env)->FindClass(env, \"java/lang/UnsatisfiedLinkError\");");
                    this.d_writer.println("if (e != NULL) {");
                    this.d_writer.tab();
                    this.d_writer.disableLineBreak();
                    this.d_writer.println("(*env)->ThrowNew(env, e, \"Could not find implementation for sidl class " + id.getFullName() + "\");");
                    this.d_writer.enableLineBreak();
                    this.d_writer.println("(*env)->DeleteLocalRef(env, e);");
                    this.d_writer.backTab();
                    this.d_writer.println("}");
                    this.d_writer.backTab();
                    this.d_writer.println("}");
                    this.d_writer.printlnUnformatted("#endif");
                    this.d_writer.println();
                }
            }
            if (ext.hasStaticMethod(false)) {
                this.d_writer.println("s_sepv = (*(s_external->getStaticEPV))();");
                this.d_writer.println();
            }
            int idx = 0;
            if (!ext.isAbstract()) {
                this.d_writer.println("methods[0].name      = \"_create_ior\";");
                this.d_writer.println("methods[0].signature = \"()J\";");
                this.d_writer.println("methods[0].fnPtr     = (void *)jni__create_ior;");
                ++idx;
            }
            Iterator m3 = methods.iterator();
            while (m3.hasNext()) {
                method = (Method)m3.next();
                prefix = "methods[" + Integer.toString(idx) + "].";
                this.d_writer.println(prefix + "name      = \"" + method.getShortMethodName() + "\";");
                this.d_writer.disableLineBreak();
                this.d_writer.println(prefix + "signature = \"" + Java.getJavaSignature(method) + "\";");
                this.d_writer.enableLineBreak();
                this.d_writer.println(prefix + "fnPtr     = (void *)" + Java.getJNIFunction(method) + ";");
                ++idx;
            }
            this.d_writer.println();
            m3 = overwritten.iterator();
            while (m3.hasNext()) {
                method = (Method)m3.next();
                prefix = "methods[" + Integer.toString(idx) + "].";
                this.d_writer.println(prefix + "name      = \"" + "super_" + method.getShortMethodName() + "\";");
                this.d_writer.disableLineBreak();
                this.d_writer.println(prefix + "signature = \"" + Java.getJavaSignature(method) + "\";");
                this.d_writer.enableLineBreak();
                this.d_writer.println(prefix + "fnPtr     = (void *)" + Java.getSuperJNIFunction(method) + ";");
                ++idx;
            }
            this.d_writer.println();
            String lookup_name = Java.getFullJavaSymbolName(id).replace('.', '/');
            if (ext.isInterface()) {
                lookup_name = lookup_name + "$Wrapper";
            }
            this.d_writer.println("cls = (*env)->FindClass(env, \"" + lookup_name + "\");");
            this.d_writer.println("if (cls) {");
            this.d_writer.tab();
            this.d_writer.println("(*env)->RegisterNatives(env, cls, methods, " + String.valueOf(nmethods) + ");");
            this.d_writer.println("(*env)->DeleteLocalRef(env, cls);");
            this.d_writer.backTab();
            this.d_writer.println("}");
            String fSymName1 = Java.getFullJavaSymbolName(id);
            if (fSymName1.compareTo(BabelConfiguration.getBaseInterface()) == 0) {
                this.registerBaseInterfaceArrayFunctions(id);
            }
        } else {
            this.d_writer.writeComment("Intentionally empty: no methods to register", false);
        }
        this.d_writer.backTab();
        this.d_writer.println("}");
    }

    private void generateMethod(Extendable ext, Method method, boolean isSuper) throws CodeGenerationException {
        Argument arg;
        boolean throws_exception = !method.getThrows().isEmpty();
        SymbolID id = ext.getSymbolID();
        this.d_writer.writeComment(method, false);
        Type return_type = method.getReturnType();
        this.d_writer.println("static " + Java.getJNIReturnType(return_type));
        if (isSuper) {
            this.d_writer.println(Java.getSuperJNIFunction(method) + "(");
        } else {
            this.d_writer.println(Java.getJNIFunction(method) + "(");
        }
        this.d_writer.tab();
        this.d_writer.println("JNIEnv* env,");
        if (!method.isStatic()) {
            this.d_writer.print("jobject obj");
        } else {
            this.d_writer.print("jclass  cls");
        }
        ArrayList args = method.getArgumentList();
        this.d_writer.println(args.isEmpty() ? ")" : ",");
        Iterator a = args.iterator();
        while (a.hasNext()) {
            arg = (Argument)a.next();
            this.d_writer.print(Java.getJNIFormalArgument(arg));
            this.d_writer.println(a.hasNext() ? "," : ")");
        }
        this.d_writer.backTab();
        this.d_writer.println("{");
        this.d_writer.tab();
        this.d_writer.writeComment("Declare return and temporary variables.", false);
        if (!method.isStatic()) {
            this.d_writer.println(IOR.getObjectName(id) + "* _ior = NULL;");
        }
        a = args.iterator();
        while (a.hasNext()) {
            arg = (Argument)a.next();
            Java.declareIORVariable(this.d_writer, arg, "_tmp_");
        }
        if (return_type.getType() != 0) {
            Java.declareIORVariable(this.d_writer, return_type, "_ior_res");
            Java.declareJavaVariable(this.d_writer, return_type, "_res");
        }
        if (throws_exception) {
            this.d_writer.println("struct sidl_BaseInterface__object* _ex = NULL;");
        }
        this.d_writer.println();
        this.d_writer.writeComment("Preprocess Java types and convert into IOR.", false);
        if (!method.isStatic()) {
            this.d_writer.println("_ior = _get_ior(env, obj);");
        }
        if (isSuper) {
            this.d_writer.writeCommentLine("Prep the superEPV");
            this.d_writer.println("superEPV = s_external->getSuperEPV();");
            this.d_writer.println();
        }
        a = args.iterator();
        while (a.hasNext()) {
            arg = (Argument)a.next();
            this.checkNull(arg, return_type);
            Java.preprocessJNIArgument(this.d_writer, arg, "_tmp_");
        }
        this.d_writer.println();
        this.d_writer.writeComment("Call the IOR method through the EPV.", false);
        if (return_type.getType() != 0) {
            this.d_writer.print("_ior_res = ");
        }
        this.d_writer.print("(*(");
        if (isSuper) {
            this.d_writer.print("superEPV");
        } else if (method.isStatic()) {
            this.d_writer.print("s_sepv");
        } else {
            this.d_writer.print("_ior->d_epv");
        }
        this.d_writer.print("->f_" + method.getLongMethodName() + "))(");
        if (method.isStatic() && args.isEmpty() && !throws_exception) {
            this.d_writer.println(");");
        } else {
            this.d_writer.println();
            this.d_writer.tab();
            if (!method.isStatic()) {
                this.d_writer.print(ext.isInterface() ? "_ior->d_object" : "_ior");
                this.d_writer.println(args.isEmpty() && !throws_exception ? ");" : ",");
            }
            a = args.iterator();
            while (a.hasNext()) {
                arg = (Argument)a.next();
                if (arg.getMode() != 0) {
                    this.d_writer.print("&");
                }
                this.d_writer.print("_tmp_" + arg.getFormalName());
                this.d_writer.println(a.hasNext() || throws_exception ? "," : ");");
            }
            if (throws_exception) {
                this.d_writer.println("&_ex);");
            }
            this.d_writer.backTab();
        }
        this.d_writer.println();
        this.d_writer.writeComment("Postprocess OUT, INOUT, returns, and exceptions.", false);
        a = args.iterator();
        while (a.hasNext()) {
            arg = (Argument)a.next();
            Java.postprocessJNIArgument(this.d_writer, arg, "_tmp_");
        }
        if (return_type.getType() != 0) {
            Java.postprocessJNIReturn(this.d_writer, return_type, "_ior_res", "_res");
        }
        if (throws_exception) {
            Object[] exceptions = method.getThrows().toArray();
            Arrays.sort(exceptions, new LevelComparator(SymbolTable.getInstance()));
            this.d_writer.println("sidl_Java_CheckException(");
            this.d_writer.tab();
            this.d_writer.println("env,");
            this.d_writer.println("_ex,");
            for (int i = 0; i < exceptions.length; ++i) {
                SymbolID exid = (SymbolID)exceptions[i];
                this.d_writer.println("\"" + exid.getFullName() + "\",");
            }
            this.d_writer.println("NULL);");
            this.d_writer.backTab();
        }
        if (return_type.getType() != 0) {
            this.d_writer.println();
            this.d_writer.println("return _res;");
        }
        this.d_writer.backTab();
        this.d_writer.println("}");
    }

    private void checkNull(Argument arg, Type retType) {
        if (arg.getMode() == 1) {
            this.d_writer.println("if(_arg_" + arg.getFormalName() + "== NULL) {");
            this.d_writer.tab();
            this.d_writer.println("jclass newExcCls = (*env)->FindClass(env, \"java/lang/RuntimeException\");");
            this.d_writer.println("(*env)->ThrowNew(env, newExcCls, \"Null Holder Sent as INOUT Argument\");");
            if (retType.getType() != 0) {
                this.d_writer.println("return 0;");
            } else {
                this.d_writer.println("return;");
            }
            this.d_writer.println("}");
            this.d_writer.backTab();
        } else if (arg.getMode() == 2) {
            this.d_writer.println("if(_arg_" + arg.getFormalName() + "== NULL) {");
            this.d_writer.tab();
            this.d_writer.println("jclass newExcCls = (*env)->FindClass(env, \"java/lang/RuntimeException\");");
            this.d_writer.println("(*env)->ThrowNew(env, newExcCls, \"Null Holder Sent as OUT Argument\");");
            if (retType.getType() != 0) {
                this.d_writer.println("return 0;");
            } else {
                this.d_writer.println("return;");
            }
            this.d_writer.println("}");
            this.d_writer.backTab();
        }
    }

    private void generateBaseInterfaceArrayFunctions(SymbolID id) {
        String generalSidlName = BabelConfiguration.getBaseInterface().replace('.', '_');
        String sidlBaseClass = BabelConfiguration.getBaseClass().replace('.', '_');
        this.d_writer.beginBlockComment(true);
        this.d_writer.println("Local utility function to extract the array pointer from the Java object.");
        this.d_writer.println("Extract the d_array long data member and convert it to a pointer.");
        this.d_writer.endBlockComment(true);
        this.d_writer.println("static struct " + generalSidlName + "__array* " + generalSidlName + "__getptr(");
        this.d_writer.println("JNIEnv* env,");
        this.d_writer.println("jobject obj)");
        this.d_writer.println("{");
        this.d_writer.tab();
        this.d_writer.println("void* ptr = NULL;");
        this.d_writer.println("static jfieldID s_array_field = NULL;");
        this.d_writer.println("");
        this.d_writer.println("if (s_array_field == NULL) {");
        this.d_writer.tab();
        this.d_writer.println("jclass cls = (*env)->GetObjectClass(env, obj);");
        this.d_writer.println("s_array_field = (*env)->GetFieldID(env, cls, \"d_array\", \"J\");");
        this.d_writer.println("(*env)->DeleteLocalRef(env, cls);");
        this.d_writer.backTab();
        this.d_writer.println("}");
        this.d_writer.println("");
        this.d_writer.println("ptr = JLONG_TO_POINTER((*env)->GetLongField(env, obj, s_array_field));");
        this.d_writer.println("return (struct " + generalSidlName + "__array*) ptr;");
        this.d_writer.backTab();
        this.d_writer.println("}");
        this.d_writer.println("");
        this.d_writer.beginBlockComment(true);
        this.d_writer.println("Local utility function to set the array pointer on the Java object.");
        this.d_writer.println("Convert the pointer to a long value and set the d_array data member.");
        this.d_writer.endBlockComment(true);
        this.d_writer.println("static void " + generalSidlName + "__setptr(");
        this.d_writer.println("JNIEnv* env,");
        this.d_writer.println("jobject obj,");
        this.d_writer.println("struct " + generalSidlName + "__array* array)");
        this.d_writer.println("{");
        this.d_writer.tab();
        this.d_writer.println("static jfieldID s_array_field = NULL;");
        this.d_writer.println("");
        this.d_writer.println("if (s_array_field == NULL) {");
        this.d_writer.tab();
        this.d_writer.println("jclass cls = (*env)->GetObjectClass(env, obj);");
        this.d_writer.println("s_array_field = (*env)->GetFieldID(env, cls, \"d_array\", \"J\");");
        this.d_writer.println("(*env)->DeleteLocalRef(env, cls);");
        this.d_writer.backTab();
        this.d_writer.println("}");
        this.d_writer.println("");
        this.d_writer.println("(*env)->SetLongField(env, obj, s_array_field, POINTER_TO_JLONG(array));");
        this.d_writer.backTab();
        this.d_writer.println("}");
        this.d_writer.println("");
        this.d_writer.beginBlockComment(true);
        this.d_writer.println("Native routine to fetch the specified value from the array.  The");
        this.d_writer.println("specified array index/indices must be lie between the array lower");
        this.d_writer.println("upper bounds (inclusive).  Invalid indices will have unpredictable");
        this.d_writer.println("(but almost certainly bad) results.");
        this.d_writer.endBlockComment(true);
        this.d_writer.println("static jobject " + generalSidlName + "__get(");
        this.d_writer.println("JNIEnv* env,");
        this.d_writer.println("jobject obj,");
        this.d_writer.println("jint i,");
        this.d_writer.println("jint j,");
        this.d_writer.println("jint k,");
        this.d_writer.println("jint l,");
        this.d_writer.println("jint m,");
        this.d_writer.println("jint n,");
        this.d_writer.println("jint o)");
        this.d_writer.println("{");
        this.d_writer.tab();
        this.d_writer.println("struct " + generalSidlName + "__array* array = " + generalSidlName + "__getptr(env, obj);");
        this.d_writer.println("struct " + generalSidlName + "__object* value = NULL;");
        this.d_writer.println("struct " + sidlBaseClass + "__object* bclass = NULL;");
        this.d_writer.println("jobject ret = NULL;");
        this.d_writer.println("int32_t a[7];");
        this.d_writer.println("a[0] = i;");
        this.d_writer.println("a[1] = j;");
        this.d_writer.println("a[2] = k;");
        this.d_writer.println("a[3] = l;");
        this.d_writer.println("a[4] = m;");
        this.d_writer.println("a[5] = n;");
        this.d_writer.println("a[6] = o;");
        this.d_writer.println();
        this.d_writer.println("value = " + generalSidlName + "__array_get(array, a);");
        this.d_writer.println("bclass = " + sidlBaseClass + "__cast(value);");
        this.d_writer.println("ret = sidl_Java_I2J_ifc(env, bclass, \"" + BabelConfiguration.getBaseInterface() + "\");");
        this.d_writer.println("return ret;");
        this.d_writer.backTab();
        this.d_writer.println("}");
        this.d_writer.println("");
        this.d_writer.beginBlockComment(true);
        this.d_writer.println("Native routine to set the specified value in the array.  The");
        this.d_writer.println("specified array index/indices must be lie between the array lower");
        this.d_writer.println("upper bounds (inclusive).  Invalid indices will have unpredictable");
        this.d_writer.println("(but almost certainly bad) results.");
        this.d_writer.endBlockComment(true);
        this.d_writer.println("static void " + generalSidlName + "__set(");
        this.d_writer.println("JNIEnv* env,");
        this.d_writer.println("jobject obj,");
        this.d_writer.println("jint i,");
        this.d_writer.println("jint j,");
        this.d_writer.println("jint k,");
        this.d_writer.println("jint l,");
        this.d_writer.println("jint m, ");
        this.d_writer.println("jint n, ");
        this.d_writer.println("jint o,");
        this.d_writer.println("jobject value)");
        this.d_writer.println("{");
        this.d_writer.tab();
        this.d_writer.println("struct " + generalSidlName + "__array* array = " + generalSidlName + "__getptr(env, obj);");
        this.d_writer.println();
        this.d_writer.println("sidl_BaseInterface vpointer = sidl_Java_J2I_cls(env, value);");
        this.d_writer.println("int32_t a[7];");
        this.d_writer.println("a[0] = i;");
        this.d_writer.println("a[1] = j;");
        this.d_writer.println("a[2] = k;");
        this.d_writer.println("a[3] = l;");
        this.d_writer.println("a[4] = m;");
        this.d_writer.println("a[5] = n;");
        this.d_writer.println("a[6] = o;");
        this.d_writer.println("" + generalSidlName + "__array_set(array, a, vpointer);");
        this.d_writer.backTab();
        this.d_writer.println("}");
        this.d_writer.beginBlockComment(true);
        this.d_writer.println("Native routine to reallocate data in the array.  The specified array");
        this.d_writer.println("dimension and indices must match and be within valid ranges (e.g., the");
        this.d_writer.println("upper bounds must be greater than or equal to lowe rbounds.  Invalid");
        this.d_writer.println("indices will have unpredictable (but almost certainly bad) results.");
        this.d_writer.println("This routine will deallocate the existing array data if it is not null.");
        this.d_writer.endBlockComment(true);
        this.d_writer.println("static void " + generalSidlName + "__reallocate(");
        this.d_writer.println("JNIEnv* env,");
        this.d_writer.println("jobject obj,");
        this.d_writer.println("jint dim,");
        this.d_writer.println("jarray lower,");
        this.d_writer.println("jarray upper,");
        this.d_writer.println("jboolean isRow)");
        this.d_writer.println("{");
        this.d_writer.tab();
        this.d_writer.println("jint l[" + BabelConfiguration.getMaximumArray() + "];");
        this.d_writer.println("jint u[" + BabelConfiguration.getMaximumArray() + "];");
        this.d_writer.println("struct " + generalSidlName + "__array* array = NULL;");
        this.d_writer.println("struct " + generalSidlName + "__array* orig = sidl_BaseInterface__getptr(env,obj);");
        this.d_writer.println("int32_t i, lenl, lenu = 0;");
        this.d_writer.println("");
        this.d_writer.println("for(i=0; i < " + BabelConfiguration.getMaximumArray() + "; ++i) {");
        this.d_writer.tab();
        this.d_writer.println("l[i] = 0;");
        this.d_writer.println("u[i] = 0;");
        this.d_writer.backTab();
        this.d_writer.println("}");
        this.d_writer.println("lenl = (*env)->GetArrayLength(env, lower);");
        this.d_writer.println("lenu = (*env)->GetArrayLength(env, upper);");
        this.d_writer.println("");
        this.d_writer.println("");
        this.d_writer.println("sidl_BaseInterface__array_deleteRef(orig);");
        this.d_writer.println("(*env)->GetIntArrayRegion(env, lower, 0, lenl, (int32_t*)l);");
        this.d_writer.println("(*env)->GetIntArrayRegion(env, upper, 0, lenu, (int32_t*)u);");
        this.d_writer.println("");
        this.d_writer.println("");
        this.d_writer.println("if(isRow) ");
        this.d_writer.tab();
        this.d_writer.println("array = " + generalSidlName + "__array_createRow((int32_t) dim, (int32_t*) l, (int32_t*) u);");
        this.d_writer.backTab();
        this.d_writer.println("else");
        this.d_writer.tab();
        this.d_writer.println("array = " + generalSidlName + "__array_createCol((int32_t) dim, (int32_t*) l, (int32_t*) u);");
        this.d_writer.backTab();
        this.d_writer.println("");
        this.d_writer.println("");
        this.d_writer.println(generalSidlName + "__setptr(env, obj, array);");
        this.d_writer.backTab();
        this.d_writer.println("}");
        this.d_writer.println("");
        this.d_writer.beginBlockComment(true);
        this.d_writer.println("");
        this.d_writer.println("Native function copies every element of an array to an array of the");
        this.d_writer.println("same dimensionality, size, and type ");
        this.d_writer.println("");
        this.d_writer.endBlockComment(true);
        this.d_writer.println("static void " + generalSidlName + "__copy(");
        this.d_writer.println("JNIEnv* env,");
        this.d_writer.println("jobject obj,");
        this.d_writer.println("jobject dest)");
        this.d_writer.println("{");
        this.d_writer.tab();
        this.d_writer.println("struct " + generalSidlName + "__array* csrc = " + generalSidlName + "__getptr(env, obj);");
        this.d_writer.println("struct " + generalSidlName + "__array* cdest = " + generalSidlName + "__getptr(env, dest);");
        this.d_writer.println("");
        this.d_writer.println("if(csrc && cdest) {");
        this.d_writer.tab();
        this.d_writer.println("" + generalSidlName + "__array_copy(csrc,cdest);");
        this.d_writer.println("} ");
        this.d_writer.backTab();
        this.d_writer.println("");
        this.d_writer.println("}");
        this.d_writer.backTab();
        this.d_writer.println("");
        this.d_writer.beginBlockComment(true);
        this.d_writer.println("");
        this.d_writer.println("Native function slices arrays in various ways");
        this.d_writer.println("");
        this.d_writer.endBlockComment(true);
        this.d_writer.println("static jobject " + generalSidlName + "__slice(");
        this.d_writer.println("JNIEnv* env,");
        this.d_writer.println("jobject obj, ");
        this.d_writer.println("jint dimen, ");
        this.d_writer.println("jintArray numElem, ");
        this.d_writer.println("jintArray srcStart, ");
        this.d_writer.println("jintArray srcStride,");
        this.d_writer.println("jintArray newStart)");
        this.d_writer.println("{");
        this.d_writer.tab();
        this.d_writer.println("struct " + generalSidlName + "__array* array = " + generalSidlName + "__getptr(env, obj);");
        this.d_writer.println("struct " + generalSidlName + "__array* ret_ptr = NULL;");
        this.d_writer.println("jobject ret_array = NULL;");
        this.d_writer.println("int cnumElem[7];");
        this.d_writer.println("int csrcStart[7];");
        this.d_writer.println("int csrcStride[7];");
        this.d_writer.println("int cnewStart[7]; ");
        this.d_writer.println("int i = 0; ");
        this.d_writer.println("for(i = 0; i < 7; ++i) {  /*Make sure the array are clean*/ ");
        this.d_writer.tab();
        this.d_writer.println("cnumElem[i] = 0;");
        this.d_writer.println("csrcStart[i] = 0;");
        this.d_writer.println("csrcStride[i] = 0;");
        this.d_writer.println("cnewStart[i] = 0;");
        this.d_writer.println("}");
        this.d_writer.backTab();
        this.d_writer.println("");
        this.d_writer.println("if(numElem == NULL)");
        this.d_writer.println("return NULL;  /*If numElem is NULL, we need to return Null, that's bad.*/");
        this.d_writer.println("");
        this.d_writer.println("(*env)->GetIntArrayRegion(env, numElem, 0,");
        this.d_writer.println("(*env)->GetArrayLength(env, numElem), cnumElem);  ");
        this.d_writer.println("");
        this.d_writer.println("if(srcStart != NULL)");
        this.d_writer.println("(*env)->GetIntArrayRegion(env, srcStart, 0, ");
        this.d_writer.println("(*env)->GetArrayLength(env, srcStart), csrcStart);  ");
        this.d_writer.println("");
        this.d_writer.println("if(srcStride != NULL)");
        this.d_writer.println("(*env)->GetIntArrayRegion(env, srcStride, 0, ");
        this.d_writer.println("(*env)->GetArrayLength(env, srcStride), csrcStride);  ");
        this.d_writer.println("");
        this.d_writer.println("if(newStart != NULL)");
        this.d_writer.println("(*env)->GetIntArrayRegion(env, newStart, 0, ");
        this.d_writer.println("(*env)->GetArrayLength(env, newStart), cnewStart);    ");
        this.d_writer.println("");
        this.d_writer.println("");
        this.d_writer.println("if (array != NULL) {");
        this.d_writer.tab();
        this.d_writer.println("ret_ptr = " + generalSidlName + "__array_slice(array, dimen, cnumElem, csrcStart, csrcStride, cnewStart);");
        this.d_writer.println("}");
        this.d_writer.backTab();
        this.d_writer.println("");
        this.d_writer.println("if(ret_ptr != NULL) {  ");
        this.d_writer.tab();
        this.d_writer.println("ret_array = sidl_Java_I2J_new_array(env,ret_ptr, \"sidl.BaseInterface$Array\");");
        this.d_writer.println("}");
        this.d_writer.backTab();
        this.d_writer.println("");
        this.d_writer.println("return ret_array;");
        this.d_writer.println("}");
        this.d_writer.backTab();
        this.d_writer.println("");
        this.d_writer.println("");
        this.d_writer.beginBlockComment(true);
        this.d_writer.println("");
        this.d_writer.println("Native routine to decrement the current array reference count.");
        this.d_writer.println("");
        this.d_writer.endBlockComment(true);
        this.d_writer.println("");
        this.d_writer.beginBlockComment(true);
        this.d_writer.println("");
        this.d_writer.println("Native routine converts Java array of object to sidl array");
        this.d_writer.println("I'm sorry it's so complex, but the nature of working with the");
        this.d_writer.println("JNI is such that I couldn't think of anyway but a big case statement");
        this.d_writer.println("to make this work efficently");
        this.d_writer.println("");
        this.d_writer.endBlockComment(true);
        this.d_writer.println("static void " + generalSidlName + "__fromArray(");
        this.d_writer.println("JNIEnv* env,");
        this.d_writer.println("jobject obj,");
        this.d_writer.println("jobjectArray orray,");
        this.d_writer.println("jint dim,");
        this.d_writer.println("jintArray _upper,");
        this.d_writer.println("jboolean isRow)");
        this.d_writer.println("{");
        this.d_writer.tab();
        this.d_writer.println("int i,j,k,l,m,n,o;");
        this.d_writer.println("jint upper[7];");
        this.d_writer.println("jint lower[7] = {0,0,0,0,0,0,0};");
        this.d_writer.println("jclass exceptionClass = NULL;");
        this.d_writer.println("jintArray _lower = (*env)->NewIntArray(env, 7);");
        this.d_writer.println("(*env)->GetIntArrayRegion(env, _upper, 0, 7, upper);");
        this.d_writer.println("(*env)->SetIntArrayRegion(env, _lower, 0, 7, lower);");
        this.d_writer.println("" + generalSidlName + "__reallocate(env, obj, dim, _lower, _upper, isRow);");
        this.d_writer.println("(*env)->DeleteLocalRef(env, _lower);");
        this.d_writer.println("");
        this.d_writer.println("switch(dim) {");
        this.d_writer.tab();
        this.d_writer.println("case 1:");
        this.d_writer.println("for(i = 0; i <= upper[0]; ++i) {");
        this.d_writer.tab();
        this.d_writer.println("jobject tmp = (*env)->GetObjectArrayElement(env,orray, i);");
        this.d_writer.println("" + generalSidlName + "__set(env,obj,i,0,0,0,0,0,0,tmp);");
        this.d_writer.println("(*env)->DeleteLocalRef(env, tmp);");
        this.d_writer.println("}");
        this.d_writer.backTab();
        this.d_writer.println("break;");
        this.d_writer.println("case 2:");
        this.d_writer.println("for(j = 0; j <= upper[0]; ++j) {");
        this.d_writer.tab();
        this.d_writer.println("jobjectArray orray1 = (*env)->GetObjectArrayElement(env,orray, j);");
        this.d_writer.println("for(i = 0; i <= upper[1]; ++i) {");
        this.d_writer.tab();
        this.d_writer.println("jobject tmp = (*env)->GetObjectArrayElement(env,orray1, i);");
        this.d_writer.println("" + generalSidlName + "__set(env,obj,j,i,0,0,0,0,0,tmp);");
        this.d_writer.println("(*env)->DeleteLocalRef(env, tmp);");
        this.d_writer.println("}");
        this.d_writer.backTab();
        this.d_writer.println("(*env)->DeleteLocalRef(env, orray1);");
        this.d_writer.println("}");
        this.d_writer.backTab();
        this.d_writer.println("break;");
        this.d_writer.println("case 3:");
        this.d_writer.println("for(k = 0; k <= upper[0]; ++k) {");
        this.d_writer.tab();
        this.d_writer.println("jobjectArray orray1 = (*env)->GetObjectArrayElement(env,orray, k);");
        this.d_writer.println("for(j = 0; j <= upper[1]; ++j) {");
        this.d_writer.tab();
        this.d_writer.println("jobjectArray orray2 = (*env)->GetObjectArrayElement(env,orray1, j);");
        this.d_writer.println("for(i = 0; i <= upper[2]; ++i) {");
        this.d_writer.tab();
        this.d_writer.println("jobject tmp = (*env)->GetObjectArrayElement(env,orray2, i);");
        this.d_writer.println("" + generalSidlName + "__set(env,obj,k,j,i,0,0,0,0,tmp);");
        this.d_writer.println("(*env)->DeleteLocalRef(env, tmp);");
        this.d_writer.println("}");
        this.d_writer.backTab();
        this.d_writer.println("(*env)->DeleteLocalRef(env, orray2);");
        this.d_writer.println("}");
        this.d_writer.backTab();
        this.d_writer.println("(*env)->DeleteLocalRef(env, orray1);");
        this.d_writer.println("}");
        this.d_writer.backTab();
        this.d_writer.println("");
        this.d_writer.println("break;");
        this.d_writer.println("case 4:");
        this.d_writer.println("for(l = 0; l <= upper[0]; ++l) {");
        this.d_writer.tab();
        this.d_writer.println("jobjectArray orray1 = (*env)->GetObjectArrayElement(env,orray, l);");
        this.d_writer.println("for(k = 0; k <= upper[1]; ++k) {");
        this.d_writer.tab();
        this.d_writer.println("jobjectArray orray2 = (*env)->GetObjectArrayElement(env,orray1, k);");
        this.d_writer.println("for(j = 0; j <= upper[2]; ++j) {");
        this.d_writer.tab();
        this.d_writer.println("jobjectArray orray3 = (*env)->GetObjectArrayElement(env,orray2, j);");
        this.d_writer.println("for(i = 0; i <= upper[3]; ++i) {");
        this.d_writer.tab();
        this.d_writer.println("jobject tmp = (*env)->GetObjectArrayElement(env,orray3, i);");
        this.d_writer.println("" + generalSidlName + "__set(env,obj,l,k,j,i,0,0,0,tmp);");
        this.d_writer.println("(*env)->DeleteLocalRef(env, tmp);");
        this.d_writer.println("}");
        this.d_writer.backTab();
        this.d_writer.println("(*env)->DeleteLocalRef(env, orray3);");
        this.d_writer.println("}");
        this.d_writer.backTab();
        this.d_writer.println("(*env)->DeleteLocalRef(env, orray2);");
        this.d_writer.println("}   ");
        this.d_writer.backTab();
        this.d_writer.println("(*env)->DeleteLocalRef(env, orray1);");
        this.d_writer.println("}");
        this.d_writer.backTab();
        this.d_writer.println("(*env)->DeleteLocalRef(env, orray);");
        this.d_writer.println("");
        this.d_writer.println("break;");
        this.d_writer.println("case 5:");
        this.d_writer.println("for(m = 0; m <= upper[0]; ++m) {");
        this.d_writer.tab();
        this.d_writer.println("jobjectArray orray1 = (*env)->GetObjectArrayElement(env,orray, m);   ");
        this.d_writer.println("for(l = 0; l <= upper[1]; ++l) {");
        this.d_writer.tab();
        this.d_writer.println("jobjectArray orray2 = (*env)->GetObjectArrayElement(env,orray1, l);");
        this.d_writer.println("for(k = 0; k <= upper[2]; ++k) {");
        this.d_writer.tab();
        this.d_writer.println("jobjectArray orray3 = (*env)->GetObjectArrayElement(env,orray2, k);");
        this.d_writer.println("for(j = 0; j <= upper[3]; ++j) {");
        this.d_writer.tab();
        this.d_writer.println("jobjectArray orray4 = (*env)->GetObjectArrayElement(env,orray3, j);");
        this.d_writer.println("for(i = 0; i <= upper[4]; ++i) {");
        this.d_writer.tab();
        this.d_writer.println("jobject tmp = (*env)->GetObjectArrayElement(env,orray4, i);");
        this.d_writer.println("" + generalSidlName + "__set(env,obj,m,l,k,j,i,0,0,tmp);");
        this.d_writer.println("(*env)->DeleteLocalRef(env, tmp);");
        this.d_writer.println("}");
        this.d_writer.backTab();
        this.d_writer.println("(*env)->DeleteLocalRef(env, orray4);");
        this.d_writer.println("}");
        this.d_writer.backTab();
        this.d_writer.println("(*env)->DeleteLocalRef(env, orray3);");
        this.d_writer.println("}   ");
        this.d_writer.backTab();
        this.d_writer.println("(*env)->DeleteLocalRef(env, orray2);");
        this.d_writer.println("}");
        this.d_writer.backTab();
        this.d_writer.println("(*env)->DeleteLocalRef(env, orray1);");
        this.d_writer.println("}");
        this.d_writer.backTab();
        this.d_writer.println("(*env)->DeleteLocalRef(env, orray);");
        this.d_writer.println("");
        this.d_writer.println("break;");
        this.d_writer.println("case 6:");
        this.d_writer.println("for(n = 0; n <= upper[0]; ++n) {");
        this.d_writer.tab();
        this.d_writer.println("jobjectArray orray1 = (*env)->GetObjectArrayElement(env,orray, n);   ");
        this.d_writer.println("for(m = 0; m <= upper[1]; ++m) {");
        this.d_writer.tab();
        this.d_writer.println("jobjectArray orray2 = (*env)->GetObjectArrayElement(env,orray1, m);   ");
        this.d_writer.println("for(l = 0; l <= upper[2]; ++l) {");
        this.d_writer.tab();
        this.d_writer.println("jobjectArray orray3 = (*env)->GetObjectArrayElement(env,orray2, l);");
        this.d_writer.println("for(k = 0; k <= upper[3]; ++k) {");
        this.d_writer.tab();
        this.d_writer.println("jobjectArray orray4 = (*env)->GetObjectArrayElement(env,orray3, k);");
        this.d_writer.println("for(j = 0; j <= upper[4]; ++j) {");
        this.d_writer.tab();
        this.d_writer.println("jobjectArray orray5 = (*env)->GetObjectArrayElement(env,orray4, j);");
        this.d_writer.println("for(i = 0; i <= upper[5]; ++i) {");
        this.d_writer.tab();
        this.d_writer.println("jobject tmp = (*env)->GetObjectArrayElement(env,orray5, i);");
        this.d_writer.println("" + generalSidlName + "__set(env,obj,n,m,l,k,j,i,0,tmp);");
        this.d_writer.println("(*env)->DeleteLocalRef(env, tmp);");
        this.d_writer.println("}");
        this.d_writer.backTab();
        this.d_writer.println("(*env)->DeleteLocalRef(env, orray5);");
        this.d_writer.println("}");
        this.d_writer.backTab();
        this.d_writer.println("(*env)->DeleteLocalRef(env, orray4);");
        this.d_writer.println("}   ");
        this.d_writer.backTab();
        this.d_writer.println("(*env)->DeleteLocalRef(env, orray3);");
        this.d_writer.println("}");
        this.d_writer.backTab();
        this.d_writer.println("(*env)->DeleteLocalRef(env, orray2);");
        this.d_writer.println("}");
        this.d_writer.backTab();
        this.d_writer.println("(*env)->DeleteLocalRef(env, orray1);");
        this.d_writer.println("}");
        this.d_writer.backTab();
        this.d_writer.println("(*env)->DeleteLocalRef(env, orray);");
        this.d_writer.println("");
        this.d_writer.println("break;");
        this.d_writer.println("case 7:");
        this.d_writer.println("for(o = 0; o <= upper[0]; ++o) {");
        this.d_writer.tab();
        this.d_writer.println("jobjectArray orray1 = (*env)->GetObjectArrayElement(env,orray, o);   ");
        this.d_writer.println("for(n = 0; n <= upper[1]; ++n) {");
        this.d_writer.tab();
        this.d_writer.println("jobjectArray orray2 = (*env)->GetObjectArrayElement(env,orray1, n);   ");
        this.d_writer.println("for(m = 0; m <= upper[2]; ++m) {");
        this.d_writer.tab();
        this.d_writer.println("jobjectArray orray3 = (*env)->GetObjectArrayElement(env,orray2, m);   ");
        this.d_writer.println("for(l = 0; l <= upper[3]; ++l) {");
        this.d_writer.tab();
        this.d_writer.println("jobjectArray orray4 = (*env)->GetObjectArrayElement(env,orray3, l);");
        this.d_writer.println("for(k = 0; k <= upper[4]; ++k) {");
        this.d_writer.tab();
        this.d_writer.println("jobjectArray orray5 = (*env)->GetObjectArrayElement(env,orray4, k);");
        this.d_writer.println("for(j = 0; j <= upper[5]; ++j) {");
        this.d_writer.tab();
        this.d_writer.println("jobjectArray orray6 = (*env)->GetObjectArrayElement(env,orray5, j);");
        this.d_writer.println("for(i = 0; i <= upper[6]; ++i) {");
        this.d_writer.tab();
        this.d_writer.println("jobject tmp = (*env)->GetObjectArrayElement(env,orray6, i);");
        this.d_writer.println("" + generalSidlName + "__set(env,obj,o,n,m,l,k,j,i,tmp);");
        this.d_writer.println("(*env)->DeleteLocalRef(env, tmp);");
        this.d_writer.println("}");
        this.d_writer.backTab();
        this.d_writer.println("(*env)->DeleteLocalRef(env, orray6);");
        this.d_writer.println("}");
        this.d_writer.backTab();
        this.d_writer.println("(*env)->DeleteLocalRef(env, orray5);");
        this.d_writer.println("}   ");
        this.d_writer.backTab();
        this.d_writer.println("(*env)->DeleteLocalRef(env, orray4);");
        this.d_writer.println("}");
        this.d_writer.backTab();
        this.d_writer.println("(*env)->DeleteLocalRef(env, orray3);");
        this.d_writer.println("}");
        this.d_writer.backTab();
        this.d_writer.println("(*env)->DeleteLocalRef(env, orray2);");
        this.d_writer.println("}");
        this.d_writer.backTab();
        this.d_writer.println("(*env)->DeleteLocalRef(env, orray1);");
        this.d_writer.println("}");
        this.d_writer.backTab();
        this.d_writer.println("(*env)->DeleteLocalRef(env, orray);");
        this.d_writer.println("break;");
        this.d_writer.println("default:");
        this.d_writer.println("exceptionClass = (*env)->FindClass(env, \"java/lang/IllegalArgumentException\");");
        this.d_writer.println("(*env)->ThrowNew(env, exceptionClass,\"JNI:_fromArray: Array dimensions must be between 1-7!\");");
        this.d_writer.println("}");
        this.d_writer.backTab();
        this.d_writer.println("}");
        this.d_writer.backTab();
    }

    private void registerBaseInterfaceArrayFunctions(SymbolID id) {
        String generalSidlName = BabelConfiguration.getBaseInterface().replace('.', '_');
        String lookupName = BabelConfiguration.getBaseInterface().replace('.', '/');
        this.d_writer.println("JNINativeMethod methods1[6];");
        this.d_writer.println("jclass cls1;");
        this.d_writer.println("");
        this.d_writer.println("methods1[0].name      = \"_get\";");
        this.d_writer.println("methods1[0].signature = \"(IIIIIII)L" + lookupName + "$Wrapper;\";");
        this.d_writer.println("methods1[0].fnPtr     = " + generalSidlName + "__get;");
        this.d_writer.println("methods1[1].name      = \"_set\";");
        this.d_writer.println("methods1[1].signature = \"(IIIIIIIL" + lookupName + ";)V\";");
        this.d_writer.println("methods1[1].fnPtr     = " + generalSidlName + "__set;");
        this.d_writer.println("methods1[2].name      = \"_reallocate\";");
        this.d_writer.println("methods1[2].signature = \"(I[I[IZ)V\";");
        this.d_writer.println("methods1[2].fnPtr     = " + generalSidlName + "__reallocate;");
        this.d_writer.println("methods1[3].name      = \"_copy\";");
        this.d_writer.println("methods1[3].signature = \"(L" + lookupName + "$Array;)V\";");
        this.d_writer.println("methods1[3].fnPtr     = " + generalSidlName + "__copy;  ");
        this.d_writer.println("methods1[4].name      = \"_slice\";");
        this.d_writer.println("methods1[4].signature = \"(I[I[I[I[I)L" + lookupName + "$Array;\";");
        this.d_writer.println("methods1[4].fnPtr     = " + generalSidlName + "__slice;    ");
        this.d_writer.println("methods1[5].name      = \"_fromArray\";");
        this.d_writer.println("methods1[5].signature = \"([Ljava/lang/Object;I[IZ)V\";");
        this.d_writer.println("methods1[5].fnPtr     = " + generalSidlName + "__fromArray;");
        this.d_writer.println("");
        this.d_writer.println("");
        this.d_writer.println("cls1 = (*env)->FindClass(env, \"" + lookupName + "$Array\");");
        this.d_writer.println("if (cls1) {");
        this.d_writer.tab();
        this.d_writer.println("(*env)->RegisterNatives(env, cls1, methods1, 6);");
        this.d_writer.println("(*env)->DeleteLocalRef(env, cls1);");
        this.d_writer.backTab();
        this.d_writer.println("}");
    }
}

