/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views.tableitems.mytorrents;

import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.util.TimeFormatter;
import org.gudy.azureus2.plugins.ui.tables.TableCell;
import org.gudy.azureus2.plugins.ui.tables.TableCellRefreshListener;
import org.gudy.azureus2.ui.swt.views.table.utils.CoreTableColumn;

public class TrackerNextAccessItem
extends CoreTableColumn
implements TableCellRefreshListener {
    public TrackerNextAccessItem(String sTableID) {
        super("trackernextaccess", 2, -1, 70, sTableID);
        this.setRefreshInterval(-2);
    }

    public void refresh(TableCell cell) {
        DownloadManager dm = (DownloadManager)cell.getDataSource();
        long value = dm == null ? 0 : dm.getTrackerTime();
        if (value < -1L) {
            value = -1L;
        }
        if (value > 60L) {
            value = value - value % 60L + 60L;
        }
        if (!cell.setSortValue(value) && cell.isValid()) {
            return;
        }
        if (value > 60L) {
            cell.setText("< " + TimeFormatter.formatColon(value));
        } else {
            cell.setText(TimeFormatter.formatColon(value));
        }
    }
}

