/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views;

import com.aelitis.azureus.core.AzureusCore;
import java.util.Arrays;
import java.util.List;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;
import org.gudy.azureus2.core3.category.Category;
import org.gudy.azureus2.core3.category.CategoryManager;
import org.gudy.azureus2.core3.category.CategoryManagerListener;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.global.GlobalManager;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.plugins.sharing.ShareException;
import org.gudy.azureus2.plugins.sharing.ShareManager;
import org.gudy.azureus2.plugins.sharing.ShareManagerListener;
import org.gudy.azureus2.plugins.sharing.ShareResource;
import org.gudy.azureus2.plugins.sharing.ShareResourceDir;
import org.gudy.azureus2.plugins.sharing.ShareResourceFile;
import org.gudy.azureus2.plugins.torrent.TorrentAttribute;
import org.gudy.azureus2.pluginsimpl.local.torrent.TorrentManagerImpl;
import org.gudy.azureus2.ui.swt.Alerts;
import org.gudy.azureus2.ui.swt.CategoryAdderWindow;
import org.gudy.azureus2.ui.swt.ImageRepository;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.mainwindow.MainWindow;
import org.gudy.azureus2.ui.swt.views.TableView;
import org.gudy.azureus2.ui.swt.views.table.TableColumnCore;
import org.gudy.azureus2.ui.swt.views.table.TableRowCore;
import org.gudy.azureus2.ui.swt.views.tableitems.myshares.CategoryItem;
import org.gudy.azureus2.ui.swt.views.tableitems.myshares.NameItem;
import org.gudy.azureus2.ui.swt.views.tableitems.myshares.TypeItem;

public class MySharesView
extends TableView
implements ShareManagerListener,
CategoryManagerListener {
    private static final TableColumnCore[] basicItems = new TableColumnCore[]{new NameItem(), new TypeItem(), new CategoryItem()};
    protected static final TorrentAttribute category_attribute = TorrentManagerImpl.getSingleton().getAttribute("Category");
    private AzureusCore azureus_core;
    private GlobalManager global_manager;
    private Menu menuCategory;
    private boolean start;
    private boolean stop;
    private boolean remove;

    public MySharesView(AzureusCore _azureus_core) {
        super("MyShares", "MySharesView", basicItems, "name", 67586);
        this.azureus_core = _azureus_core;
        this.global_manager = this.azureus_core.getGlobalManager();
    }

    public void initialize(Composite composite) {
        super.initialize(composite);
        this.getTable().addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent mEvent) {
                TableItem[] tis = MySharesView.this.getTable().getSelection();
                if (tis.length == 0) {
                    return;
                }
                ShareResource share = (ShareResource)MySharesView.this.getFirstSelectedDataSource();
                if (share != null) {
                    List dms = MySharesView.this.global_manager.getDownloadManagers();
                    int i = 0;
                    while (i < dms.size()) {
                        DownloadManager dm = (DownloadManager)dms.get(i);
                        try {
                            byte[] share_hash = null;
                            if (share.getType() == 2) {
                                share_hash = ((ShareResourceDir)share).getItem().getTorrent().getHash();
                            } else if (share.getType() == 1) {
                                share_hash = ((ShareResourceFile)share).getItem().getTorrent().getHash();
                            }
                            if (Arrays.equals(share_hash, dm.getTorrent().getHash())) {
                                MainWindow.getWindow().openManagerView(dm);
                                break;
                            }
                        }
                        catch (Throwable e) {
                            Debug.printStackTrace(e);
                        }
                        ++i;
                    }
                }
            }
        });
        this.createRows();
        CategoryManager.addCategoryManagerListener(this);
    }

    private void createRows() {
        try {
            ShareManager sm = this.azureus_core.getPluginManager().getDefaultPluginInterface().getShareManager();
            ShareResource[] shares = sm.getShares();
            int i = 0;
            while (i < shares.length) {
                this.resourceAdded(shares[i]);
                ++i;
            }
            sm.addListener(this);
        }
        catch (ShareException e) {
            Debug.printStackTrace(e);
        }
    }

    public void tableStructureChanged() {
        super.tableStructureChanged();
        this.createRows();
    }

    public void fillMenu(Menu menu) {
        this.menuCategory = new Menu((Decorations)this.getComposite().getShell(), 4);
        MenuItem itemCategory = new MenuItem(menu, 64);
        Messages.setLanguageText((Widget)itemCategory, "MyTorrentsView.menu.setCategory");
        itemCategory.setMenu(this.menuCategory);
        this.addCategorySubMenu();
        new MenuItem(menu, 2);
        final MenuItem itemRemove = new MenuItem(menu, 8);
        Messages.setLanguageText((Widget)itemRemove, "MySharesView.menu.remove");
        itemRemove.setImage(ImageRepository.getImage("delete"));
        menu.addListener(22, new Listener(){

            public void handleEvent(Event e) {
                Object[] shares = MySharesView.this.getSelectedDataSources();
                itemRemove.setEnabled(shares.length > 0);
            }
        });
        itemRemove.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                MySharesView.this.removeSelectedShares();
            }
        });
        new MenuItem(menu, 2);
        super.fillMenu(menu);
    }

    public void resourceAdded(ShareResource resource) {
        this.addDataSource(resource);
    }

    public void resourceModified(ShareResource resource) {
    }

    public void resourceDeleted(ShareResource resource) {
        this.removeDataSource(resource);
    }

    public void reportProgress(int percent_complete) {
    }

    public void reportCurrentTask(String task_description) {
    }

    public void refresh() {
        if (this.getComposite() == null || this.getComposite().isDisposed()) {
            return;
        }
        this.computePossibleActions();
        MainWindow.getWindow().refreshIconBar();
        super.refresh();
    }

    private void addCategorySubMenu() {
        MenuItem[] items = this.menuCategory.getItems();
        int i = 0;
        while (i < items.length) {
            items[i].dispose();
            ++i;
        }
        Object[] categories = CategoryManager.getCategories();
        Arrays.sort(categories);
        if (categories.length > 0) {
            MenuItem itemCategory;
            Category catUncat = CategoryManager.getCategory(2);
            if (catUncat != null) {
                itemCategory = new MenuItem(this.menuCategory, 8);
                Messages.setLanguageText((Widget)itemCategory, catUncat.getName());
                itemCategory.setData("Category", (Object)catUncat);
                itemCategory.addListener(13, new Listener(){

                    public void handleEvent(Event event) {
                        MenuItem item = (MenuItem)event.widget;
                        MySharesView.this.assignSelectedToCategory((Category)item.getData("Category"));
                    }
                });
                new MenuItem(this.menuCategory, 2);
            }
            i = 0;
            while (i < categories.length) {
                if (categories[i].getType() == 0) {
                    itemCategory = new MenuItem(this.menuCategory, 8);
                    itemCategory.setText(categories[i].getName());
                    itemCategory.setData("Category", categories[i]);
                    itemCategory.addListener(13, new Listener(){

                        public void handleEvent(Event event) {
                            MenuItem item = (MenuItem)event.widget;
                            MySharesView.this.assignSelectedToCategory((Category)item.getData("Category"));
                        }
                    });
                }
                ++i;
            }
            new MenuItem(this.menuCategory, 2);
        }
        MenuItem itemAddCategory = new MenuItem(this.menuCategory, 8);
        Messages.setLanguageText((Widget)itemAddCategory, "MyTorrentsView.menu.setCategory.add");
        itemAddCategory.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                MySharesView.this.addCategory();
            }
        });
    }

    public void categoryAdded(Category category) {
        MainWindow.getWindow().getDisplay().asyncExec((Runnable)new AERunnable(){

            public void runSupport() {
                MySharesView.this.addCategorySubMenu();
            }
        });
    }

    public void categoryRemoved(Category category) {
        MainWindow.getWindow().getDisplay().asyncExec((Runnable)new AERunnable(){

            public void runSupport() {
                MySharesView.this.addCategorySubMenu();
            }
        });
    }

    private void addCategory() {
        CategoryAdderWindow adderWindow = new CategoryAdderWindow(MainWindow.getWindow().getDisplay());
        Category newCategory = adderWindow.getNewCategory();
        if (newCategory != null) {
            this.assignSelectedToCategory(newCategory);
        }
    }

    private void assignSelectedToCategory(final Category category) {
        this.runForSelectedRows(new TableView.GroupTableRowRunner(this){

            public void run(TableRowCore row) {
                String value = category == null ? null : (category == CategoryManager.getCategory(2) ? null : category.getName());
                ((ShareResource)row.getDataSource(true)).setAttribute(category_attribute, value);
            }
        });
    }

    public void delete() {
        super.delete();
        try {
            this.azureus_core.getPluginManager().getDefaultPluginInterface().getShareManager().removeListener(this);
        }
        catch (ShareException e) {
            Debug.printStackTrace(e);
        }
        MainWindow.getWindow().setMyShares(null);
    }

    private void computePossibleActions() {
        this.remove = false;
        this.stop = false;
        this.start = false;
        Object[] shares = this.getSelectedDataSources();
        if (shares.length > 0) {
            this.remove = true;
            int i = 0;
            while (i < shares.length) {
                ++i;
            }
        }
    }

    public boolean isEnabled(String itemKey) {
        if (itemKey.equals("start")) {
            return this.start;
        }
        if (itemKey.equals("stop")) {
            return this.stop;
        }
        if (itemKey.equals("remove")) {
            return this.remove;
        }
        return false;
    }

    public void itemActivated(String itemKey) {
        if (itemKey.equals("remove")) {
            this.removeSelectedShares();
            return;
        }
    }

    private void removeSelectedShares() {
        Object[] shares = this.getSelectedDataSources();
        int i = 0;
        while (i < shares.length) {
            try {
                ((ShareResource)shares[i]).delete();
            }
            catch (Throwable e) {
                Alerts.showErrorMessageBoxUsingResourceString("globalmanager.download.remove.veto", e);
            }
            ++i;
        }
    }
}

