/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views;

import java.util.Calendar;
import java.util.GregorianCalendar;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.ScrollBar;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.logging.ILoggerListener;
import org.gudy.azureus2.core3.logging.LGLogger;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.ui.swt.mainwindow.Colors;
import org.gudy.azureus2.ui.swt.mainwindow.MainWindow;
import org.gudy.azureus2.ui.swt.views.AbstractIView;

public class ConsoleView
extends AbstractIView
implements ILoggerListener {
    Display display;
    StyledText consoleText;
    Color[] colors;

    public void initialize(Composite composite) {
        this.display = composite.getDisplay();
        this.consoleText = new StyledText(composite, 776);
        this.colors = new Color[4];
        this.colors[0] = Colors.blues[3];
        this.colors[1] = Colors.blues[2];
        this.colors[2] = Colors.blues[1];
        this.colors[3] = Colors.red_ConsoleView;
        LGLogger.setListener(this);
    }

    public Composite getComposite() {
        return this.consoleText;
    }

    public void refresh() {
    }

    public void delete() {
        LGLogger.removeListener();
        MainWindow.getWindow().getShell().setFocus();
        MainWindow.getWindow().setConsole(null);
        this.consoleText.dispose();
    }

    public String getFullTitle() {
        return MessageText.getString("ConsoleView.title.full");
    }

    public void log(int componentId, int event, int color, String text) {
        if (color < 0 || color > this.colors.length || this.display == null || this.display.isDisposed()) {
            return;
        }
        this.doLog(color, text);
    }

    private void doLog(final int _color, final String _text) {
        if (this.display == null || this.display.isDisposed()) {
            return;
        }
        this.display.asyncExec((Runnable)new AERunnable(){

            public void runSupport() {
                if (ConsoleView.this.consoleText == null || ConsoleView.this.consoleText.isDisposed()) {
                    return;
                }
                ScrollBar sb = ConsoleView.this.consoleText.getVerticalBar();
                boolean autoScroll = sb.getSelection() == sb.getMaximum() - sb.getThumb();
                int nbLines = ConsoleView.this.consoleText.getLineCount();
                if (nbLines > 4352) {
                    ConsoleView.this.consoleText.replaceTextRange(0, ConsoleView.this.consoleText.getOffsetAtLine(256), "");
                }
                Calendar now = GregorianCalendar.getInstance();
                String timeStamp = "[".concat(String.valueOf(now.get(11))).concat(":").concat(ConsoleView.this.format(now.get(12))).concat(":").concat(ConsoleView.this.format(now.get(13))).concat("]  ");
                ConsoleView.this.consoleText.append(String.valueOf(timeStamp) + _text + "\n");
                nbLines = ConsoleView.this.consoleText.getLineCount();
                ConsoleView.this.consoleText.setLineBackground(nbLines - 2, 1, ConsoleView.this.colors[_color]);
                if (autoScroll) {
                    ConsoleView.this.consoleText.setTopIndex(nbLines - 1);
                }
            }
        });
    }

    private String format(int n) {
        if (n < 10) {
            return "0".concat(String.valueOf(n));
        }
        return String.valueOf(n);
    }
}

