/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt;

import java.io.File;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.global.GlobalManager;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.TorrentUtils;
import org.gudy.azureus2.ui.swt.ImageRepository;
import org.gudy.azureus2.ui.swt.Messages;

public class OpenTorrentWindow {
    private boolean bUseFolderBrowse = false;
    private Text lTorrentInfo;
    private Text txtTorrent;
    private Shell shell;

    public OpenTorrentWindow(Display display, GlobalManager gm) {
        this.shell = new Shell(display, 67696);
        this.shell.setText(MessageText.getString("OpenTorrentWindow.title"));
        if (!Constants.isOSX) {
            this.shell.setImage(ImageRepository.getImage("azureus"));
        }
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        this.shell.setLayout((Layout)layout);
        this.shell.addListener(11, new Listener(){

            public void handleEvent(Event e) {
                OpenTorrentWindow.this.shell.layout();
            }
        });
        Label label = new Label((Composite)this.shell, 2112);
        Messages.setLanguageText((Widget)label, "OpenTorrentWindow.message");
        GridData gridData = new GridData(256);
        gridData.horizontalSpan = 3;
        label.setLayoutData((Object)gridData);
        label = new Label((Composite)this.shell, 0);
        gridData = new GridData(2);
        label.setLayoutData((Object)gridData);
        Messages.setLanguageText((Widget)label, "OpenTorrentWindow.torrentLocation");
        this.txtTorrent = new Text((Composite)this.shell, 2562);
        gridData = new GridData(1808);
        gridData.heightHint = 50;
        gridData.widthHint = 450;
        this.txtTorrent.setLayoutData((Object)gridData);
        Button browseTorrent = new Button((Composite)this.shell, 8);
        gridData = new GridData(2);
        browseTorrent.setLayoutData((Object)gridData);
        Messages.setLanguageText((Widget)browseTorrent, "OpenTorrentWindow.addFiles");
        browseTorrent.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                FileDialog fDialog = new FileDialog(OpenTorrentWindow.this.shell, 4098);
                fDialog.setFilterExtensions(new String[]{"*.torrent", "*.tor", "*.*"});
                fDialog.setFilterNames(new String[]{"*.torrent", "*.tor", "*.*"});
                fDialog.setText(MessageText.getString("MainWindow.dialog.choose.file"));
                String fileName = fDialog.open();
                if (fileName != null) {
                    String[] sTorrentFilenames = fDialog.getFileNames();
                    String sTorrentFilePath = fDialog.getFilterPath();
                    String sTorrentFiles = String.valueOf(sTorrentFilePath) + File.separator + sTorrentFilenames[0];
                    int i = 1;
                    while (i < sTorrentFilenames.length) {
                        sTorrentFiles = String.valueOf(sTorrentFiles) + '\n' + sTorrentFilePath + File.separator + sTorrentFilenames[i];
                        ++i;
                    }
                    OpenTorrentWindow.this.txtTorrent.setText(sTorrentFiles);
                    OpenTorrentWindow.this.checkTorrentFiles();
                }
            }
        });
        this.lTorrentInfo = new Text((Composite)this.shell, 578);
        this.lTorrentInfo.setVisible(false);
        gridData = new GridData(256);
        gridData.heightHint = 0;
        gridData.horizontalSpan = 3;
        this.lTorrentInfo.setLayoutData((Object)gridData);
        this.lTorrentInfo.setBackground(label.getBackground());
        this.lTorrentInfo.setForeground(label.getForeground());
        label = new Label((Composite)this.shell, 0);
        Messages.setLanguageText((Widget)label, "OpenTorrentWindow.dataLocation");
        final Text txtData = new Text((Composite)this.shell, 2048);
        gridData = new GridData(256);
        txtData.setLayoutData((Object)gridData);
        Button browseData = new Button((Composite)this.shell, 8);
        Messages.setLanguageText((Widget)browseData, "ConfigView.button.browse");
        browseData.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                String sSavePath;
                File f;
                String sDefPath;
                String string = sDefPath = COConfigurationManager.getBooleanParameter("Use default data dir") ? COConfigurationManager.getStringParameter("Default save path", "") : "";
                if (sDefPath.length() > 0 && !(f = new File(sDefPath)).exists()) {
                    f.mkdirs();
                }
                if (OpenTorrentWindow.this.bUseFolderBrowse) {
                    DirectoryDialog dDialog = new DirectoryDialog(OpenTorrentWindow.this.shell, 131072);
                    dDialog.setFilterPath(sDefPath);
                    dDialog.setMessage(MessageText.getString("MainWindow.dialog.choose.savepath"));
                    sSavePath = dDialog.open();
                } else {
                    FileDialog fDialog = new FileDialog(OpenTorrentWindow.this.shell, 131072);
                    fDialog.setFilterPath(sDefPath);
                    fDialog.setText(MessageText.getString("MainWindow.dialog.choose.file"));
                    sSavePath = fDialog.open();
                }
                if (sSavePath != null) {
                    txtData.setText(sSavePath);
                }
            }
        });
        Composite cArea = new Composite((Composite)this.shell, 0);
        layout = new GridLayout();
        layout.numColumns = 2;
        layout.verticalSpacing = 0;
        cArea.setLayout((Layout)layout);
        gridData = new GridData();
        gridData.horizontalSpan = 3;
        cArea.setLayoutData((Object)gridData);
        Group gStartModes = new Group(cArea, 0);
        gStartModes.setLayout((Layout)new GridLayout());
        gridData = new GridData(2);
        gStartModes.setLayoutData((Object)gridData);
        String[] startModes = new String[]{"queued", "stopped", "forceStarted"};
        Messages.setLanguageText((Widget)gStartModes, "OpenTorrentWindow.startMode");
        int i = 0;
        while (i < startModes.length) {
            Button radioButton = new Button((Composite)gStartModes, 16);
            Messages.setLanguageText((Widget)radioButton, "OpenTorrentWindow.startMode." + startModes[i]);
            gridData = new GridData();
            radioButton.setLayoutData((Object)gridData);
            if (i == 0) {
                radioButton.setSelection(true);
            }
            ++i;
        }
        Group gQueueLocations = new Group(cArea, 0);
        gQueueLocations.setLayout((Layout)new GridLayout());
        gridData = new GridData(2);
        gQueueLocations.setLayoutData((Object)gridData);
        Messages.setLanguageText((Widget)gQueueLocations, "OpenTorrentWindow.addPosition");
        String[] queueLocations = new String[]{"first", "last"};
        int i2 = 0;
        while (i2 < queueLocations.length) {
            Button radioButton = new Button((Composite)gQueueLocations, 16);
            Messages.setLanguageText((Widget)radioButton, "OpenTorrentWindow.addPosition." + queueLocations[i2]);
            gridData = new GridData();
            radioButton.setLayoutData((Object)gridData);
            if (i2 == 0) {
                radioButton.setSelection(true);
            }
            ++i2;
        }
        cArea = new Composite((Composite)this.shell, 0);
        layout = new GridLayout();
        layout.numColumns = 2;
        layout.verticalSpacing = 0;
        cArea.setLayout((Layout)layout);
        gridData = new GridData(128);
        gridData.horizontalSpan = 3;
        cArea.setLayoutData((Object)gridData);
        Button ok = new Button(cArea, 8);
        ok.setEnabled(false);
        Messages.setLanguageText((Widget)ok, "Button.ok");
        gridData = new GridData(128);
        gridData.widthHint = 70;
        ok.setLayoutData((Object)gridData);
        this.shell.setDefaultButton(ok);
        ok.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                OpenTorrentWindow.this.shell.dispose();
            }
        });
        Button cancel = new Button(cArea, 8);
        Messages.setLanguageText((Widget)cancel, "Button.cancel");
        gridData = new GridData();
        gridData.widthHint = 70;
        cancel.setLayoutData((Object)gridData);
        cancel.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                OpenTorrentWindow.this.shell.dispose();
            }
        });
        this.shell.pack();
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
    }

    private void checkTorrentFiles() {
        String[] sFileNames = this.txtTorrent.getText().split("\r\n");
        String sMessages = "";
        int numFiles = 0;
        int i = 0;
        while (i < sFileNames.length) {
            if (sFileNames[i] != "") {
                ++numFiles;
                try {
                    TOTorrent torrent = TorrentUtils.readFromFile(new File(sFileNames[i]), false);
                    if (!this.bUseFolderBrowse && !torrent.isSimpleTorrent()) {
                        this.bUseFolderBrowse = true;
                    }
                }
                catch (Exception e) {
                    sMessages = String.valueOf(sMessages) + sFileNames[i] + ": " + e.getMessage() + "\n";
                }
            }
            ++i;
        }
        if (!this.bUseFolderBrowse && numFiles > 1) {
            this.bUseFolderBrowse = true;
        }
        this.lTorrentInfo.setText(sMessages);
        this.lTorrentInfo.setVisible(sMessages != "");
        GridData gd = (GridData)this.lTorrentInfo.getLayoutData();
        gd.heightHint = sMessages == "" ? 0 : 50;
        this.shell.layout();
    }
}

