/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt;

import com.aelitis.azureus.core.AzureusCore;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.ipfilter.BadIp;
import org.gudy.azureus2.core3.ipfilter.BannedIp;
import org.gudy.azureus2.core3.ipfilter.BlockedIp;
import org.gudy.azureus2.core3.ipfilter.IpRange;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.DisplayFormatters;
import org.gudy.azureus2.ui.swt.ImageRepository;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.Utils;

public class BlockedIpsWindow {
    static AzureusCore azureus_core;

    public static void show(AzureusCore _azureus_core, Display display, String ipsBlocked, String ipsBanned) {
        azureus_core = _azureus_core;
        final Shell window = new Shell(display, 67696);
        Messages.setLanguageText((Widget)window, "ConfigView.section.ipfilter.list.title");
        if (!Constants.isOSX) {
            window.setImage(ImageRepository.getImage("azureus"));
        }
        FormLayout layout = new FormLayout();
        try {
            layout.spacing = 5;
        }
        catch (NoSuchFieldError noSuchFieldError) {
            // empty catch block
        }
        layout.marginHeight = 5;
        layout.marginWidth = 5;
        window.setLayout((Layout)layout);
        final StyledText textBlocked = new StyledText((Composite)window, 2816);
        Button btnClear = new Button((Composite)window, 8);
        textBlocked.setEditable(false);
        final StyledText textBanned = new StyledText((Composite)window, 2816);
        Button btnOk = new Button((Composite)window, 8);
        Button btnReset = new Button((Composite)window, 8);
        textBanned.setEditable(false);
        FormData formData = new FormData();
        formData.left = new FormAttachment(0, 0);
        formData.right = new FormAttachment(100, 0);
        formData.top = new FormAttachment(0, 0);
        formData.bottom = new FormAttachment(40, 0);
        textBlocked.setLayoutData((Object)formData);
        textBlocked.setText(ipsBlocked);
        Label blockedInfo = new Label((Composite)window, 0);
        Messages.setLanguageText((Widget)blockedInfo, "ConfigView.section.ipfilter.blockedinfo");
        formData = new FormData();
        formData.top = new FormAttachment((Control)textBlocked);
        formData.right = new FormAttachment((Control)btnClear);
        formData.left = new FormAttachment(0, 0);
        blockedInfo.setLayoutData((Object)formData);
        Messages.setLanguageText((Widget)btnClear, "Button.clear");
        formData = new FormData();
        formData.top = new FormAttachment((Control)textBlocked);
        formData.right = new FormAttachment(95, 0);
        formData.width = 70;
        btnClear.setLayoutData((Object)formData);
        btnClear.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                azureus_core.getIpFilterManager().getIPFilter().clearBlockedIPs();
                textBlocked.setText("");
            }
        });
        formData = new FormData();
        formData.left = new FormAttachment(0, 0);
        formData.right = new FormAttachment(100, 0);
        formData.top = new FormAttachment((Control)btnClear);
        formData.bottom = new FormAttachment((Control)btnOk);
        textBanned.setLayoutData((Object)formData);
        textBanned.setText(ipsBanned);
        Label bannedInfo = new Label((Composite)window, 0);
        Messages.setLanguageText((Widget)bannedInfo, "ConfigView.section.ipfilter.bannedinfo");
        formData = new FormData();
        formData.right = new FormAttachment((Control)btnReset);
        formData.left = new FormAttachment(0, 0);
        formData.bottom = new FormAttachment(100, 0);
        bannedInfo.setLayoutData((Object)formData);
        Messages.setLanguageText((Widget)btnReset, "Button.reset");
        formData = new FormData();
        formData.right = new FormAttachment((Control)btnOk);
        formData.bottom = new FormAttachment(100, 0);
        formData.width = 70;
        btnReset.setLayoutData((Object)formData);
        btnReset.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                azureus_core.getIpFilterManager().getIPFilter().clearBannedIps();
                azureus_core.getIpFilterManager().getBadIps().clearBadIps();
                textBanned.setText("");
            }
        });
        Messages.setLanguageText((Widget)btnOk, "Button.ok");
        formData = new FormData();
        formData.right = new FormAttachment(95, 0);
        formData.bottom = new FormAttachment(100, 0);
        formData.width = 70;
        btnOk.setLayoutData((Object)formData);
        btnOk.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                window.dispose();
            }
        });
        window.setDefaultButton(btnOk);
        window.addListener(31, new Listener(){

            public void handleEvent(Event e) {
                if (e.character == '\u001b') {
                    window.dispose();
                }
            }
        });
        window.setSize(620, 450);
        window.layout();
        Utils.centreWindow(window);
        window.open();
    }

    public static void showBlockedIps(AzureusCore azureus_core, Shell mainWindow) {
        StringBuffer sbBlocked = new StringBuffer();
        StringBuffer sbBanned = new StringBuffer();
        BlockedIp[] blocked = azureus_core.getIpFilterManager().getIPFilter().getBlockedIps();
        String inRange = MessageText.getString("ConfigView.section.ipfilter.list.inrange");
        String notInRange = MessageText.getString("ConfigView.section.ipfilter.list.notinrange");
        String bannedMessage = MessageText.getString("ConfigView.section.ipfilter.list.banned");
        String badDataMessage = MessageText.getString("ConfigView.section.ipfilter.list.baddata");
        int i = 0;
        while (i < blocked.length) {
            BlockedIp bIp = blocked[i];
            sbBlocked.append(DisplayFormatters.formatTimeStamp(bIp.getBlockedTime()));
            sbBlocked.append("\t[");
            sbBlocked.append(bIp.getTorrentName());
            sbBlocked.append("] \t");
            sbBlocked.append(bIp.getBlockedIp());
            IpRange range = bIp.getBlockingRange();
            if (range == null) {
                sbBlocked.append(' ');
                sbBlocked.append(notInRange);
                sbBlocked.append('\n');
            } else {
                sbBlocked.append(' ');
                sbBlocked.append(inRange);
                sbBlocked.append(range.toString());
                sbBlocked.append('\n');
            }
            ++i;
        }
        BannedIp[] banned_ips = azureus_core.getIpFilterManager().getIPFilter().getBannedIps();
        int i2 = 0;
        while (i2 < banned_ips.length) {
            BannedIp bIp = banned_ips[i2];
            sbBanned.append(DisplayFormatters.formatTimeStamp(bIp.getBanningTime()));
            sbBanned.append("\t[");
            sbBanned.append(bIp.getTorrentName());
            sbBanned.append("] \t");
            sbBanned.append(bIp.getIp());
            sbBanned.append(" ");
            sbBanned.append(bannedMessage);
            sbBanned.append("\n");
            ++i2;
        }
        BadIp[] bad_ips = azureus_core.getIpFilterManager().getBadIps().getBadIps();
        int i3 = 0;
        while (i3 < bad_ips.length) {
            BadIp bIp = bad_ips[i3];
            sbBanned.append(DisplayFormatters.formatTimeStamp(bIp.getLastTime()));
            sbBanned.append("\t");
            sbBanned.append(bIp.getIp());
            sbBanned.append(" ");
            sbBanned.append(badDataMessage);
            sbBanned.append(" ");
            sbBanned.append(bIp.getNumberOfWarnings());
            sbBanned.append("\n");
            ++i3;
        }
        if (mainWindow == null || mainWindow.isDisposed()) {
            return;
        }
        BlockedIpsWindow.show(azureus_core, mainWindow.getDisplay(), sbBlocked.toString(), sbBanned.toString());
    }
}

