/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local.installer;

import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import org.gudy.azureus2.core3.logging.LGLogger;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.plugins.Plugin;
import org.gudy.azureus2.plugins.PluginException;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.PluginManager;
import org.gudy.azureus2.plugins.UnloadablePlugin;
import org.gudy.azureus2.plugins.installer.FilePluginInstaller;
import org.gudy.azureus2.plugins.installer.InstallablePlugin;
import org.gudy.azureus2.plugins.installer.PluginInstaller;
import org.gudy.azureus2.plugins.installer.StandardPlugin;
import org.gudy.azureus2.plugins.update.UpdatableComponent;
import org.gudy.azureus2.plugins.update.UpdateCheckInstance;
import org.gudy.azureus2.plugins.update.UpdateCheckInstanceListener;
import org.gudy.azureus2.plugins.update.UpdateChecker;
import org.gudy.azureus2.plugins.update.UpdateInstaller;
import org.gudy.azureus2.plugins.update.UpdateManager;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloader;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloaderAdapter;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloaderException;
import org.gudy.azureus2.pluginsimpl.local.PluginInterfaceImpl;
import org.gudy.azureus2.pluginsimpl.local.installer.FilePluginInstallerImpl;
import org.gudy.azureus2.pluginsimpl.local.installer.InstallablePluginImpl;
import org.gudy.azureus2.pluginsimpl.local.installer.StandardPluginImpl;
import org.gudy.azureus2.pluginsimpl.update.PluginUpdatePlugin;
import org.gudy.azureus2.pluginsimpl.update.sf.SFPluginDetails;
import org.gudy.azureus2.pluginsimpl.update.sf.SFPluginDetailsException;
import org.gudy.azureus2.pluginsimpl.update.sf.SFPluginDetailsLoader;
import org.gudy.azureus2.pluginsimpl.update.sf.SFPluginDetailsLoaderFactory;

public class PluginInstallerImpl
implements PluginInstaller {
    protected static PluginInstallerImpl singleton;
    protected PluginManager manager;
    static /* synthetic */ Class class$0;

    public static PluginInstallerImpl getSingleton(PluginManager _manager) {
        if (singleton == null) {
            singleton = new PluginInstallerImpl(_manager);
        }
        return singleton;
    }

    protected PluginInstallerImpl(PluginManager _manager) {
        this.manager = _manager;
    }

    protected PluginManager getPluginManager() {
        return this.manager;
    }

    public StandardPlugin[] getStandardPlugins() throws PluginException {
        try {
            SFPluginDetailsLoader loader = SFPluginDetailsLoaderFactory.getSingleton();
            SFPluginDetails[] details = loader.getPluginDetails();
            ArrayList<StandardPluginImpl> res = new ArrayList<StandardPluginImpl>();
            int i = 0;
            while (i < details.length) {
                SFPluginDetails detail = details[i];
                String name = detail.getId();
                String version = detail.getVersion();
                if (!name.startsWith("azplatform") && !name.equals("azupdater") && version != null && version.length() != 0 && Character.isDigit(version.charAt(0))) {
                    res.add(new StandardPluginImpl(this, details[i]));
                }
                ++i;
            }
            StandardPlugin[] res_a = new StandardPlugin[res.size()];
            res.toArray(res_a);
            return res_a;
        }
        catch (SFPluginDetailsException e) {
            throw new PluginException("Failed to load standard plugin details", e);
        }
    }

    public FilePluginInstaller installFromFile(File file) throws PluginException {
        return new FilePluginInstallerImpl(this, file);
    }

    public void install(InstallablePlugin installable_plugin, boolean shared) throws PluginException {
        this.install(new InstallablePlugin[]{installable_plugin}, shared);
    }

    public void install(InstallablePlugin[] plugins, boolean shared) throws PluginException {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.gudy.azureus2.pluginsimpl.update.PluginUpdatePlugin");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        PluginUpdatePlugin pup = (PluginUpdatePlugin)this.manager.getPluginInterfaceByClass(clazz).getPlugin();
        UpdateManager uman = this.manager.getDefaultPluginInterface().getUpdateManager();
        UpdateCheckInstance inst = uman.createEmptyUpdateCheckInstance(1, "update.instance.install");
        try {
            int i = 0;
            while (i < plugins.length) {
                InstallablePlugin plugin = plugins[i];
                String plugin_id = plugin.getId();
                PluginInterface existing_plugin_interface = this.manager.getPluginInterfaceByID(plugin_id);
                Plugin existing_plugin = null;
                if (existing_plugin_interface != null) {
                    existing_plugin = existing_plugin_interface.getPlugin();
                    String old_version = existing_plugin_interface.getPluginVersion();
                    if (old_version != null) {
                        int res = Constants.compareVersions(plugin.getVersion(), old_version);
                        if (res < 0) {
                            throw new PluginException("A higher version (" + old_version + ") of Plugin '" + plugin_id + "' is already installed");
                        }
                        if (res == 0) {
                            throw new PluginException("Version (" + old_version + ") of Plugin '" + plugin_id + "' is already installed");
                        }
                    }
                }
                String target_dir = shared ? FileUtil.getApplicationFile("plugins").toString() : FileUtil.getUserFile("plugins").toString();
                target_dir = String.valueOf(target_dir) + File.separator + plugin_id;
                new File(target_dir).mkdir();
                if (existing_plugin == null) {
                    final dummyPlugin dummy_plugin = new dummyPlugin(plugin_id, target_dir);
                    PluginManager.registerPlugin(dummy_plugin, plugin_id);
                    PluginInterface dummy_plugin_interface = this.manager.getPluginInterfaceByID(plugin_id);
                    ((InstallablePluginImpl)((Object)plugin)).addUpdate(inst, pup, dummy_plugin, dummy_plugin_interface);
                    inst.addListener(new UpdateCheckInstanceListener(){

                        public void cancelled(UpdateCheckInstance instance) {
                            dummy_plugin.requestUnload();
                        }

                        public void complete(UpdateCheckInstance instance) {
                            dummy_plugin.requestUnload();
                        }
                    });
                } else {
                    ((InstallablePluginImpl)((Object)plugin)).addUpdate(inst, pup, existing_plugin, existing_plugin_interface);
                }
                ++i;
            }
            inst.start();
        }
        catch (Throwable e) {
            inst.cancel();
            if (e instanceof PluginException) {
                throw (PluginException)e;
            }
            throw new PluginException("Failed to create installer", e);
        }
    }

    public void uninstall(InstallablePlugin standard_plugin) throws PluginException {
        PluginInterface pi = standard_plugin.getAlreadyInstalledPlugin();
        if (pi == null) {
            throw new PluginException(" Plugin '" + standard_plugin.getId() + "' is not installed");
        }
        pi.uninstall();
    }

    public void uninstall(PluginInterface pi) throws PluginException {
        this.uninstall(new PluginInterface[]{pi});
    }

    public void uninstall(PluginInterface[] pis) throws PluginException {
        int i = 0;
        while (i < pis.length) {
            PluginInterface pi = pis[i];
            if (pi.isMandatory()) {
                throw new PluginException("Plugin '" + pi.getPluginID() + "' is mandatory, can't uninstall");
            }
            if (pi.isBuiltIn()) {
                throw new PluginException("Plugin '" + pi.getPluginID() + "' is built-in, can't uninstall");
            }
            String plugin_dir = pi.getPluginDirectoryName();
            if (plugin_dir == null || !new File(plugin_dir).exists()) {
                throw new PluginException("Plugin '" + pi.getPluginID() + "' is not loaded from the file system, can't uninstall");
            }
            ++i;
        }
        try {
            UpdateManager uman = this.manager.getDefaultPluginInterface().getUpdateManager();
            UpdateCheckInstance inst = uman.createEmptyUpdateCheckInstance(3, "update.instance.uninstall");
            int i2 = 0;
            while (i2 < pis.length) {
                final PluginInterface pi = pis[i2];
                final String plugin_dir = pi.getPluginDirectoryName();
                inst.addUpdatableComponent(new UpdatableComponent(){

                    public String getName() {
                        return pi.getPluginName();
                    }

                    public int getMaximumCheckTime() {
                        return 0;
                    }

                    public void checkForUpdate(UpdateChecker checker) {
                        try {
                            ResourceDownloader rd = PluginInstallerImpl.this.manager.getDefaultPluginInterface().getUtilities().getResourceDownloaderFactory().create(new File(plugin_dir));
                            rd.addListener(new ResourceDownloaderAdapter(this, pi, plugin_dir, checker){
                                final /* synthetic */ 2 this$1;
                                private final /* synthetic */ PluginInterface val$pi;
                                private final /* synthetic */ String val$plugin_dir;
                                private final /* synthetic */ UpdateChecker val$checker;
                                {
                                    this.this$1 = var1_1;
                                    this.val$pi = pluginInterface;
                                    this.val$plugin_dir = string;
                                    this.val$checker = updateChecker;
                                }

                                public boolean completed(ResourceDownloader downloader, InputStream data) {
                                    try {
                                        if (this.val$pi.isUnloadable()) {
                                            this.val$pi.unload();
                                            FileUtil.recursiveDelete(new File(this.val$plugin_dir));
                                        } else {
                                            UpdateInstaller installer = this.val$checker.createInstaller();
                                            installer.addRemoveAction(new File(this.val$plugin_dir).getCanonicalPath());
                                        }
                                    }
                                    catch (Throwable e) {
                                        Debug.printStackTrace(e);
                                        LGLogger.logRepeatableAlert("Plugin uninstall failed", e);
                                    }
                                    return true;
                                }

                                public void failed(ResourceDownloader downloader, ResourceDownloaderException e) {
                                    if (!downloader.isCancelled()) {
                                        LGLogger.logRepeatableAlert("Plugin uninstall failed", e);
                                    }
                                }
                            });
                            String update_name = "";
                            PluginInterface[] ifs = PluginInstallerImpl.this.manager.getPluginInterfaces();
                            Arrays.sort(ifs, new Comparator(this){
                                final /* synthetic */ 2 this$1;
                                {
                                    this.this$1 = var1_1;
                                }

                                public int compare(Object o1, Object o2) {
                                    return ((PluginInterface)o1).getPluginName().compareTo(((PluginInterface)o2).getPluginName());
                                }
                            });
                            int i = 0;
                            while (i < ifs.length) {
                                if (ifs[i].getPluginID().equals(pi.getPluginID())) {
                                    update_name = String.valueOf(update_name) + (update_name.length() == 0 ? "" : ",") + ifs[i].getPluginName();
                                }
                                ++i;
                            }
                            checker.addUpdate(update_name, new String[]{"Uninstall: " + plugin_dir}, pi.getPluginVersion(), rd, pi.isUnloadable() ? 1 : 2);
                        }
                        finally {
                            checker.completed();
                        }
                    }
                }, false);
                ++i2;
            }
            inst.start();
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
    }

    protected PluginInterface getAlreadyInstalledPlugin(String id) {
        return this.getPluginManager().getPluginInterfaceByID(id);
    }

    protected class dummyPlugin
    implements UnloadablePlugin {
        protected String plugin_name;
        protected String plugin_dir;
        protected PluginInterfaceImpl plugin_interface;

        protected dummyPlugin(String _name, String _target_dir) {
            this.plugin_name = _name;
            this.plugin_dir = _target_dir;
        }

        public void initialize(PluginInterface _plugin_interface) {
            this.plugin_interface = (PluginInterfaceImpl)_plugin_interface;
            this.plugin_interface.setPluginVersion("0.0");
            this.plugin_interface.setPluginName(this.plugin_name);
            this.plugin_interface.setPluginDirectoryName(this.plugin_dir);
        }

        public void unload() {
        }

        protected void requestUnload() {
            try {
                this.plugin_interface.unload();
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
    }
}

