/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.AEThread;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.SimpleTimer;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.ThreadPool;
import org.gudy.azureus2.core3.util.ThreadPoolTask;
import org.gudy.azureus2.core3.util.TimerEvent;
import org.gudy.azureus2.core3.util.TimerEventPerformer;

public class ThreadPool {
    protected static final int IDLE_LINGER_TIME = 10000;
    protected static final boolean LOG_WARNINGS = false;
    protected static final int WARN_TIME = 10000;
    protected static List busy_pools = new ArrayList();
    protected static boolean busy_pool_timer_set = false;
    protected String name;
    protected int thread_name_index = 1;
    protected long execution_limit;
    protected Stack thread_pool;
    protected List busy;
    protected AESemaphore thread_sem;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void checkAllTimeouts() {
        ArrayList pools;
        List list = busy_pools;
        synchronized (list) {
            pools = new ArrayList(busy_pools);
        }
        int i = 0;
        while (i < pools.size()) {
            ((ThreadPool)pools.get(i)).checkTimeouts();
            ++i;
        }
    }

    public ThreadPool(String _name, int max_size) {
        this.name = _name;
        this.thread_sem = new AESemaphore("ThreadPool::" + this.name, max_size);
        this.thread_pool = new Stack();
        this.busy = new ArrayList(max_size);
    }

    public void setExecutionLimit(long millis) {
        this.execution_limit = millis;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public threadPoolWorker run(AERunnable runnable) {
        threadPoolWorker allocated_worker;
        this.thread_sem.reserve();
        ThreadPool threadPool = this;
        synchronized (threadPool) {
            allocated_worker = this.thread_pool.isEmpty() ? new threadPoolWorker() : (threadPoolWorker)this.thread_pool.pop();
            if (runnable instanceof ThreadPoolTask) {
                ((ThreadPoolTask)runnable).worker = allocated_worker;
            }
            allocated_worker.run(runnable);
        }
        return allocated_worker;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkTimeouts() {
        ThreadPool threadPool = this;
        synchronized (threadPool) {
            long now = SystemTime.getCurrentTime();
            int i = 0;
            while (i < this.busy.size()) {
                threadPoolWorker x = (threadPoolWorker)this.busy.get(i);
                long elapsed = now - x.run_start_time;
                if (elapsed > (long)(10000 * (x.warn_count + 1))) {
                    ++x.warn_count;
                    if (this.execution_limit > 0L && elapsed > this.execution_limit) {
                        AERunnable r = x.runnable;
                        try {
                            if (r instanceof ThreadPoolTask) {
                                ((ThreadPoolTask)r).interruptTask();
                            } else {
                                x.worker_thread.interrupt();
                            }
                        }
                        catch (Throwable e) {
                            Debug.printStackTrace(e);
                        }
                    }
                }
                ++i;
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public class threadPoolWorker {
        protected String worker_name;
        protected Thread worker_thread;
        protected AESemaphore my_sem = new AESemaphore("TPWorker");
        protected AERunnable runnable;
        protected long run_start_time;
        protected int warn_count;
        protected String state = "<none>";

        protected threadPoolWorker() {
            this.worker_name = String.valueOf(ThreadPool.this.name) + "[" + ThreadPool.this.thread_name_index++ + "]";
            this.worker_thread = new AEThread(this, this.worker_name){
                final /* synthetic */ threadPoolWorker this$1;
                {
                    this.this$1 = threadPoolWorker2;
                    super($anonymous0);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Unable to fully structure code
                 */
                public void runSupport() {
                    time_to_die = false;
                    block37: while (true) {
                        try {
                            try {
                                while (!this.this$1.my_sem.reserve(10000L)) {
                                    var2_2 = threadPoolWorker.access$0(this.this$1);
                                    synchronized (var2_2) {
                                        if (this.this$1.runnable != null) ** break block44
                                        time_to_die = true;
                                        threadPoolWorker.access$0((threadPoolWorker)this.this$1).thread_pool.remove(this.this$1);
                                        // MONITOREXIT @DISABLED, blocks:[0, 1, 2, 37, 38, 15] lbl13 : MonitorExitStatement: MONITOREXIT : var2_2
                                        if (time_to_die) break block37;
                                    }
                                    var10_8 = threadPoolWorker.access$0(this.this$1);
                                    synchronized (var10_8) {
                                        threadPoolWorker.access$0((threadPoolWorker)this.this$1).thread_pool.push(this.this$1);
                                    }
                                    threadPoolWorker.access$0((threadPoolWorker)this.this$1).thread_sem.release();
                                    break block37;
                                    {
                                    }
                                }
                                try {
                                    var2_2 = threadPoolWorker.access$0(this.this$1);
                                    synchronized (var2_2) {
                                        this.this$1.run_start_time = SystemTime.getCurrentTime();
                                        this.this$1.warn_count = 0;
                                        threadPoolWorker.access$0((threadPoolWorker)this.this$1).busy.add(this.this$1);
                                        if (threadPoolWorker.access$0((threadPoolWorker)this.this$1).busy.size() == 1) {
                                            var3_4 = ThreadPool.busy_pools;
                                            synchronized (var3_4) {
                                                ThreadPool.busy_pools.add(threadPoolWorker.access$0(this.this$1));
                                                if (!ThreadPool.busy_pool_timer_set) {
                                                    ThreadPool.busy_pool_timer_set = true;
                                                    SimpleTimer.addPeriodicEvent(10000L, new TimerEventPerformer(this){
                                                        final /* synthetic */ 1 this$2;
                                                        {
                                                            this.this$2 = var1_1;
                                                        }

                                                        public void perform(TimerEvent event) {
                                                            ThreadPool.checkAllTimeouts();
                                                        }
                                                    });
                                                }
                                            }
                                        }
                                    }
                                    this.this$1.runnable.run();
                                }
                                catch (Throwable var4_9) {
                                    var5_5 = threadPoolWorker.access$0(this.this$1);
                                    synchronized (var5_5) {
                                        elapsed = SystemTime.getCurrentTime() - this.this$1.run_start_time;
                                        threadPoolWorker.access$0((threadPoolWorker)this.this$1).busy.remove(this.this$1);
                                        if (threadPoolWorker.access$0((threadPoolWorker)this.this$1).busy.size() == 0) {
                                            var8_7 = ThreadPool.busy_pools;
                                            synchronized (var8_7) {
                                                ThreadPool.busy_pools.remove(threadPoolWorker.access$0(this.this$1));
                                            }
                                        }
                                    }
                                    this.this$1.runnable = null;
                                    throw var4_9;
                                }
                                var5_5 = threadPoolWorker.access$0(this.this$1);
                                synchronized (var5_5) {
                                    elapsed = SystemTime.getCurrentTime() - this.this$1.run_start_time;
                                    threadPoolWorker.access$0((threadPoolWorker)this.this$1).busy.remove(this.this$1);
                                    if (threadPoolWorker.access$0((threadPoolWorker)this.this$1).busy.size() == 0) {
                                        var8_7 = ThreadPool.busy_pools;
                                        synchronized (var8_7) {
                                            ThreadPool.busy_pools.remove(threadPoolWorker.access$0(this.this$1));
                                        }
                                    }
                                }
                                this.this$1.runnable = null;
                            }
                            catch (Throwable e) {
                                Debug.printStackTrace(e);
                            }
                        }
                        catch (Throwable var9_10) {
                            if (!time_to_die) {
                                var10_8 = threadPoolWorker.access$0(this.this$1);
                                synchronized (var10_8) {
                                    threadPoolWorker.access$0((threadPoolWorker)this.this$1).thread_pool.push(this.this$1);
                                }
                                threadPoolWorker.access$0((threadPoolWorker)this.this$1).thread_sem.release();
                            }
                            throw var9_10;
                        }
                        if (time_to_die) continue;
                        var10_8 = threadPoolWorker.access$0(this.this$1);
                        synchronized (var10_8) {
                            threadPoolWorker.access$0((threadPoolWorker)this.this$1).thread_pool.push(this.this$1);
                        }
                        threadPoolWorker.access$0((threadPoolWorker)this.this$1).thread_sem.release();
                    }
                }
            };
            this.worker_thread.setDaemon(true);
            this.worker_thread.start();
        }

        public void setState(String _state) {
            this.state = _state;
        }

        public String getState() {
            return this.state;
        }

        protected String getWorkerName() {
            return this.worker_name;
        }

        protected void run(AERunnable _runnable) {
            this.runnable = _runnable;
            this.my_sem.release();
        }

        static /* synthetic */ ThreadPool access$0(threadPoolWorker threadPoolWorker2) {
            return threadPoolWorker2.ThreadPool.this;
        }
    }
}

