/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.util;

import java.nio.ByteBuffer;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.ConcurrentHasher;
import org.gudy.azureus2.core3.util.ConcurrentHasherRequestListener;
import org.gudy.azureus2.core3.util.SHA1Hasher;

public class ConcurrentHasherRequest {
    protected static AEMonitor class_mon = new AEMonitor("ConcHashRequest:class");
    protected ConcurrentHasher concurrent_hasher;
    protected ByteBuffer buffer;
    protected ConcurrentHasherRequestListener listener;
    protected byte[] result;
    protected boolean cancelled;
    protected AESemaphore sem = new AESemaphore("ConcHashRequest");

    protected ConcurrentHasherRequest(ConcurrentHasher _concurrent_hasher, ByteBuffer _buffer, ConcurrentHasherRequestListener _listener) {
        this.concurrent_hasher = _concurrent_hasher;
        this.buffer = _buffer;
        this.listener = _listener;
    }

    public byte[] getResult() {
        this.sem.reserve();
        return this.result;
    }

    public void cancel() {
        if (!this.cancelled) {
            ConcurrentHasherRequestListener listener_copy;
            this.cancelled = true;
            this.sem.releaseForever();
            try {
                class_mon.enter();
                listener_copy = this.listener;
                this.listener = null;
            }
            finally {
                class_mon.exit();
            }
            if (listener_copy != null) {
                listener_copy.complete(this);
            }
        }
    }

    public boolean getCancelled() {
        return this.cancelled;
    }

    protected void run(SHA1Hasher hasher) {
        if (!this.cancelled) {
            this.result = hasher.calculateHash(this.buffer);
            this.sem.releaseForever();
            if (!this.cancelled) {
                ConcurrentHasherRequestListener listener_copy;
                try {
                    class_mon.enter();
                    listener_copy = this.listener;
                    this.listener = null;
                }
                finally {
                    class_mon.exit();
                }
                if (listener_copy != null) {
                    listener_copy.complete(this);
                }
            }
        }
    }
}

