/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.tracker.server.impl.udp;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.SecureRandom;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.gudy.azureus2.core3.logging.LGLogger;
import org.gudy.azureus2.core3.tracker.protocol.PRHelpers;
import org.gudy.azureus2.core3.tracker.protocol.udp.PRUDPPacket;
import org.gudy.azureus2.core3.tracker.protocol.udp.PRUDPPacketReplyAnnounce;
import org.gudy.azureus2.core3.tracker.protocol.udp.PRUDPPacketReplyAnnounce2;
import org.gudy.azureus2.core3.tracker.protocol.udp.PRUDPPacketReplyConnect;
import org.gudy.azureus2.core3.tracker.protocol.udp.PRUDPPacketReplyError;
import org.gudy.azureus2.core3.tracker.protocol.udp.PRUDPPacketReplyScrape;
import org.gudy.azureus2.core3.tracker.protocol.udp.PRUDPPacketReplyScrape2;
import org.gudy.azureus2.core3.tracker.protocol.udp.PRUDPPacketRequest;
import org.gudy.azureus2.core3.tracker.protocol.udp.PRUDPPacketRequestAnnounce;
import org.gudy.azureus2.core3.tracker.protocol.udp.PRUDPPacketRequestAnnounce2;
import org.gudy.azureus2.core3.tracker.protocol.udp.PRUDPPacketRequestScrape;
import org.gudy.azureus2.core3.tracker.server.impl.TRTrackerServerPeerImpl;
import org.gudy.azureus2.core3.tracker.server.impl.TRTrackerServerProcessor;
import org.gudy.azureus2.core3.tracker.server.impl.TRTrackerServerTorrentImpl;
import org.gudy.azureus2.core3.tracker.server.impl.udp.TRTrackerServerUDP;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.HashWrapper;
import org.gudy.azureus2.core3.util.SHA1Hasher;
import org.gudy.azureus2.core3.util.SystemTime;

public class TRTrackerServerProcessorUDP
extends TRTrackerServerProcessor {
    public static final long CONNECTION_ID_LIFETIME = 180000L;
    protected TRTrackerServerUDP server;
    protected DatagramSocket socket;
    protected DatagramPacket packet;
    protected static Map connection_id_map = new LinkedHashMap();
    protected static SecureRandom random = new SecureRandom();
    protected static AEMonitor random_mon = new AEMonitor("TRTrackerServerUDP:rand");

    protected TRTrackerServerProcessorUDP(TRTrackerServerUDP _server, DatagramSocket _socket, DatagramPacket _packet) {
        this.server = _server;
        this.socket = _socket;
        this.packet = _packet;
    }

    public void runSupport() {
        byte[] _data = this.packet.getData();
        byte[] data = new byte[this.packet.getLength()];
        System.arraycopy(_data, 0, data, 0, data.length);
        int packet_data_length = data.length;
        String auth_user = null;
        byte[] auth_user_bytes = null;
        byte[] auth_hash = null;
        if (this.server.isTrackerPasswordEnabled()) {
            if (data.length < 17) {
                LGLogger.log("TRTrackerServerProcessorUDP: packet received but authorisation missing");
                return;
            }
            auth_user_bytes = new byte[8];
            auth_hash = new byte[8];
            System.arraycopy(data, packet_data_length -= 16, auth_user_bytes, 0, 8);
            int user_len = 0;
            while (user_len < 8 && auth_user_bytes[user_len] != 0) {
                ++user_len;
            }
            auth_user = new String(auth_user_bytes, 0, user_len);
            System.arraycopy(data, packet_data_length + 8, auth_hash, 0, 8);
        }
        DataInputStream is = new DataInputStream(new ByteArrayInputStream(data, 0, packet_data_length));
        try {
            String client_ip_address = this.packet.getAddress().getHostAddress();
            PRUDPPacketRequest request2 = PRUDPPacketRequest.deserialiseRequest(is);
            LGLogger.log("TRTrackerServerProcessorUDP: packet received: " + request2.getString());
            PRUDPPacket reply = null;
            if (auth_user_bytes != null) {
                byte[] sha1_pw = null;
                if (this.server.hasExternalAuthorisation()) {
                    try {
                        URL resource = new URL("udp://" + this.server.getHost() + ":" + this.server.getPort() + "/");
                        sha1_pw = this.server.performExternalAuthorisation(resource, auth_user);
                    }
                    catch (MalformedURLException e) {
                        Debug.printStackTrace(e);
                    }
                    if (sha1_pw == null) {
                        LGLogger.log("TRTrackerServerProcessorUDP: auth fails for user '" + auth_user + "'");
                        reply = new PRUDPPacketReplyError(request2.getTransactionId(), "Access Denied");
                    }
                } else {
                    sha1_pw = this.server.getPassword();
                }
                if (reply == null) {
                    SHA1Hasher hasher = new SHA1Hasher();
                    hasher.update(data, 0, packet_data_length);
                    hasher.update(auth_user_bytes);
                    hasher.update(sha1_pw);
                    byte[] digest = hasher.getDigest();
                    int i = 0;
                    while (i < auth_hash.length) {
                        if (auth_hash[i] != digest[i]) {
                            LGLogger.log("TRTrackerServerProcessorUDP: auth fails for user '" + auth_user + "'");
                            reply = new PRUDPPacketReplyError(request2.getTransactionId(), "Access Denied");
                            break;
                        }
                        ++i;
                    }
                }
            }
            if (reply == null) {
                try {
                    int type = request2.getAction();
                    reply = type == 0 ? this.handleConnect(client_ip_address, request2) : (type == 1 ? this.handleAnnounceAndScrape(client_ip_address, request2, 1) : (type == 2 ? this.handleAnnounceAndScrape(client_ip_address, request2, 2) : new PRUDPPacketReplyError(request2.getTransactionId(), "unsupported action")));
                }
                catch (Throwable e) {
                    String error = e.getMessage();
                    if (error == null) {
                        error = e.toString();
                    }
                    reply = new PRUDPPacketReplyError(request2.getTransactionId(), error);
                }
            }
            if (reply != null) {
                InetAddress address = this.packet.getAddress();
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                DataOutputStream os = new DataOutputStream(baos);
                reply.serialise(os);
                byte[] buffer = baos.toByteArray();
                DatagramPacket reply_packet = new DatagramPacket(buffer, buffer.length, address, this.packet.getPort());
                this.socket.send(reply_packet);
            }
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
    }

    public void interruptTask() {
    }

    protected long allocateConnectionId(String client_address) {
        try {
            random_mon.enter();
            long id = random.nextLong();
            Long new_key = new Long(id);
            connectionData new_data = new connectionData(client_address);
            Iterator it = connection_id_map.keySet().iterator();
            while (it.hasNext()) {
                Long key = (Long)it.next();
                connectionData data = (connectionData)connection_id_map.get(key);
                if (new_data.getTime() - data.getTime() <= 180000L) break;
                it.remove();
            }
            connection_id_map.put(new_key, new_data);
            long l = id;
            random_mon.exit();
            return l;
        }
        catch (Throwable throwable) {
            random_mon.exit();
            throw throwable;
        }
    }

    protected boolean checkConnectionId(String client_address, long id) {
        boolean ok;
        connectionData data;
        Long key;
        block3: {
            try {
                random_mon.enter();
                key = new Long(id);
                data = (connectionData)connection_id_map.get(key);
                if (data != null) break block3;
                random_mon.exit();
                return false;
            }
            catch (Throwable throwable) {
                random_mon.exit();
                throw throwable;
            }
        }
        connection_id_map.remove(key);
        boolean bl = ok = data.getAddress().equals(client_address);
        random_mon.exit();
        return bl;
    }

    protected PRUDPPacket handleConnect(String client_ip_address, PRUDPPacketRequest request2) {
        long conn_id = this.allocateConnectionId(client_ip_address);
        PRUDPPacketReplyConnect reply = new PRUDPPacketReplyConnect(request2.getTransactionId(), conn_id);
        return reply;
    }

    protected PRUDPPacket handleAnnounceAndScrape(String client_ip_address, PRUDPPacketRequest request2, int request_type) throws Exception {
        if (!this.checkConnectionId(client_ip_address, request2.getConnectionId())) {
            return null;
        }
        byte[] hash_bytes = null;
        HashWrapper peer_id = null;
        short port = 0;
        String event = null;
        long uploaded = 0L;
        long downloaded = 0L;
        long left = 0L;
        int num_want = -1;
        String key = null;
        if (request_type == 1) {
            int i_ip;
            int i_event;
            PRUDPPacketRequest announce;
            if (PRUDPPacket.VERSION == 1) {
                announce = (PRUDPPacketRequestAnnounce)request2;
                hash_bytes = ((PRUDPPacketRequestAnnounce)announce).getHash();
                peer_id = new HashWrapper(((PRUDPPacketRequestAnnounce)announce).getPeerId());
                port = ((PRUDPPacketRequestAnnounce)announce).getPort();
                i_event = ((PRUDPPacketRequestAnnounce)announce).getEvent();
                switch (i_event) {
                    case 2: {
                        event = "started";
                        break;
                    }
                    case 3: {
                        event = "stopped";
                        break;
                    }
                    case 1: {
                        event = "completed";
                    }
                }
                uploaded = ((PRUDPPacketRequestAnnounce)announce).getUploaded();
                downloaded = ((PRUDPPacketRequestAnnounce)announce).getDownloaded();
                left = ((PRUDPPacketRequestAnnounce)announce).getLeft();
                num_want = ((PRUDPPacketRequestAnnounce)announce).getNumWant();
                i_ip = ((PRUDPPacketRequestAnnounce)announce).getIPAddress();
                if (i_ip != 0) {
                    client_ip_address = PRHelpers.intToAddress(i_ip);
                }
            } else {
                announce = (PRUDPPacketRequestAnnounce2)request2;
                hash_bytes = ((PRUDPPacketRequestAnnounce2)announce).getHash();
                peer_id = new HashWrapper(((PRUDPPacketRequestAnnounce2)announce).getPeerId());
                port = ((PRUDPPacketRequestAnnounce2)announce).getPort();
                i_event = ((PRUDPPacketRequestAnnounce2)announce).getEvent();
                switch (i_event) {
                    case 2: {
                        event = "started";
                        break;
                    }
                    case 3: {
                        event = "stopped";
                        break;
                    }
                    case 1: {
                        event = "completed";
                    }
                }
                uploaded = ((PRUDPPacketRequestAnnounce2)announce).getUploaded();
                downloaded = ((PRUDPPacketRequestAnnounce2)announce).getDownloaded();
                left = ((PRUDPPacketRequestAnnounce2)announce).getLeft();
                num_want = ((PRUDPPacketRequestAnnounce2)announce).getNumWant();
                i_ip = ((PRUDPPacketRequestAnnounce2)announce).getIPAddress();
                if (i_ip != 0) {
                    client_ip_address = PRHelpers.intToAddress(i_ip);
                }
                key = "" + ((PRUDPPacketRequestAnnounce2)announce).getKey();
            }
        } else {
            PRUDPPacketRequestScrape scrape = (PRUDPPacketRequestScrape)request2;
            hash_bytes = scrape.getHash();
        }
        Map[] root_out = new Map[1];
        TRTrackerServerPeerImpl[] peer_out = new TRTrackerServerPeerImpl[1];
        TRTrackerServerTorrentImpl torrent = this.processTrackerRequest(this.server, root_out, peer_out, request_type, hash_bytes, peer_id, false, false, key, event, port, client_ip_address, downloaded, uploaded, left, num_want);
        Map root = root_out[0];
        if (request_type == 1) {
            if (PRUDPPacket.VERSION == 1) {
                PRUDPPacketReplyAnnounce reply = new PRUDPPacketReplyAnnounce(request2.getTransactionId());
                reply.setInterval(((Long)root.get("interval")).intValue());
                List peers = (List)root.get("peers");
                int[] addresses = new int[peers.size()];
                short[] ports = new short[addresses.length];
                int i = 0;
                while (i < addresses.length) {
                    Map peer = (Map)peers.get(i);
                    addresses[i] = PRHelpers.addressToInt(new String((byte[])peer.get("ip")));
                    ports[i] = ((Long)peer.get("port")).shortValue();
                    ++i;
                }
                reply.setPeers(addresses, ports);
                return reply;
            }
            PRUDPPacketReplyAnnounce2 reply = new PRUDPPacketReplyAnnounce2(request2.getTransactionId());
            reply.setInterval(((Long)root.get("interval")).intValue());
            boolean local_scrape = client_ip_address.equals("127.0.0.1");
            Map scrape_details = torrent.exportScrapeToMap(!local_scrape);
            int seeders = ((Long)scrape_details.get("complete")).intValue();
            int leechers = ((Long)scrape_details.get("incomplete")).intValue();
            reply.setLeechersSeeders(leechers, seeders);
            List peers = (List)root.get("peers");
            int[] addresses = new int[peers.size()];
            short[] ports = new short[addresses.length];
            int i = 0;
            while (i < addresses.length) {
                Map peer = (Map)peers.get(i);
                addresses[i] = PRHelpers.addressToInt(new String((byte[])peer.get("ip")));
                ports[i] = ((Long)peer.get("port")).shortValue();
                ++i;
            }
            reply.setPeers(addresses, ports);
            return reply;
        }
        if (PRUDPPacket.VERSION == 1) {
            PRUDPPacketReplyScrape reply = new PRUDPPacketReplyScrape(request2.getTransactionId());
            Map files = (Map)root.get("files");
            byte[][] hashes = new byte[files.size()][];
            int[] s_complete = new int[hashes.length];
            int[] s_downloaded = new int[hashes.length];
            int[] s_incomplete = new int[hashes.length];
            Iterator it = files.keySet().iterator();
            int pos = 0;
            while (it.hasNext()) {
                String hash_str = (String)it.next();
                hashes[pos] = hash_str.getBytes("ISO-8859-1");
                Map details = (Map)files.get(hash_str);
                s_complete[pos] = ((Long)details.get("complete")).intValue();
                s_incomplete[pos] = ((Long)details.get("incomplete")).intValue();
                s_downloaded[pos] = ((Long)details.get("downloaded")).intValue();
                ++pos;
            }
            reply.setDetails(hashes, s_complete, s_downloaded, s_incomplete);
            return reply;
        }
        PRUDPPacketReplyScrape2 reply = new PRUDPPacketReplyScrape2(request2.getTransactionId());
        Map files = (Map)root.get("files");
        int[] s_complete = new int[files.size()];
        int[] s_downloaded = new int[s_complete.length];
        int[] s_incomplete = new int[s_complete.length];
        Iterator it = files.keySet().iterator();
        int pos = 0;
        while (it.hasNext()) {
            String hash_str = (String)it.next();
            Map details = (Map)files.get(hash_str);
            s_complete[pos] = ((Long)details.get("complete")).intValue();
            s_incomplete[pos] = ((Long)details.get("incomplete")).intValue();
            s_downloaded[pos] = ((Long)details.get("downloaded")).intValue();
            ++pos;
        }
        reply.setDetails(s_complete, s_downloaded, s_incomplete);
        return reply;
    }

    protected static class connectionData {
        protected String address;
        protected long time;

        protected connectionData(String _address) {
            this.address = _address;
            this.time = SystemTime.getCurrentTime();
        }

        protected String getAddress() {
            return this.address;
        }

        protected long getTime() {
            return this.time;
        }
    }
}

