/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.ipfilter.impl;

import java.util.HashMap;
import java.util.Map;
import org.gudy.azureus2.core3.ipfilter.BadIp;
import org.gudy.azureus2.core3.ipfilter.BadIps;
import org.gudy.azureus2.core3.ipfilter.impl.BadIpImpl;
import org.gudy.azureus2.core3.util.AEMonitor;

public class BadIpsImpl
implements BadIps {
    private static BadIps instance;
    private static AEMonitor class_mon;
    private Map bad_ip_map;
    private AEMonitor bad_ip_map_mon = new AEMonitor("BadIps:Map");

    static {
        class_mon = new AEMonitor("BadIps:class");
    }

    public static BadIps getInstance() {
        try {
            class_mon.enter();
            if (instance == null) {
                instance = new BadIpsImpl();
            }
            BadIps badIps = instance;
            class_mon.exit();
            return badIps;
        }
        catch (Throwable throwable) {
            class_mon.exit();
            throw throwable;
        }
    }

    public BadIpsImpl() {
        this.bad_ip_map = new HashMap();
    }

    public int addWarningForIp(String ip) {
        try {
            this.bad_ip_map_mon.enter();
            BadIpImpl bad_ip = (BadIpImpl)this.bad_ip_map.get(ip);
            if (bad_ip == null) {
                bad_ip = new BadIpImpl(ip);
                this.bad_ip_map.put(ip, bad_ip);
            }
            int n = bad_ip.incrementWarnings();
            this.bad_ip_map_mon.exit();
            return n;
        }
        catch (Throwable throwable) {
            this.bad_ip_map_mon.exit();
            throw throwable;
        }
    }

    public int getNbWarningForIp(String ip) {
        BadIpImpl bad_ip;
        block3: {
            try {
                this.bad_ip_map_mon.enter();
                bad_ip = (BadIpImpl)this.bad_ip_map.get(ip);
                if (bad_ip != null) break block3;
                this.bad_ip_map_mon.exit();
                return 0;
            }
            catch (Throwable throwable) {
                this.bad_ip_map_mon.exit();
                throw throwable;
            }
        }
        int n = bad_ip.getNumberOfWarnings();
        this.bad_ip_map_mon.exit();
        return n;
    }

    public BadIp[] getBadIps() {
        try {
            this.bad_ip_map_mon.enter();
            BadIp[] res = new BadIp[this.bad_ip_map.size()];
            this.bad_ip_map.values().toArray(res);
            BadIp[] badIpArray = res;
            this.bad_ip_map_mon.exit();
            return badIpArray;
        }
        catch (Throwable throwable) {
            this.bad_ip_map_mon.exit();
            throw throwable;
        }
    }

    public void clearBadIps() {
        try {
            this.bad_ip_map_mon.enter();
            this.bad_ip_map.clear();
        }
        finally {
            this.bad_ip_map_mon.exit();
        }
    }

    public int getNbBadIps() {
        return this.bad_ip_map.size();
    }
}

