/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.networkmanager;

import com.aelitis.azureus.core.networkmanager.Connection;
import com.aelitis.azureus.core.networkmanager.NetworkManager;
import com.aelitis.azureus.core.networkmanager.RateControlledWriteEntity;
import com.aelitis.azureus.core.networkmanager.RateHandler;
import java.io.IOException;
import org.gudy.azureus2.core3.util.Debug;

public class BurstingSinglePeerUploader
implements RateControlledWriteEntity {
    private final Connection connection;
    private final RateHandler rate_handler;

    public BurstingSinglePeerUploader(Connection connection, RateHandler rate_handler) {
        this.connection = connection;
        this.rate_handler = rate_handler;
    }

    public boolean canWrite() {
        if (!this.connection.getTransport().isReadyForWrite()) {
            return false;
        }
        if (this.connection.getOutgoingMessageQueue().getTotalSize() < 1) {
            return false;
        }
        return this.rate_handler.getCurrentNumBytesAllowed() >= 1;
    }

    public boolean doWrite() {
        int mss;
        if (!this.connection.getTransport().isReadyForWrite()) {
            Debug.out("dW:not ready");
            return false;
        }
        int num_bytes_allowed = this.rate_handler.getCurrentNumBytesAllowed();
        if (num_bytes_allowed < 1) {
            return false;
        }
        int num_bytes_available = this.connection.getOutgoingMessageQueue().getTotalSize();
        if (num_bytes_available < 1) {
            Debug.out("dW:not avail");
            return false;
        }
        int num_bytes_to_write = num_bytes_allowed > num_bytes_available ? num_bytes_available : num_bytes_allowed;
        if (num_bytes_to_write > (mss = NetworkManager.getSingleton().getTcpMssSize())) {
            num_bytes_to_write = mss;
        }
        int written = 0;
        try {
            written = this.connection.getOutgoingMessageQueue().deliverToTransport(this.connection.getTransport(), num_bytes_to_write, false);
        }
        catch (IOException e) {
            this.connection.notifyOfException(e);
        }
        if (written < 1) {
            return false;
        }
        this.rate_handler.bytesWritten(written);
        return true;
    }

    public int getPriority() {
        return 0;
    }
}

