/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.diskmanager.cache.impl;

import com.aelitis.azureus.core.diskmanager.cache.CacheFile;
import com.aelitis.azureus.core.diskmanager.cache.CacheFileManagerException;
import com.aelitis.azureus.core.diskmanager.cache.impl.CacheFileManagerImpl;
import com.aelitis.azureus.core.diskmanager.file.FMFile;
import com.aelitis.azureus.core.diskmanager.file.FMFileManagerException;
import java.io.File;
import org.gudy.azureus2.core3.torrent.TOTorrentFile;
import org.gudy.azureus2.core3.util.DirectByteBuffer;

public class CacheFileWithoutCache
implements CacheFile {
    protected CacheFileManagerImpl manager;
    protected FMFile file;
    protected TOTorrentFile torrent_file;

    protected CacheFileWithoutCache(CacheFileManagerImpl _manager, FMFile _file, TOTorrentFile _torrent_file) {
        this.manager = _manager;
        this.file = _file;
        this.torrent_file = _torrent_file;
    }

    public File getFile() {
        return this.file.getFile();
    }

    public void moveFile(File new_file) throws CacheFileManagerException {
        try {
            this.file.moveFile(new_file);
        }
        catch (FMFileManagerException e) {
            this.manager.rethrow(e);
        }
    }

    public void setAccessMode(int mode) throws CacheFileManagerException {
        try {
            this.file.setAccessMode(mode == 1 ? 1 : 2);
        }
        catch (FMFileManagerException e) {
            this.manager.rethrow(e);
        }
    }

    public int getAccessMode() {
        return this.file.getAccessMode() == 1 ? 1 : 2;
    }

    public void ensureOpen() throws CacheFileManagerException {
        try {
            this.file.ensureOpen();
        }
        catch (FMFileManagerException e) {
            this.manager.rethrow(e);
        }
    }

    public long getLength() throws CacheFileManagerException {
        try {
            return this.file.getSize();
        }
        catch (FMFileManagerException e) {
            this.manager.rethrow(e);
            return 0L;
        }
    }

    public void setLength(long length) throws CacheFileManagerException {
        try {
            this.file.setLength(length);
        }
        catch (FMFileManagerException e) {
            this.manager.rethrow(e);
        }
    }

    public void read(DirectByteBuffer buffer, long position) throws CacheFileManagerException {
        int file_buffer_position = buffer.position((byte)3);
        int file_buffer_limit = buffer.limit((byte)3);
        int read_length = file_buffer_limit - file_buffer_position;
        try {
            this.file.read(buffer, position);
            this.manager.fileBytesRead(read_length);
        }
        catch (FMFileManagerException e) {
            this.manager.rethrow(e);
        }
    }

    public void write(DirectByteBuffer buffer, long position) throws CacheFileManagerException {
        int file_buffer_position = buffer.position((byte)3);
        int file_buffer_limit = buffer.limit((byte)3);
        int write_length = file_buffer_limit - file_buffer_position;
        try {
            this.file.write(buffer, position);
            this.manager.fileBytesWritten(write_length);
        }
        catch (FMFileManagerException e) {
            this.manager.rethrow(e);
        }
    }

    public void writeAndHandoverBuffer(DirectByteBuffer buffer, long position) throws CacheFileManagerException {
        int file_buffer_position = buffer.position((byte)3);
        int file_buffer_limit = buffer.limit((byte)3);
        int write_length = file_buffer_limit - file_buffer_position;
        boolean write_ok = false;
        try {
            try {
                this.file.write(buffer, position);
                this.manager.fileBytesWritten(write_length);
                write_ok = true;
            }
            catch (FMFileManagerException e) {
                this.manager.rethrow(e);
            }
        }
        finally {
            if (write_ok) {
                buffer.returnToPool();
            }
        }
    }

    public void flushCache() throws CacheFileManagerException {
    }

    public void clearCache() throws CacheFileManagerException {
    }

    public void close() throws CacheFileManagerException {
        try {
            this.file.close();
        }
        catch (FMFileManagerException e) {
            this.manager.rethrow(e);
        }
    }

    public void setFileOffset(int _file_offset) {
    }
}

