/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.weaver.patterns;

import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.reflect.Member;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.aspectj.bridge.IMessage;
import org.aspectj.lang.JoinPoint;
import org.aspectj.util.FuzzyBoolean;
import org.aspectj.weaver.ISourceContext;
import org.aspectj.weaver.IntMap;
import org.aspectj.weaver.ResolvedTypeX;
import org.aspectj.weaver.Shadow;
import org.aspectj.weaver.TypeX;
import org.aspectj.weaver.VersionedDataInputStream;
import org.aspectj.weaver.WeaverMessages;
import org.aspectj.weaver.ast.Literal;
import org.aspectj.weaver.ast.Test;
import org.aspectj.weaver.ast.Var;
import org.aspectj.weaver.patterns.BindingTypePattern;
import org.aspectj.weaver.patterns.Bindings;
import org.aspectj.weaver.patterns.ExactTypePattern;
import org.aspectj.weaver.patterns.ExposedState;
import org.aspectj.weaver.patterns.FastMatchInfo;
import org.aspectj.weaver.patterns.IScope;
import org.aspectj.weaver.patterns.NameBindingPointcut;
import org.aspectj.weaver.patterns.Pointcut;
import org.aspectj.weaver.patterns.TypePattern;

public class ThisOrTargetPointcut
extends NameBindingPointcut {
    private boolean isThis;
    private TypePattern type;
    private static final Set thisKindSet = new HashSet(Shadow.ALL_SHADOW_KINDS);
    private static final Set targetKindSet = new HashSet(Shadow.ALL_SHADOW_KINDS);

    public ThisOrTargetPointcut(boolean isThis, TypePattern type) {
        this.isThis = isThis;
        this.type = type;
        this.pointcutKind = (byte)3;
    }

    public boolean isThis() {
        return this.isThis;
    }

    public Set couldMatchKinds() {
        return this.isThis ? thisKindSet : targetKindSet;
    }

    public FuzzyBoolean fastMatch(FastMatchInfo type) {
        return FuzzyBoolean.MAYBE;
    }

    private boolean couldMatch(Shadow shadow) {
        return this.isThis ? shadow.hasThis() : shadow.hasTarget();
    }

    protected FuzzyBoolean matchInternal(Shadow shadow) {
        if (!this.couldMatch(shadow)) {
            return FuzzyBoolean.NO;
        }
        TypeX typeToMatch = this.isThis ? shadow.getThisType() : shadow.getTargetType();
        return this.type.matches(typeToMatch.resolve(shadow.getIWorld()), TypePattern.DYNAMIC);
    }

    public FuzzyBoolean match(JoinPoint jp, JoinPoint.StaticPart encJP) {
        Object toMatch;
        Object object = toMatch = this.isThis ? jp.getThis() : jp.getTarget();
        if (toMatch == null) {
            return FuzzyBoolean.NO;
        }
        return this.type.matches(toMatch.getClass(), TypePattern.DYNAMIC);
    }

    public boolean matchesDynamically(Object thisObject, Object targetObject, Object[] args) {
        Object toMatch;
        Object object = toMatch = this.isThis ? thisObject : targetObject;
        if (toMatch == null) {
            return false;
        }
        return this.type.matchesSubtypes(toMatch.getClass());
    }

    public FuzzyBoolean matchesStatically(String joinpointKind, Member member, Class thisClass, Class targetClass, Member withinCode) {
        Class staticType;
        Class clazz = staticType = this.isThis ? thisClass : targetClass;
        if (joinpointKind.equals(Shadow.StaticInitialization.getName())) {
            return FuzzyBoolean.NO;
        }
        return ((ExactTypePattern)this.type).willMatchDynamically(staticType);
    }

    public void write(DataOutputStream s) throws IOException {
        s.writeByte(3);
        s.writeBoolean(this.isThis);
        this.type.write(s);
        this.writeLocation(s);
    }

    public static Pointcut read(VersionedDataInputStream s, ISourceContext context) throws IOException {
        boolean isThis = s.readBoolean();
        TypePattern type = TypePattern.read(s, context);
        ThisOrTargetPointcut ret = new ThisOrTargetPointcut(isThis, type);
        ret.readLocation(context, s);
        return ret;
    }

    public void resolveBindings(IScope scope, Bindings bindings) {
        this.type = this.type.resolveBindings(scope, bindings, true, true);
    }

    public void resolveBindingsFromRTTI() {
        this.type = this.type.resolveBindingsFromRTTI(true, true);
    }

    public void postRead(ResolvedTypeX enclosingType) {
        this.type.postRead(enclosingType);
    }

    public List getBindingAnnotationTypePatterns() {
        return Collections.EMPTY_LIST;
    }

    public List getBindingTypePatterns() {
        if (this.type instanceof BindingTypePattern) {
            ArrayList<TypePattern> l = new ArrayList<TypePattern>();
            l.add(this.type);
            return l;
        }
        return Collections.EMPTY_LIST;
    }

    public boolean equals(Object other) {
        if (!(other instanceof ThisOrTargetPointcut)) {
            return false;
        }
        ThisOrTargetPointcut o = (ThisOrTargetPointcut)other;
        return o.isThis == this.isThis && o.type.equals(this.type);
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + (this.isThis ? 0 : 1);
        result = 37 * result + this.type.hashCode();
        return result;
    }

    public String toString() {
        return (this.isThis ? "this(" : "target(") + this.type + ")";
    }

    protected Test findResidueInternal(Shadow shadow, ExposedState state) {
        BindingTypePattern btp;
        Var var;
        if (!this.couldMatch(shadow)) {
            return Literal.FALSE;
        }
        if (this.type == TypePattern.ANY) {
            return Literal.TRUE;
        }
        Var var2 = var = this.isThis ? shadow.getThisVar() : shadow.getTargetVar();
        if (this.type instanceof BindingTypePattern && state.get((btp = (BindingTypePattern)this.type).getFormalIndex()) != null && this.lastMatchedShadowId != shadow.shadowId) {
            state.setErroneousVar(btp.getFormalIndex());
        }
        return this.exposeStateForVar(var, this.type, state, shadow.getIWorld());
    }

    public Pointcut concretize1(ResolvedTypeX inAspect, IntMap bindings) {
        if (this.isDeclare(bindings.getEnclosingAdvice())) {
            inAspect.getWorld().showMessage(IMessage.ERROR, WeaverMessages.format("thisOrTargetInDeclare", this.isThis ? "this" : "target"), bindings.getEnclosingAdvice().getSourceLocation(), null);
            return Pointcut.makeMatchesNothing(Pointcut.CONCRETE);
        }
        TypePattern newType = this.type.remapAdviceFormals(bindings);
        if (inAspect.crosscuttingMembers != null) {
            inAspect.crosscuttingMembers.exposeType(newType.getExactType());
        }
        ThisOrTargetPointcut ret = new ThisOrTargetPointcut(this.isThis, newType);
        ret.copyLocationFrom(this);
        return ret;
    }

    static {
        Iterator iter = Shadow.ALL_SHADOW_KINDS.iterator();
        while (iter.hasNext()) {
            Shadow.Kind kind = (Shadow.Kind)iter.next();
            if (kind.neverHasThis()) {
                thisKindSet.remove(kind);
            }
            if (!kind.neverHasTarget()) continue;
            targetKindSet.remove(kind);
        }
    }
}

