/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.org.eclipse.jdt.internal.core.dom.rewrite;

import java.util.ArrayList;
import org.aspectj.org.eclipse.jdt.internal.core.dom.rewrite.Indents;
import org.eclipse.text.edits.ISourceModifier;
import org.eclipse.text.edits.ReplaceEdit;

public class SourceModifier
implements ISourceModifier {
    private final String destinationIndent;
    private final int sourceIndentLevel;
    private final int tabWidth;

    public SourceModifier(int sourceIndentLevel, String destinationIndent, int tabWidth) {
        this.destinationIndent = destinationIndent;
        this.sourceIndentLevel = sourceIndentLevel;
        this.tabWidth = tabWidth;
    }

    public ISourceModifier copy() {
        return this;
    }

    public ReplaceEdit[] getModifications(String source) {
        ArrayList result = new ArrayList();
        int destIndentLevel = Indents.computeIndent(this.destinationIndent, this.tabWidth);
        if (destIndentLevel == this.sourceIndentLevel) {
            return result.toArray(new ReplaceEdit[result.size()]);
        }
        return Indents.getChangeIndentEdits(source, this.sourceIndentLevel, this.tabWidth, this.destinationIndent);
    }
}

