/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.org.eclipse.jdt.core.dom;

import org.aspectj.org.eclipse.jdt.core.compiler.CharOperation;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.ImportBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.PackageBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.ParameterizedTypeBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.TypeVariableBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.VariableBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.WildcardBinding;

class BindingComparator {
    BindingComparator() {
    }

    static boolean isEqual(TypeVariableBinding[] bindings, TypeVariableBinding[] otherBindings) {
        if (bindings == null) {
            return otherBindings == null;
        }
        if (otherBindings == null) {
            return false;
        }
        int length = bindings.length;
        int otherLength = otherBindings.length;
        if (length != otherLength) {
            return false;
        }
        int i = 0;
        while (i < length) {
            TypeVariableBinding typeVariableBinding = bindings[i];
            TypeVariableBinding typeVariableBinding2 = otherBindings[i];
            if (!(CharOperation.equals(typeVariableBinding.sourceName, typeVariableBinding2.sourceName) && BindingComparator.isEqual(typeVariableBinding.declaringElement, typeVariableBinding2.declaringElement, false) && BindingComparator.isEqual(typeVariableBinding.superclass, typeVariableBinding2.superclass, false) && BindingComparator.isEqual(typeVariableBinding.superInterfaces, typeVariableBinding2.superInterfaces, false))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    static boolean isEqual(Binding declaringElement, Binding declaringElement2, boolean checkTypeVariables) {
        if (declaringElement instanceof TypeBinding) {
            if (!(declaringElement2 instanceof TypeBinding)) {
                return false;
            }
            return BindingComparator.isEqual((TypeBinding)declaringElement, (TypeBinding)declaringElement2, checkTypeVariables);
        }
        if (declaringElement instanceof MethodBinding) {
            if (!(declaringElement2 instanceof MethodBinding)) {
                return false;
            }
            return BindingComparator.isEqual((MethodBinding)declaringElement, (MethodBinding)declaringElement2, checkTypeVariables);
        }
        if (declaringElement instanceof VariableBinding) {
            if (!(declaringElement2 instanceof VariableBinding)) {
                return false;
            }
            return BindingComparator.isEqual((VariableBinding)declaringElement, (VariableBinding)declaringElement2);
        }
        if (declaringElement instanceof PackageBinding) {
            if (!(declaringElement2 instanceof PackageBinding)) {
                return false;
            }
            PackageBinding packageBinding = (PackageBinding)declaringElement;
            PackageBinding packageBinding2 = (PackageBinding)declaringElement2;
            return CharOperation.equals(packageBinding.compoundName, packageBinding2.compoundName);
        }
        if (declaringElement instanceof ImportBinding) {
            if (!(declaringElement2 instanceof ImportBinding)) {
                return false;
            }
            ImportBinding importBinding = (ImportBinding)declaringElement;
            ImportBinding importBinding2 = (ImportBinding)declaringElement2;
            return importBinding.isStatic() == importBinding2.isStatic() && importBinding.onDemand == importBinding2.onDemand && CharOperation.equals(importBinding.compoundName, importBinding2.compoundName);
        }
        return false;
    }

    static boolean isEqual(MethodBinding methodBinding, MethodBinding methodBinding2) {
        return BindingComparator.isEqual(methodBinding, methodBinding2, true);
    }

    static boolean isEqual(MethodBinding methodBinding, MethodBinding methodBinding2, boolean checkTypeVariables) {
        if (checkTypeVariables) {
            return methodBinding == null && methodBinding2 == null || CharOperation.equals(methodBinding.selector, methodBinding2.selector) && BindingComparator.isEqual(methodBinding.returnType, methodBinding2.returnType, false) && BindingComparator.isEqual(methodBinding.parameters, methodBinding2.parameters, false) && BindingComparator.isEqual(methodBinding.thrownExceptions, methodBinding2.thrownExceptions, false) && BindingComparator.isEqual(methodBinding.typeVariables, methodBinding2.typeVariables, false) && BindingComparator.isEqual(methodBinding.declaringClass, methodBinding2.declaringClass, false);
        }
        return methodBinding == null && methodBinding2 == null || CharOperation.equals(methodBinding.selector, methodBinding2.selector) && BindingComparator.isEqual(methodBinding.returnType, methodBinding2.returnType, false) && BindingComparator.isEqual(methodBinding.parameters, methodBinding2.parameters, false) && BindingComparator.isEqual(methodBinding.thrownExceptions, methodBinding2.thrownExceptions, false);
    }

    static boolean isEqual(VariableBinding variableBinding, VariableBinding variableBinding2) {
        return variableBinding.modifiers == variableBinding2.modifiers && CharOperation.equals(variableBinding.name, variableBinding2.name) && BindingComparator.isEqual(variableBinding.type, variableBinding2.type);
    }

    static boolean isEqual(FieldBinding fieldBinding, FieldBinding fieldBinding2) {
        return fieldBinding.modifiers == fieldBinding2.modifiers && CharOperation.equals(fieldBinding.name, fieldBinding2.name) && BindingComparator.isEqual(fieldBinding.type, fieldBinding2.type, false) && BindingComparator.isEqual(fieldBinding.declaringClass, fieldBinding2.declaringClass, false);
    }

    static boolean isEqual(TypeBinding[] bindings, TypeBinding[] otherBindings) {
        return BindingComparator.isEqual(bindings, otherBindings, true);
    }

    static boolean isEqual(TypeBinding[] bindings, TypeBinding[] otherBindings, boolean checkTypeVariables) {
        if (bindings == null) {
            return otherBindings == null;
        }
        if (otherBindings == null) {
            return false;
        }
        int length = bindings.length;
        int otherLength = otherBindings.length;
        if (length != otherLength) {
            return false;
        }
        int i = 0;
        while (i < length) {
            if (!BindingComparator.isEqual(bindings[i], otherBindings[i], checkTypeVariables)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    static boolean isEqual(TypeBinding typeBinding, TypeBinding typeBinding2, boolean checkTypeVariables) {
        if (typeBinding == null) {
            return typeBinding2 == null;
        }
        if (typeBinding2 == null) {
            return false;
        }
        if (typeBinding.isBaseType()) {
            if (!typeBinding2.isBaseType()) {
                return false;
            }
            return typeBinding.id == typeBinding2.id;
        }
        if (typeBinding.isArrayType()) {
            if (!typeBinding2.isArrayType()) {
                return false;
            }
            return typeBinding.dimensions() == typeBinding2.dimensions() && BindingComparator.isEqual(typeBinding.leafComponentType(), typeBinding2.leafComponentType(), checkTypeVariables);
        }
        ReferenceBinding referenceBinding = (ReferenceBinding)typeBinding;
        if (!(typeBinding2 instanceof ReferenceBinding)) {
            return false;
        }
        ReferenceBinding referenceBinding2 = (ReferenceBinding)typeBinding2;
        if (referenceBinding.isParameterizedType()) {
            if (!referenceBinding2.isParameterizedType()) {
                return false;
            }
            ParameterizedTypeBinding parameterizedTypeBinding = (ParameterizedTypeBinding)referenceBinding;
            ParameterizedTypeBinding parameterizedTypeBinding2 = (ParameterizedTypeBinding)referenceBinding2;
            if (checkTypeVariables && !BindingComparator.isEqual(parameterizedTypeBinding.arguments, parameterizedTypeBinding2.arguments, false)) {
                return false;
            }
            return CharOperation.equals(referenceBinding.compoundName, referenceBinding2.compoundName) && referenceBinding.isInterface() == referenceBinding2.isInterface() && referenceBinding.isEnum() == referenceBinding2.isEnum() && referenceBinding.isAnnotationType() == referenceBinding2.isAnnotationType() && referenceBinding.modifiers == referenceBinding2.modifiers;
        }
        if (referenceBinding.isWildcard()) {
            if (!referenceBinding2.isWildcard()) {
                return false;
            }
            WildcardBinding wildcardBinding = (WildcardBinding)referenceBinding;
            WildcardBinding wildcardBinding2 = (WildcardBinding)referenceBinding2;
            return BindingComparator.isEqual(wildcardBinding.bound, wildcardBinding2.bound) && wildcardBinding.kind == wildcardBinding2.kind;
        }
        if (referenceBinding.isGenericType()) {
            if (!referenceBinding2.isGenericType()) {
                return false;
            }
            if (checkTypeVariables && !BindingComparator.isEqual(referenceBinding.typeVariables(), referenceBinding2.typeVariables(), false)) {
                return false;
            }
            return CharOperation.equals(referenceBinding.compoundName, referenceBinding2.compoundName) && referenceBinding.isGenericType() == referenceBinding2.isGenericType() && referenceBinding.isRawType() == referenceBinding2.isRawType() && referenceBinding.isInterface() == referenceBinding2.isInterface() && referenceBinding.isEnum() == referenceBinding2.isEnum() && referenceBinding.isAnnotationType() == referenceBinding2.isAnnotationType() && referenceBinding.modifiers == referenceBinding2.modifiers;
        }
        if (referenceBinding instanceof TypeVariableBinding) {
            if (!(referenceBinding2 instanceof TypeVariableBinding)) {
                return false;
            }
            TypeVariableBinding typeVariableBinding = (TypeVariableBinding)referenceBinding;
            TypeVariableBinding typeVariableBinding2 = (TypeVariableBinding)referenceBinding2;
            if (checkTypeVariables) {
                return CharOperation.equals(typeVariableBinding.sourceName, typeVariableBinding2.sourceName) && BindingComparator.isEqual(typeVariableBinding.declaringElement, typeVariableBinding2.declaringElement, false) && BindingComparator.isEqual(typeVariableBinding.superclass, typeVariableBinding2.superclass, false) && BindingComparator.isEqual(typeVariableBinding.superInterfaces, typeVariableBinding2.superInterfaces, false);
            }
            return CharOperation.equals(typeVariableBinding.sourceName, typeVariableBinding2.sourceName);
        }
        return CharOperation.equals(referenceBinding.compoundName, referenceBinding2.compoundName) && referenceBinding.isRawType() == referenceBinding2.isRawType() && referenceBinding.isInterface() == referenceBinding2.isInterface() && referenceBinding.isEnum() == referenceBinding2.isEnum() && referenceBinding.isAnnotationType() == referenceBinding2.isAnnotationType() && referenceBinding.modifiers == referenceBinding2.modifiers;
    }

    static boolean isEqual(TypeBinding typeBinding, TypeBinding typeBinding2) {
        return BindingComparator.isEqual(typeBinding, typeBinding2, true);
    }
}

