/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.org.eclipse.jdt.internal.core;

import org.aspectj.org.eclipse.jdt.core.Flags;
import org.aspectj.org.eclipse.jdt.core.IField;
import org.aspectj.org.eclipse.jdt.core.IJavaElement;
import org.aspectj.org.eclipse.jdt.core.IType;
import org.aspectj.org.eclipse.jdt.core.JavaModelException;
import org.aspectj.org.eclipse.jdt.core.Signature;
import org.aspectj.org.eclipse.jdt.core.dom.ASTNode;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.aspectj.org.eclipse.jdt.internal.core.CompilationUnit;
import org.aspectj.org.eclipse.jdt.internal.core.JavaElement;
import org.aspectj.org.eclipse.jdt.internal.core.NamedMember;
import org.aspectj.org.eclipse.jdt.internal.core.ResolvedSourceField;
import org.aspectj.org.eclipse.jdt.internal.core.SourceFieldElementInfo;

public class SourceField
extends NamedMember
implements IField {
    protected SourceField(JavaElement parent, String name) {
        super(parent, name);
    }

    public boolean equals(Object o) {
        if (!(o instanceof SourceField)) {
            return false;
        }
        return super.equals(o);
    }

    public ASTNode findNode(org.aspectj.org.eclipse.jdt.core.dom.CompilationUnit ast) {
        ASTNode node = super.findNode(ast);
        if (node == null) {
            return null;
        }
        return node.getParent();
    }

    public Object getConstant() throws JavaModelException {
        Object constant = null;
        SourceFieldElementInfo info = (SourceFieldElementInfo)this.getElementInfo();
        char[] constantSourceChars = info.initializationSource;
        if (constantSourceChars == null) {
            return null;
        }
        String constantSource = new String(constantSourceChars);
        String signature = info.getTypeSignature();
        if (signature.equals("I")) {
            constant = new Integer(constantSource);
        } else if (signature.equals("S")) {
            constant = new Short(constantSource);
        } else if (signature.equals("B")) {
            constant = new Byte(constantSource);
        } else if (signature.equals("Z")) {
            constant = Boolean.valueOf(constantSource);
        } else if (signature.equals("C")) {
            if (constantSourceChars.length != 3) {
                return null;
            }
            constant = new Character(constantSourceChars[1]);
        } else if (signature.equals("D")) {
            constant = new Double(constantSource);
        } else if (signature.equals("F")) {
            constant = new Float(constantSource);
        } else if (signature.equals("J")) {
            int index;
            constant = constantSource.endsWith("L") || constantSource.endsWith("l") ? ((index = constantSource.lastIndexOf("L")) != -1 ? new Long(constantSource.substring(0, index)) : new Long(constantSource.substring(0, constantSource.lastIndexOf("l")))) : new Long(constantSource);
        } else if (signature.equals("QString;")) {
            constant = constantSource;
        }
        return constant;
    }

    public int getElementType() {
        return 8;
    }

    public String getKey() {
        try {
            return this.getKey(this, false);
        }
        catch (JavaModelException e) {
            return null;
        }
    }

    protected char getHandleMementoDelimiter() {
        return '^';
    }

    public IJavaElement getPrimaryElement(boolean checkOwner) {
        CompilationUnit cu;
        if (checkOwner && (cu = (CompilationUnit)this.getAncestor(5)).isPrimary()) {
            return this;
        }
        IJavaElement primaryParent = this.parent.getPrimaryElement(false);
        return ((IType)primaryParent).getField(this.name);
    }

    public String getTypeSignature() throws JavaModelException {
        SourceFieldElementInfo info = (SourceFieldElementInfo)this.getElementInfo();
        return info.getTypeSignature();
    }

    public boolean isEnumConstant() throws JavaModelException {
        return Flags.isEnum(this.getFlags());
    }

    public boolean isResolved() {
        return false;
    }

    public JavaElement resolved(Binding binding) {
        ResolvedSourceField resolvedHandle = new ResolvedSourceField(this.parent, this.name, new String(binding.computeUniqueKey()));
        resolvedHandle.occurrenceCount = this.occurrenceCount;
        return resolvedHandle;
    }

    protected void toStringInfo(int tab, StringBuffer buffer, Object info, boolean showResolvedInfo) {
        buffer.append(this.tabString(tab));
        if (info == null) {
            this.toStringName(buffer);
            buffer.append(" (not open)");
        } else if (info == JavaElement.NO_INFO) {
            this.toStringName(buffer);
        } else {
            try {
                buffer.append(Signature.toString(this.getTypeSignature()));
                buffer.append(" ");
                this.toStringName(buffer);
            }
            catch (JavaModelException e) {
                buffer.append("<JavaModelException in toString of " + this.getElementName());
            }
        }
    }
}

