/*
 * Decompiled with CFR 0.152.
 */
package symantec.tools.debug;

import symantec.tools.debug.RemoteAgent;
import symantec.tools.debug.RemoteClass;
import symantec.tools.debug.RemoteObject;
import symantec.tools.debug.RemoteStackFrame;
import symantec.tools.debug.RemoteStackVariable;

public class RemoteThread
extends RemoteObject {
    private int currentFrame;
    private RemoteStackFrame[] stack;
    private boolean suspended = false;

    RemoteThread(RemoteAgent remoteAgent, int n, RemoteClass remoteClass) {
        super(remoteAgent, 19, n, remoteClass);
    }

    public String getName() throws Exception {
        return this.agent.getThreadName(this.id);
    }

    public int getCurrentFrameIndex() {
        return this.currentFrame;
    }

    public void setCurrentFrameIndex(int n) {
        this.currentFrame = n;
    }

    public void resetCurrentFrameIndex() {
        this.currentFrame = 0;
    }

    public void up(int n) throws Exception {
        int n2 = this.agent.getThreadStatus(this.id);
        if (n2 != 5 && n2 != 6) {
            throw new IllegalAccessError();
        }
        if (this.stack == null) {
            this.stack = this.agent.dumpStack(this);
        }
        if (this.currentFrame + n >= this.stack.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this.currentFrame += n;
    }

    public void down(int n) throws Exception {
        int n2 = this.agent.getThreadStatus(this.id);
        if (n2 != 5 && n2 != 6) {
            throw new IllegalAccessError();
        }
        if (this.stack == null) {
            this.stack = this.agent.dumpStack(this);
        }
        if (this.currentFrame - n < 0) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this.currentFrame -= n;
    }

    public String getStatus() throws Exception {
        int n = this.agent.getThreadStatus(this.id);
        switch (n) {
            case -1: {
                return "";
            }
            case 0: {
                return "zombie";
            }
            case 1: {
                return "running";
            }
            case 2: {
                return "sleeping";
            }
            case 3: {
                return "waiting in a monitor";
            }
            case 4: {
                return "cond. waiting";
            }
            case 5: {
                return "suspended";
            }
            case 6: {
                return "at breakpoint";
            }
        }
        return "invalid status returned";
    }

    public RemoteStackFrame[] dumpStack() throws Exception {
        this.stack = this.agent.dumpStack(this);
        return this.stack;
    }

    public RemoteStackFrame getCurrentFrame() throws Exception {
        int n = this.agent.getThreadStatus(this.id);
        if (n != 5 && n != 6) {
            throw new IllegalAccessError();
        }
        if (this.stack == null) {
            this.stack = this.agent.dumpStack(this);
        }
        return this.stack[this.currentFrame];
    }

    public void suspend() throws Exception {
        if (!this.suspended) {
            this.agent.suspendThread(this.id);
            this.suspended = true;
        }
    }

    public void resume() throws Exception {
        if (this.suspended) {
            this.agent.resumeThread(this.id);
            this.suspended = false;
        }
    }

    public void step(boolean bl) throws Exception {
        int n = this.agent.getThreadStatus(this.id);
        if (n != 5 && n != 6) {
            throw new IllegalAccessError();
        }
        this.agent.stepThread(this.id, bl);
    }

    public void next() throws Exception {
        int n = this.agent.getThreadStatus(this.id);
        if (n != 5 && n != 6) {
            throw new IllegalAccessError();
        }
        this.agent.stepNextThread(this.id);
    }

    public void stepout() throws Exception {
        int n = this.agent.getThreadStatus(this.id);
        if (n != 5 && n != 6) {
            throw new IllegalAccessError();
        }
        this.agent.stepOutThread(this.id);
    }

    public void gopop() throws Exception {
        int n = this.agent.getThreadStatus(this.id);
        if (n != 5 && n != 6) {
            throw new IllegalAccessError();
        }
        this.agent.goPopThread(this.id);
    }

    public boolean isSuspended() {
        return this.suspended;
    }

    public void cont() throws Exception {
        if (!this.suspended) {
            this.agent.resumeThread(this.id);
        }
    }

    public void stop() throws Exception {
        this.agent.stopThread(this.id);
    }

    public RemoteStackVariable getStackVariable(String string) throws Exception {
        this.agent.message("getStackVariable: thread=" + this.getName() + ", currentFrame=" + this.currentFrame);
        int n = this.agent.getThreadStatus(this.id);
        if (n != 5 && n != 6) {
            this.agent.message("getStackVariable: bogus thread status=" + n);
            return null;
        }
        if (this.stack == null) {
            this.stack = this.agent.dumpStack(this);
        }
        return this.stack[this.currentFrame].getLocalVariable(string);
    }

    public RemoteStackVariable[] getStackVariables() throws Exception {
        this.agent.message("getStackVariables: thread=" + this.getName() + ", currentFrame=" + this.currentFrame);
        int n = this.agent.getThreadStatus(this.id);
        if (n != 5 && n != 6) {
            this.agent.message("getStackVariables: bogus thread status=" + n);
            return null;
        }
        if (this.stack == null) {
            this.stack = this.agent.dumpStack(this);
        }
        return this.stack[this.currentFrame].getLocalVariables();
    }
}

