/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.macos;

import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.StringBufferInputStream;
import sun.awt.macos.MacClipboardContents;

public class MacClipboard
extends Clipboard {
    static final String TEXT_RESTYPE = "TEXT";
    static final String OBJECT_RESTYPE = "JSOB";

    public MacClipboard(String string) {
        super(string);
    }

    public synchronized Transferable getContents(Object object) {
        MacClipboardContents macClipboardContents = new MacClipboardContents();
        String[] stringArray = MacClipboard.getScrapTypes();
        int n = 0;
        while (n < stringArray.length) {
            Object object2;
            String string = stringArray[n];
            if (string.equals(TEXT_RESTYPE)) {
                object2 = MacClipboard.getStringFromScrap(TEXT_RESTYPE);
                macClipboardContents.addTransferData(DataFlavor.stringFlavor, object2);
                macClipboardContents.addTransferData(DataFlavor.plainTextFlavor, new StringBufferInputStream((String)object2));
            } else if (string.equals(OBJECT_RESTYPE)) {
                try {
                    byte[] byArray = MacClipboard.getBytesFromScrap(OBJECT_RESTYPE);
                    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                    ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
                    object2 = objectInputStream.readObject();
                    DataFlavor dataFlavor = new DataFlavor(object2.getClass(), object2.getClass().getName());
                    macClipboardContents.addTransferData(dataFlavor, object2);
                }
                catch (IOException iOException) {
                    System.err.println("IOException in MacClipboard: " + iOException);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    System.err.println("ClassNotFoundException in MacClipboard: " + classNotFoundException);
                }
            }
            ++n;
        }
        return macClipboardContents;
    }

    public synchronized void setContents(Transferable transferable, ClipboardOwner clipboardOwner) {
        if (this.owner != null && this.owner != clipboardOwner) {
            this.owner.lostOwnership(this, this.contents);
        }
        this.owner = clipboardOwner;
        this.contents = transferable;
        DataFlavor[] dataFlavorArray = transferable.getTransferDataFlavors();
        boolean bl = true;
        int n = 0;
        while (n < dataFlavorArray.length) {
            DataFlavor dataFlavor = dataFlavorArray[n];
            try {
                Object object;
                Object object2;
                if (dataFlavor.getMimeType().toLowerCase().startsWith("text/")) {
                    object2 = (InputStream)transferable.getTransferData(dataFlavor);
                    object = new byte[((InputStream)object2).available()];
                    ((InputStream)object2).read((byte[])object);
                    MacClipboard.putBytesOnScrap(TEXT_RESTYPE, (byte[])object, bl);
                    bl = false;
                } else if (dataFlavor.getRepresentationClass().getName().equals("java.lang.String")) {
                    MacClipboard.putStringOnScrap(TEXT_RESTYPE, (String)transferable.getTransferData(dataFlavor), bl);
                    bl = false;
                } else if (dataFlavor.getMimeType().toLowerCase().startsWith("application/x-javaserializedobject")) {
                    object2 = new ByteArrayOutputStream();
                    object = new ObjectOutputStream((OutputStream)object2);
                    ((ObjectOutputStream)object).writeObject(transferable.getTransferData(dataFlavor));
                    MacClipboard.putBytesOnScrap(OBJECT_RESTYPE, ((ByteArrayOutputStream)object2).toByteArray(), bl);
                    bl = false;
                }
            }
            catch (IOException iOException) {
                System.err.println("IOException in MacClipboard: " + iOException);
            }
            catch (UnsupportedFlavorException unsupportedFlavorException) {
                System.err.println("UnsupportedFlavorException in MacClipboard: " + unsupportedFlavorException);
            }
            ++n;
        }
    }

    static native String[] getScrapTypes();

    static native void putStringOnScrap(String var0, String var1, boolean var2);

    static native void putBytesOnScrap(String var0, byte[] var1, boolean var2);

    static native String getStringFromScrap(String var0);

    static native byte[] getBytesFromScrap(String var0);
}

