#ifndef lint
static char rcsId[]="$Header: /home/linas/cvsroot/xacc/lib/XmHTML-1.1.0/src/output.c,v 1.1 1997/11/30 05:13:11 linas Exp $";
#endif
/*****
* output.c : XmHTML Text output routines.
*
* This file Version	$Revision: 1.1 $
*
* Creation date:		Sun Sep  7 18:53:00 GMT+0100 1997
* Last modification: 	$Date: 1997/11/30 05:13:11 $
* By:					$Author: linas $
* Current State:		$State: Exp $
*
* Author:				newt
*
* Copyright (C) 1994-1997 by Ripley Software Development 
* All Rights Reserved
*
* This file is part of the XmHTML Widget Library.
*
* This library is free software; you can redistribute it and/or
* modify it under the terms of the GNU Library General Public
* License as published by the Free Software Foundation; either
* version 2 of the License, or (at your option) any later version.
*
* This library is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* Library General Public License for more details.
*
* You should have received a copy of the GNU Library General Public
* License along with this library; if not, write to the Free
* Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*
*****/
/*****
* ChangeLog 
* $Log: output.c,v $
* Revision 1.1  1997/11/30 05:13:11  linas
* import XmHTML source for the help widget
*
*****/ 
#include <stdlib.h>
#include <stdio.h>
#include <string.h>

/* Local includes */
#include "XmHTMLP.h"
#include "XmHTMLfuncs.h"


/*** External Function Prototype Declarations ***/

/*** Public Variable Declarations ***/

/*** Private Datatype Declarations ****/

/*** Private Function Prototype Declarations ****/

/*** Private Variable Declarations ***/

/*****
* Name:			_XmHTMLTextCheckAndConvertPaperDef
* Return Type:	XmHTMLPaperSize
* Description:	verifies the given paper definition and converts it's type
*				to XmHTML_POINT.
* In:
*	html:		XmHTMLWidget id;
*	pin:		papersize to be checked & converted;
* Returns:
*	a ptr to the checked & converted paperdefinition.
*****/
XmHTMLPaperSize*
_XmHTMLTextCheckAndConvertPaperDef(XmHTMLWidget html, XmHTMLPaperSize *pdef,
	Byte type)
{
	static XmHTMLPaperSize pout;
	float multiplier = 1.;

	/* verify margins */
	if(pdef->left_margin + pdef->right_margin >= pdef->width)
	{
		_XmHTMLWarning(__WFUNC__(w, "_XmHTMLTextCheckAndConvertPaperDef"),
			"Formatted text output: sum of horizontal margins exceeds "
			"paper width.");
		return(NULL);
	}

	if(pdef->top_margin + pdef->bottom_margin >= pdef->height)
	{
		_XmHTMLWarning(__WFUNC__(w, "_XmHTMLTextCheckAndConvertPaperDef"),
			"Formatted text output: sum of vertical margins exceeds "
			"paper height.");
		return(NULL);
	}

	/* copy in to out */
	memcpy((void*)&pout, (const void*)pdef, sizeof(XmHTMLPaperSize));

	/* postscript does everything in points */
	if(type == XmHTMLTEXT_POSTSCRIPT)
	{
		switch(pdef->type)
		{
			case XmHTML_CENTIMETER:		/* 1cm = 28.45pt */
				multiplier = 28.45;
				break;
			case XmHTML_MILLIMETER:		/* 1mm = 2.845 pt */
				multiplier = 2.845;
				break;
			case XmHTML_INCH:			/* 1in = 72.27 pt */
				multiplier = 72.27;
				break;
			case XmHTML_PICA:			/* 1pc = 12pt */
				multiplier = 12.;
				break;
			case XmHTML_CHAR:			/* 1char = 10.5625pt */
				multiplier = 10.5625;
				break;
			case XmHTML_POINT:			/* no conversion required */
				return(*pout);
			default:					/* bad spec */
				_XmHTMLWarning(__WFUNC__(html,
					"_XmHTMLTextCheckAndConvertPaperDef"),
					"Formatted text output: invalid papersize type selected.");
				return(NULL);
		}
	}
	else	/* plain text does everything in chars */
	{
		switch(pdef->type)
		{
			case XmHTML_CENTIMETER:		/* 1cm = 2.6934911 char */
				multiplier = 2.6934911;
				break;
			case XmHTML_MILLIMETER:		/* 1mm = 0.26934911 char */
				multiplier = 0.26934911;
				break;
			case XmHTML_INCH:			/* 1in = 6.8421302 char */
				multiplier = 6.8421302;
				break;
			case XmHTML_PICA:			/* 1pc = 1.1360947 char */
				multiplier = 1.1360947;
				break;
			case XmHTML_POINT:			/* 1pt = 0.094674556 char */
				multiplier = 0.094674556;
				break;
			case XmHTML_CHAR:			/* no conversion required */
				return(*pout);
			default:					/* bad spec */
				_XmHTMLWarning(__WFUNC__(html,
					"_XmHTMLTextCheckAndConvertPaperDef"),
					"Formatted text output: invalid papersize type selected.");
				return(NULL);
		}
	}
	pout.unit_type     = XmHTML_POINT;
	pout.width         *= multiplier;
	pout.height        *= multiplier;
	pout.left_margin   *= multiplier;
	pout.right_margin  *= multiplier;
	pout.top_margin    *= multiplier;
	pout.bottom_margin *= multiplier;

	return(*pout);
}

/*****
* Name:			_XmHTMLTextGetPlain
* Return Type: 	String
* Description: 	converts text between start & end into a plain ASCII document.
* In: 
*	html:		XmHTMLWidget id;
*	pdef:		papersize definition. unittype must be XmHTML_CHAR;
*	start:		start object;
*	end:		end object;
*	options:	unused;
* Returns:
*	a String with plain ASCII content. Must be freed by caller.
*****/
String
_XmHTMLTextGetPlain(XmHTMLWidget html, XmHTMLPaperSize *pdef, 
	XmHTMLObjectTableElement *start, XmHTMLObjectTableElement *end,
	Byte options)
{
	XmHTMLObjectTableElement elePtr;
	static String ret_val;
	int x_pos, y_pos;

	if(pdef->type != XmHTML_CHAR)
	{
		_XmHTMLWarning(__WFUNC__(html, "_XmHTMLTextGetPlain"),
			"Formatted text output: bad call (unittype != XmHTML_CHAR)");
	}

	ret_val = NULL;

	/* default start points */
	x_pos = pdef->left_margin;
	y_pos = pdef->top_margin;

#if 0
	for(elePtr = start; elePtr != end; elePtr = elePtr->next)
	{
		switch(elePtr->object_type)
		{
			case OBJ_TEXT:
			case OBJ_PRE_TEXT:
				/* images, forms & anchors are ignored */
				if(temp->text_data & (TEXT_IMAGE|TEXT_FORM|TEXT_ANCHOR))
					break;
				/*****
				* just plug in all words. Move on to the next line if this
				* word won't fit on it.
				*****/
				break;
			case OBJ_BULLET:
			case OBJ_TABLE:
			case OBJ_APPLET:
			case OBJ_BLOCK:
			case OBJ_NONE:
			default:
				break;
		}
	}
#endif
	return(ret_val);
}

/*****
* Name:			_XmHTMLTextGetFormatted
* Return Type: 	String
* Description: 	converts text between start & end into a somewhat formatted
*				ASCII document.
* In: 
*	html:		XmHTMLWidget id;
*	pdef:		papersize definition. unittype must be XmHTML_CHAR;
*	start:		start object;
*	end:		end object;
*	options:	unused;
* Returns:
*	a String with formatted ASCII content. Must be freed by caller.
*****/
String
_XmHTMLTextGetFormatted(XmHTMLWidget html, XmHTMLPaperSize *pdef, 
	XmHTMLObjectTableElement *start, XmHTMLObjectTableElement *end,
	Byte options)
{
	if(pdef->type != XmHTML_CHAR)
	{
		_XmHTMLWarning(__WFUNC__(html, "_XmHTMLTextGetFormatted"),
			"Formatted text output: bad call (unittype != XmHTML_CHAR)");
	}
	return(NULL);
}

/*****
* Name:			_XmHTMLTextGetPS
* Return Type: 	String
* Description: 	converts text between start & end into a postscript document
* In: 
*	html:		XmHTMLWidget id;
*	pdef:		papersize definition. unittype must be XmHTML_POINT;
*	start:		start object;
*	end:		end object;
*	options:	postscript options (font to use, header, footer cmds);
* Returns:
*	a String with postscript commands. Must be freed by caller.
*****/
String
_XmHTMLTextGetPS(XmHTMLWidget html, XmHTMLPaperSize *pdef, 
	XmHTMLObjectTableElement *start, XmHTMLObjectTableElement *end,
	Byte options)
{
	if(pdef->type != XmHTML_POINT)
	{
		_XmHTMLWarning(__WFUNC__(html, "_XmHTMLTextGetPS"),
			"Formatted text output: bad call (unittype != XmHTML_POINT)");
	}
	return(NULL);
}




