C  -------------------------------------------------------------------
C
C	Copyright (1990-1995) by Alexander Khibnik, Yuri Kuznetsov, and 
C	Eugene Nikolaev.
C
C The Locbif computation code in DsTool is distributed in the hope that it  
C will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty  
C of FITNESS FOR A PARTICULAR PURPOSE.  The software is provided as is without 
C any obligation on the part of Locbif authors, Cornell faculty, 
C Cornell staff or Cornell students to assist in its use, correction, 
C modification or enhancement. 
C
C  -------------------------------------------------------------------

      SUBROUTINE POISK (NX,NFIX,NCAN,IPR,X0,EPS,FUN,DFDX,IER,ISTOP)
C     3.05.90.
C     13.11.92
C     15.06.94
C* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
C*                                                                     *
C*    POPAMMA  POISK  PEHAHAEHA  TOHEH EPBO TOK HA    *
C* KPBO O AAHHOM HAAHOM PEH. CTPATE TOHEH     *
C* OEH POCTA:OACT MEHEH BEEHHO EPEMEHHO X(NG)          *
C* OKPBAETC CETKO C HEKOTOPM AOM. CT X0<1>,X0<2>,...,X0<M>-  *
C*  CETK. HAHA C HEKOTOPOO A X0<K>=X0(NG) EPEPATC     *
C* BCE  B CEEM OPKE:X0<K>,X0<K-1>,X0<K+1>,X0<K-2>  T..   *
C* PEM B KAOM "E" POBOTC EPEOP BCEBOMOHX            *
C* EPOCKOCTE CCKA O TEX OP OKA TOKA HA KPBO HE ET     *
C* HAEHA, O HE POBEPTC BCE "" CETK O EPEMEHHO X(NG).   *
C* . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . *
C*                                                                     *
C*    CCOK OPMAHX APAMETPOB:                                    *
C*                                                                     *
C*    NX   -PAMEPHOCT POCTPAHCTBA EPEMEHHX.                       *
C*    NFIX -HA BXOE B POPAMM - HOMEP BEEHO EPEMEHHO;         *
C*          HA BXOE-HOMEP KCPOBAHHO EPEMEHHO TOHEHHO TOK. *
C*    X0   -HAAHOE PEHHE K EPBO TOKE HA KPBO.           *
C*          (HA BXOE  POPAMM KOOPHAT TOHEHHO TOK)       *
C*    EPS  -TOHOCT OPEEEH TOK HA KPBO.                      *
C*    FUN  -M OPOPAMM HK.                                  *
C*    DFDX -M POPAMM BCEH MATP ACTHX   PBOHX;     *
C*    IER  -KO BOBPATA (IER=0 -COOTBETCTBET HOPMAHOM             *
C*                        ABEPEH PAOT POPAMM).                *
C*    ISTOP-                                                           *
C* ................................................................... *
C*    BBAEME OPOPAMM: NEWTN.                                  *
C* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
C* P MEHEH MAKCMAHOO CA EPEMEHHX NDIM -HEOXOMO ME- *
C* HT PAMEPHOCT MACCBOB XOLD(NDIM),DFUN(NDIM,NDIM),FUNS(NDIM-1)  *
C* HAEHE APAMETPA NDIM.                                            *
C***********************************************************************
C
      IMPLICIT REAL*8 (A-H,O-Z)
      IMPLICIT INTEGER*2 (I-N)
      include 'beetlebf.dim'
      DIMENSION X0(1), XOLD(NDIM), FUNS(NDIM1)
      EXTERNAL FUN, DFDX
      COMMON /ADD5A/ PXGMN, PXGMX
      COMMON /ADD6A/  XGMN,  XGMX
      COMMON /ALL2/ IPOISK
      COMMON /ALL3/  IBND
      COMMON /CNWT1/ IPNT1
C
      COMMON /WORKBE/ DFUN(NDIM,NDIM), ARR2(NDIM,NDIM)
C
      ISTOP = 0
      IPNT1 = 1
C
C.... OPEEEHE BCOMOATEHX APAMETPOB.
C
      NG   = NFIX
      NFUN = NX - 1
      DO 100 I=1,NX
        XOLD(I)=X0(I)
 100  CONTINUE
      DELTA = 0.1D0*(PXGMX - PXGMN)
      XC    = X0(NG)
C
      IF (DELTA.NE.0.D0) GOTO 105  
        MEND = 1
        IND  = -1
        GOTO 108
 105  CONTINUE
C                
      ML    = (XC - PXGMN)/DELTA + 2
      MR    = (PXGMX - XC)/DELTA + 2
      MEND  = MAX0 (ML,MR)
      IND   = -1
      IF (ML .GT. MR) IND = 1
C
 108  CONTINUE
C
      NDR   = 2
      IEND  = 0
C
C.... O K  POXOEH HTEPBAA (PXGMN,PXGMX) C AOM DELTA.
C
#if defined(hib)
      IF (IPR .GE. 1) WRITE (NCAN,2020)
#endif
      DO 170 I=1,MEND
        NEND = NDR
        IF (I .EQ. 1) NEND = 1
        DX0 = (I - 1)*DELTA
C
C.... K TOHEH TOK HA KPBO P PAHX HAEHX X0(NG)
C      HTEPBAA (PXGMN,PXGMX) (O PAHM HAPABEHM CCKA P
C     KAOM HAEH X0(NG)).
C
        DO 160 J=1,NEND
          X0NEW = XC + DX0*IND
          IF (IBND .EQ. 0) GOTO 110
C
C.... POBEPKA BXOA A PAH.
C
          IF (XGMN .LT. X0NEW .AND. X0NEW .LT. XGMX) GOTO 110
C
C.... OCK TOK B PAH.
C
              XBOUND = XGMN
              IF (X0NEW .GT. XGMX) XBOUND = XGMX
              IEND = IEND + 1
              NDR  = 1
              IND  =-1*IND
              X0NEW= XBOUND
 110      CONTINUE
C
C.... TOHEHE TOK B EPOCKOCT X(NG)=CONSTANATA.
C
          NFIX   = NG
          X0(NG) = X0NEW
#if defined(hib)
          IF (IPR .GE. 1) WRITE (NCAN,2000)
          IF (IPR .GE. 1) WRITE (NCAN,2030) X0NEW
          IF (IPR .GE. 1) WRITE (NCAN,2040) NFIX
          IF (IPR .GE. 1) WRITE (NCAN,2050) X0(NFIX)
#endif
          IT     = 10
C
C.... OPAEHE K POEPE HTOHA.
C
          IERN = 0
          CALL NEWTN (NX,NDIM,NG,NFIX,NCAN,X0,EPS,EPSN,IT,IPR,
     A                FUN,DFDX,DFUN,IERN,ISTOP)
          IF (ISTOP .NE. 0) RETURN
          IF (IERN  .EQ. 0) GOTO 180
C
C.... TOKA HA KPBO HE HAEHA.
C
#if defined(hib)
              IF (IPR .GE. 1) WRITE (NCAN,2000)
              IF (IPR .GE. 1) WRITE (NCAN,2060)
              IF (IPR .GE. 1) WRITE (NCAN,2070)
              IF (IPR .GE. 1) WRITE (NCAN,2080)  (X0(IW),IW=1,NX)
              IF (IPR .GE. 1) WRITE (NCAN,2090)
#endif
C
C.... BCM HAEH HK B OCEHE HAEHO TOKE.
C
              IERR = 0
              CALL FUN (X0,FUNS,IERR,ISTOP)
              IF (ISTOP .NE. 0) RETURN
              IF (IERR  .EQ. 0) GOTO 115
#if defined(hib)
                  IF (IPR .GE. 1) WRITE (NCAN,3000)
#endif
 115          CONTINUE
#if defined(hib)
              IF (IPR .GE. 1) WRITE (NCAN,2000)
              IF (IPR .GE. 1) WRITE (NCAN,2080)  (FUNS(IW),IW=1,NFUN)
              IF (IPR .GE. 1) WRITE (NCAN,2010)
#endif
              DO 120 K=1,NX
                 X0(K) = XOLD(K)
 120          CONTINUE
              X0(NG) = X0NEW
              IF (IPOISK .EQ. 0) GOTO 175
C
C.... K EPEOPA BCEBOMOHX EPOCKOCTE CCKA HA KPB.
C
              DO 150 L=1,NX
                 IF (L .EQ. NG) GOTO 140
C
C.... TOHEH TOK B EPOCKOCT X0(NFIX)=CONSTANTA.
C
                     NFIX = L
                     IT   = 10
#if defined(hib)
                     IF (IPR .GE. 1) WRITE (NCAN,2000)
                     IF (IPR .GE. 1) WRITE (NCAN,2030) X0NEW
                     IF (IPR .GE. 1) WRITE (NCAN,2040) NFIX
                     IF (IPR .GE. 1) WRITE (NCAN,2050) X0(NFIX)
#endif
C
C.... OPAEHE K POEPE HTOHA.
C
                     IERN = 0
                     CALL NEWTN (NX,NDIM,NG,NFIX,NCAN,X0,EPS,EPSN,IT,
     A                           IPR,FUN,DFDX,DFUN,IERN,ISTOP)
                     IF (ISTOP .NE. 0) RETURN
                     IF (IERN  .EQ. 0) GOTO 180
C
C.... TOKA HA KPBO HE HAEHA.
C
#if defined(hib)
                         IF (IPR .GE. 1) WRITE (NCAN,2000)
                         IF (IPR .GE. 1) WRITE (NCAN,2060)
                         IF (IPR .GE. 1) WRITE (NCAN,2070)
                         IF (IPR .GE. 1) WRITE (NCAN,2080)
     A                                         (X0(IW),IW=1,NX)
                         WRITE (NCAN,2090)
#endif
C
C.... BCM HAEH HK B OCEHE HAEHO TOKE.
C
                         IERR = 0
                         CALL FUN (X0,FUNS,IERR,ISTOP)
                         IF (ISTOP .NE. 0) RETURN
                         IF (IERR  .EQ. 0) GOTO 125
#if defined(hib)
                             IF (IPR .GE. 1) WRITE (NCAN,3000)
#endif
 125                     CONTINUE
#if defined(hib)
                         IF (IPR.GE.1) WRITE (NCAN,2000)
                         IF (IPR.GE.1 .AND. IERR.EQ.0) WRITE (NCAN,2080)
     A                                         (FUNS(IW),IW=1,NFUN)
                         IF (IPR .GE. 1) WRITE (NCAN,2000)
                         IF (IPR .GE. 1) WRITE (NCAN,2010)
#endif
                         DO 130 K=1,NX
                            X0(K) = XOLD(K)
 130                     CONTINUE
                         X0(NG) = X0NEW
 140             CONTINUE
 150          CONTINUE
C
C.... EPBA TOKA HA KPBO HE HAEHA.
C
              IER   = -1
              IPNT1 = 0
              IF (IEND .EQ. 2) RETURN
                  IF (IEND .EQ. 0) IND = -1*IND
 160    CONTINUE
 170  CONTINUE
 175  CONTINUE
      IER   = -1
      IPNT1 = 0
      RETURN
 180  CONTINUE
C
C.... EPBA TOKA HA KPBO CEHO HAEHA.
C
#if defined(hib)
      IF (IPR .GE. 1) WRITE (NCAN,2000)
      IF (IPR .GE. 1) WRITE (NCAN,3010)
      IF (IPR .GE. 1) WRITE (NCAN,2000)
      IF (IPR .GE. 1) WRITE (NCAN,2080)  (X0(IW),IW=1,NX)
      IF (IPR .GE. 1) WRITE (NCAN,2000)
      IF (IPR .GE. 1) WRITE (NCAN,3020)
#endif
      IER   = 0
      IPNT1 = 0
      RETURN
#if defined(hib)
 2000 FORMAT
     A(1X)
C
 2010 FORMAT
     A(1X,120('-'))
C
 2020 FORMAT
     A('   TOHETC EPBA TOKA HA KPBO.'/
     B '   --------------------------------- ')
C
 2030 FORMAT
     A('   HAEHE BEEHHO EPEMEHHO:        ',G14.5)
C
 2040 FORMAT
     A('   HOMEP KCPOBAHHO EPEMEHHO:        ',I6)
C
 2050 FORMAT
     A('   HAEHE KCPOBAHHO EPEMEHHO:     ',G14.5)
C
 2060 FORMAT
     A('   TOKA HA KPBO HE HAEHA.            '/
     B '   ---------------------------            ')
C
 2070 FORMAT
     A('   KOOPHAT OCEHE BCEHHO TOK:')
C
 2080 FORMAT
     A(10(2X,7(G14.5,1X)/))
C
 2090 FORMAT
     A('   HAEH YHK B OCEHE TOKE:    ')
C
 3000 FORMAT
     A('   HAEH YHK HE BCEH.        ')
C
 3010 FORMAT
     A('   KOOPHAT EPBO TOK HA KPBO:    '
     B/'   ----------------------------------    ')
C
 3020 FORMAT
     A(1X,120('='))
#endif
      END
