// cl_ring debugging support.

// General includes.
#include "cl_sysdep.h"

// Specification.


// Implementation.

#include "cl_ring.h"
#include "cl_io.h"

extern void cl_dprint_unknown (cl_heap* pointer);
static void dprint (cl_heap* pointer)
{
//	var const cl_ring& obj = *(const cl_ring*)&pointer;
	switch (pointer->typetag) {
		case cl_typetag_dummy_ring:
			fprint(cl_debugout, "(cl_ring) cl_no_ring"); break;
		case cl_typetag_null_ring:
			fprint(cl_debugout, "(cl_null_ring) cl_0_ring"); break;
		case cl_typetag_complex_ring:
			fprint(cl_debugout, "(cl_complex_ring) cl_C_ring"); break;
		case cl_typetag_real_ring:
			fprint(cl_debugout, "(cl_real_ring) cl_R_ring"); break;
		case cl_typetag_rational_ring:
			fprint(cl_debugout, "(cl_rational_ring) cl_RA_ring"); break;
		case cl_typetag_integer_ring:
			fprint(cl_debugout, "(cl_integer_ring) cl_I_ring"); break;
		default:
			fprint(cl_debugout, "(cl_ring) ");
			cl_dprint_unknown(pointer);
			break;
	}
}
AT_INITIALIZATION(dprint_ring)
{
	cl_register_typetag_printer(cl_typetag_dummy_ring,dprint);
	cl_register_typetag_printer(cl_typetag_null_ring,dprint);
	cl_register_typetag_printer(cl_typetag_complex_ring,dprint);
	cl_register_typetag_printer(cl_typetag_real_ring,dprint);
	cl_register_typetag_printer(cl_typetag_rational_ring,dprint);
	cl_register_typetag_printer(cl_typetag_integer_ring,dprint);
}

void cl_ring_element::debug_print () const
{
	fprint(cl_debugout, *this);
	fprint(cl_debugout, "\n");
}

// This dummy links in this module when <cl_ring.h> requires it.
int cl_ring_debug_module;
