;; Utilities for using CLN interactively.

;; Missing functionalities:
;; - cannot call the operator-char* converters
;; - cannot access the Z, Q, R, C rings (because of templates)
;; - trying to access (->operator-> (cl_find_modint_ring ...))
;;   results in some obscure error (class-number ())
;; - printing is only possible to ostream, not to Talk streams
;;   (even ostrstream doesn't help)
;; - the cl_float_format_t enum is not well treated: all values are
;;   converted to ()
;; - dynamic typing for subclasses of cl_number
;; - cannot access abs, min, max etc. because of collision with Talk symbols.

(defglobal ostream-cache
  (make-hash-table 1
    (lambda (ht stream)
      (let ((new-ostream (ostream stream)))
        (setf (htref ht stream) new-ostream)
        new-ostream))))

(defmethod prin-object ((x cl_number) stream)
  (setq stream (htref ostream-cache stream))
  (fprint stream x)
  (->flush stream)
)

(defmethod prin-object ((x cl_ring_element) stream)
  (setq stream (htref ostream-cache stream))
  (fprint stream x)
  (->flush stream)
)

(defmethod prin-object ((x cl_string) stream)
  (setq stream (htref ostream-cache stream))
  (fprint stream x)
  (->flush stream)
)

(defmethod prin-object ((x cl_MI) stream)
  (setq stream (htref ostream-cache stream))
  (fprint stream x)
  (->flush stream)
)

(defmethod prin-object ((x cl_UP) stream)
  (setq stream (htref ostream-cache stream))
  (fprint stream x)
  (->flush stream)
)
