/* DSTART                                                                    */
/*                                                                           */
/*           maildrop - mail delivery agent with filtering abilities         */
/*                                                                           */
/*  Copyright 1998, Double Precision Inc.                                    */
/*                                                                           */
/*  This program is distributed under the terms of the GNU General Public    */
/*  License. See COPYING for additional information.                         */
/* DEND                                                                      */
#ifndef	deliverdotlock_h
#define	deliverdotlock_h

static const char deliverdotlock_h_rcsid[]="$Id: deliverdotlock.h 1.2 1998/06/21 17:49:09 mrsam Exp $";

////////////////////////////////////////////////////////////////////////////
//
// When delivering to a mailbox, and there's an exception, the mailbox
// must be truncated BEFORE the dot lock is released.  Override the cleanup()
// virtual function to do the truncation first.
//
////////////////////////////////////////////////////////////////////////////

#include	"dotlock.h"
#include	<sys/types.h>
#include	<sys/stat.h>
#include	"autoconf.h"

class DeliverDotLock : public DotLock {

	void	cleanup();

	int	truncate_fd;
	off_t	truncate_size;
public:
	DeliverDotLock();
	~DeliverDotLock();

	void	trap_truncate(int f, off_t size)
		{
			truncate_size=size;
			truncate_fd=f;
		}
	void	remove_trap() { truncate_fd= -1; }
	void	truncate();
} ;
#endif
