#ifndef _RVS_VFSOPS_H_
#define _RVS_VFSOPS_H_
/*
 * vi:ts=4:sw=4:
 *
 * Project : "Linux Explorer
 * Copyright 1996. All Rights Reserved.
 * 
 * $RCSfile$
 *
 * $Revision$
 * 
 * $Author$ 
 * 
 * $Locker$
 * 
 * $State$
 * 
 * 
 * COPYRIGHT
 * =========
 * 
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * 
 * OVERVIEW
 * ========
 * 
 * $Log$
 */


class VFStat
{
	enum stat_types { Dir, File, SoftLink, HardLink, Socket, Pipe, BlockDev, CharDev };

	size_t size;	// size in bytes
	
	mode_t mode;	// ugsrwxrwxrwx
	uid_t  owner;	// numeric owner id
	gid_t  group;	// numeric group id

	time_t	atime, mtime, ctime;
	
};

class VFSOps
{
	// This class is the base for both directory and filelike entities.
	
	public:

	enum open_modes { Read=0x1 , Write=0x2 };
	enum seek_modes { Start, Current, End };
	enum vfs_result	{ Eof=-1, Ok=0, IoErr, IoTimeout, Aborted, IllOp};
	
	protected:

	//
	// do_io is called when a translation of data is needed.
	// 
	// result = do_io(mode, buffer, len)
	//
	// mode: Seek, Write or Read
	// buffer: buffer to read/write in 
	// len: size of bufferspace
	//
	// result: the contents of buffer will be cached when result is 'Ok'
	//         the cached data is passed back on sequential accesses,
	//         until the cache entry for that file becomes invalid.
	//         a cache entry becomes invalid when 
	//         - mtime is newer than the last cache acces
	//         - the cache is explicitly cleared.

	virtual int do_io(int, void *, size_t)=0;


	// result = do_stat(szFilename)
	//
	// 

	virtual int do_stat(const char*, VFSStat*);

	public:
	
	Open(const char*,int);
	Close();
	
	Stat();
	setStat(const VFStat &);
	
	int Errno();
	
	size_t	Read(void*,size_t);
	size_t	Write(void*, size_t);
	off_t	Seek(off_t);
	
};

class VFSDir : public VFSL_ops
{
	// VFSL Directories are NULL terminated ASCII strings

	VFSDir(VFS*,);

	ChangeDir(const char*);
	CreateDir(const char*);
	DeleteDir(const char*);
};

class VFSFile : public VFSL_ops
{
	// VFSL Files uses the underlying filesystem to read/write data from
};

#endif // _RVS_VFSOPS_H_
