#ifndef __MENU_H__
#define __MENU_H__

/*
 * vi:ts=4:sw=4:
 *
 * Project : "Linux Explorer"
 * Copyright 1996. All Rights Reserved.
 * 
 * $RCSfile: menu.h,v $
 *
 * $Revision: 1.4 $
 * 
 * $Author: ruben $ 
 * 
 * $Locker:  $
 * 
 * $State: Exp $
 * 
 * 
 * COPYRIGHT
 * =========
 * 
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * 
 * OVERVIEW
 * ========
 * 
 * $Log: menu.h,v $
 * Revision 1.4  1997/06/09 12:59:23  ruben
 * switched rcs commands again I think...
 * compiled with -Wall -Werror, fixed bugs and potential bugs
 * fixed Mister Data bugs
 *
 * Revision 1.3  1997/05/27  09:02:10  ruben
 * reworked include strategy for developers ease
 * also some indent done
 *
 * Revision 1.3  1997/05/27  09:02:10  ruben
 * reworked include strategy for developers ease
 * also some indent done
 *
 * Revision 1.2  1997/04/06 21:34:09  ruben
 * reworked char* signals to const char* ones
 * Added rescan mountlist routines
 *
 * Revision 1.1  1997/03/28 17:48:16  ruben
 * Initial revision
 *
 */

#include <qwidget.h>
#include <qmenubar.h>
#include <qlabel.h>

#include "dialogs.h"

class   ExplorerMenu:public QWidget
{
	Q_OBJECT

  public:

	ExplorerMenu(QWidget * parent = 0,
				 const char *name = 0);

	QMenuBar *get_menu();

  public slots:

	void mi_about();
	void mi_help();
	void mi_config();
	
	void dummy();
	
	void mi_new_item ();
	void mi_create_link ();
	void mi_delete_nodes ();
	void mi_node_properties ();
	
	void mi_select_all ();
	void mi_select_inverse ();
	
	void mi_go_to_mount();
	void mi_go_to_home();
	
        void mi_rescan_mountedfss(); // mi is for MenuItem
                                     // I want my signals clear :)
                                     // ok ok whatever :)
        void mi_rescan_dir();                                      
                             
        void mi_showtoolbar ();                                     
        void mi_showstatusbar ();
        void mi_showframebar ();
        void mi_showpluginframe ();
                                              
  protected:

	void resizeEvent(QResizeEvent *);

  private:

	QMenuBar *menu;
	QPopupMenu *view;
	 
	int toolbar_id;  
	int statusbar_id; 
	int framebar_id;
	int pluginview_id;

  signals:

	void go_to(const char *);
	void rescan_mtab();
	void rescan_dir();
	void emit_link (char *);
	void do_select_all ();
	void do_select_inverse ();  
	
	void show_toolbar ();
	void show_statusbar ();
	void show_framebar ();	
	void show_pluginframe ();
};

#endif	 // __MENU_H__
