/*
 * vi:ts=4:sw=4:
 *
 * Project : "MindsEye"
 * Copyright 1996. All Rights Reserved.
 * 
 * $RCSfile: parse_tools.cpp,v $
 *
 * $Revision: 1.0 $
 * 
 * $Author:  $ 
 * 
 * $Locker:  $
 * 
 * $State: Exp $
 * 
 * 
 * COPYRIGHT
 * =========
 * 
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * 
 * OVERVIEW
 * ========
 *
 *
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif	 // HAVE_CONFIG_H

#define __DEBUG_CALLBACK__   // uncomment this one if you want to see 
                             // the callback output

#include "parse_tools.h"
#include "parser.h"
#include "m_config.h"

/*---------------------------------------------------------------------------*/
char *remove_delimit (char *string)
{
 string++;
 string [strlen (string)-1]=0;

 return (string);
}
/*---------------------------------------------------------------------------*/


//>------------ token callback functions


/*---------------------------------------------------------------------------*/
void create_group (ConfigClass *temp_config,char *token)
{
#ifdef __DEBUG_CALLBACK__
 printf ("Adding group [%s]\n",
         token);
#endif

 temp_config->create_group (token);
}
/*---------------------------------------------------------------------------*/
void create_var (ConfigClass *temp_config,char *token)
{

#ifdef __DEBUG_CALLBACK__
 printf ("Adding variable [%s] to group []\n",
         token);
#endif

 temp_config->create_var (token);
}
/*---------------------------------------------------------------------------*/
void add_integer (ConfigClass *temp_config,int token)
{

#ifdef __DEBUG_CALLBACK__
 printf ("Adding value [%d] to variable [] in group []\n",
         token);
#endif

 temp_config->add_integer (token);
}
/*---------------------------------------------------------------------------*/
void add_float (ConfigClass *temp_config,float token)
{

#ifdef __DEBUG_CALLBACK__
 printf ("Adding value [%f] to variable [] in group []\n",
         token);
#endif

 temp_config->add_float (token); 
}
/*---------------------------------------------------------------------------*/
void add_string (ConfigClass *temp_config,char *token)
{

#ifdef __DEBUG_CALLBACK__
 printf ("Adding value [%s] to variable [] in group []\n",
         token);
#endif

 temp_config->add_string (token);
}
/*---------------------------------------------------------------------------*/
