extern "C"
{
#include <stdio.h>
}
#include "Style.h"
#include "StyleSheetProto.h"

StyleSheetProto::StyleSheetProto()
{
    // Create a prototype for each display style.
    DisplayProto* anchor         = new DisplayProto( "Anchor"           , "anchor"          , Style::Anchor );
    DisplayProto* base           = new DisplayProto( "Base"             , "base"            , Style::Base );
    DisplayProto* block          = new DisplayProto( "Block"            , "block"           , Style::Block );
    DisplayProto* form           = new DisplayProto( "Form"             , "form"            , Style::Form );
    DisplayProto* formButton     = new DisplayProto( "Form Button"      , "form-button"     , Style::FormButton );
    DisplayProto* formCheckBox   = new DisplayProto( "Form Check Box"   , "form-checkbox"   , Style::FormCheckBox );
    DisplayProto* formEntry      = new DisplayProto( "Form Entry"       , "form-entry"      , Style::FormEntry );
    DisplayProto* formHidden     = new DisplayProto( "Form Hidden"      , "form-hidden"     , Style::FormHidden );
    DisplayProto* formImage      = new DisplayProto( "Form Image"       , "form-image"      , Style::FormImage );
    DisplayProto* formListBox    = new DisplayProto( "Form List Box"    , "form-listbox"    , Style::FormListBox );
    DisplayProto* formMLE        = new DisplayProto( "Form MLE"         , "form-mle"        , Style::FormMLE );
    DisplayProto* formOption     = new DisplayProto( "Form Option"      , "form-option"     , Style::FormOption );
    DisplayProto* formOptionMenu = new DisplayProto( "Form Option Menu" , "form-option-menu", Style::FormOptionMenu );
    DisplayProto* formRadio      = new DisplayProto( "Form Radio Button", "form-radio"      , Style::FormRadio );
    DisplayProto* hline          = new DisplayProto( "Horizontal Line"  , "hline"           , Style::HLine );
    DisplayProto* hyperlink      = new DisplayProto( "Hyperlink"        , "hyperlink"       , Style::Hyperlink );
    DisplayProto* image          = new DisplayProto( "Image"            , "image"           , Style::Image );
    DisplayProto* Inline         = new DisplayProto( "Inline"           , "inline"          , Style::Inline );
    DisplayProto* table          = new DisplayProto( "Table"            , "table"           , Style::Table );
    DisplayProto* tableData      = new DisplayProto( "Table Data"       , "table-data"      , Style::TableData );
    DisplayProto* tableRow       = new DisplayProto( "Table Row"        , "table-row"       , Style::TableRow );
    DisplayProto* title          = new DisplayProto( "Title"            , "title"           , Style::Title );

    _displayProtos.append( anchor );
    _displayProtos.append( base );
    _displayProtos.append( block );
    _displayProtos.append( form );
    _displayProtos.append( formButton );
    _displayProtos.append( formCheckBox );
    _displayProtos.append( formEntry );
    _displayProtos.append( formHidden );
    _displayProtos.append( formImage );
    _displayProtos.append( formListBox );
    _displayProtos.append( formMLE );
    _displayProtos.append( formOption );
    _displayProtos.append( formOptionMenu );
    _displayProtos.append( formRadio );
    _displayProtos.append( hline );
    _displayProtos.append( hyperlink );
    _displayProtos.append( image );
    _displayProtos.append( Inline );
    _displayProtos.append( table );
    _displayProtos.append( tableData );
    _displayProtos.append( tableRow );
    _displayProtos.append( title );

    // Create individual style attribute prototypes, and associate them with
    // the appropriate display prototypes.
    StyleAttrProto* attr;

    attr = new StyleAttrProto( "Alignment"            , "alignment"       , StyleAttrProto::Enumerated, TRUE );
    _attrProtos.append( attr );
    attr->enumMap().append( new StyleAttrProto::EnumMap( "Left"  , "left"  , Style::Left   ) );
    attr->enumMap().append( new StyleAttrProto::EnumMap( "Right" , "right" , Style::Right  ) );
    attr->enumMap().append( new StyleAttrProto::EnumMap( "Center", "center", Style::Center ) );
    block->attrProtos.append( attr );
    table->attrProtos.append( attr );
    tableData->attrProtos.append( attr );
    tableRow->attrProtos.append( attr );

    attr = new StyleAttrProto( "Anchor Attribute"     , "anchor-attr"     , StyleAttrProto::String    , FALSE );
    _attrProtos.append( attr );
    anchor->attrProtos.append( attr );

    attr = new StyleAttrProto( "Action Attribute"     , "action-attr"     , StyleAttrProto::String    , FALSE );
    _attrProtos.append( attr );
    form->attrProtos.append( attr );

    attr = new StyleAttrProto( "Cell Padding"         , "cell-padding"    , StyleAttrProto::Number    , FALSE );
    _attrProtos.append( attr );
    table->attrProtos.append( attr );

    attr = new StyleAttrProto( "Checked Attribute"    , "checked-attr"    , StyleAttrProto::String    , FALSE );
    _attrProtos.append( attr );
    formCheckBox->attrProtos.append( attr );
    formRadio->attrProtos.append( attr );

    attr = new StyleAttrProto( "Color"                , "color"           , StyleAttrProto::String    , TRUE  );
    _attrProtos.append( attr );
    block->attrProtos.append( attr );
    form->attrProtos.append( attr );
    hyperlink->attrProtos.append( attr );
    Inline->attrProtos.append( attr );
    table->attrProtos.append( attr );
    tableData->attrProtos.append( attr );
    tableRow->attrProtos.append( attr );

    attr = new StyleAttrProto( "Columns Attribute"    , "columns-attr"    , StyleAttrProto::String    , FALSE );
    _attrProtos.append( attr );
    formMLE->attrProtos.append( attr );

    attr = new StyleAttrProto( "Column Span Attr"     , "column-span-attr", StyleAttrProto::String    , FALSE );
    _attrProtos.append( attr );
    tableData->attrProtos.append( attr );

    attr = new StyleAttrProto( "Font Family"          , "font-family"     , StyleAttrProto::List      , TRUE  );
    _attrProtos.append( attr );
    attr->enumMap().append( new StyleAttrProto::EnumMap( "charter"               , 0, 0 ) );
    attr->enumMap().append( new StyleAttrProto::EnumMap( "clean"                 , 0, 0 ) );
    attr->enumMap().append( new StyleAttrProto::EnumMap( "courier"               , 0, 0 ) );
    attr->enumMap().append( new StyleAttrProto::EnumMap( "fixed"                 , 0, 0 ) );
    attr->enumMap().append( new StyleAttrProto::EnumMap( "gothic"                , 0, 0 ) );
    attr->enumMap().append( new StyleAttrProto::EnumMap( "helvetica"             , 0, 0 ) );
    attr->enumMap().append( new StyleAttrProto::EnumMap( "lucida"                , 0, 0 ) );
    attr->enumMap().append( new StyleAttrProto::EnumMap( "lucidabright"          , 0, 0 ) );
    attr->enumMap().append( new StyleAttrProto::EnumMap( "lucidatypewriter"      , 0, 0 ) );
    attr->enumMap().append( new StyleAttrProto::EnumMap( "new century schoolbook", 0, 0 ) );
    attr->enumMap().append( new StyleAttrProto::EnumMap( "symbol"                , 0, 0 ) );
    attr->enumMap().append( new StyleAttrProto::EnumMap( "terminal"              , 0, 0 ) );
    attr->enumMap().append( new StyleAttrProto::EnumMap( "times"                 , 0, 0 ) );
    block->attrProtos.append( attr );
    form->attrProtos.append( attr );
    hyperlink->attrProtos.append( attr );
    Inline->attrProtos.append( attr );
    table->attrProtos.append( attr );
    tableData->attrProtos.append( attr );
    tableRow->attrProtos.append( attr );

    attr = new StyleAttrProto( "Font Size"            , "font-size"       , StyleAttrProto::Number    , TRUE  );
    _attrProtos.append( attr );
    block->attrProtos.append( attr );
    form->attrProtos.append( attr );
    hyperlink->attrProtos.append( attr );
    Inline->attrProtos.append( attr );
    table->attrProtos.append( attr );
    tableData->attrProtos.append( attr );
    tableRow->attrProtos.append( attr );

    attr = new StyleAttrProto( "Font Style"           , "font-style"      , StyleAttrProto::Enumerated, TRUE  );
    _attrProtos.append( attr );
    attr->enumMap().append( new StyleAttrProto::EnumMap( "Normal", "normal", Style::Normal ) );
    attr->enumMap().append( new StyleAttrProto::EnumMap( "Italic", "italic", Style::Italic ) );
    block->attrProtos.append( attr );
    form->attrProtos.append( attr );
    hyperlink->attrProtos.append( attr );
    Inline->attrProtos.append( attr );
    table->attrProtos.append( attr );
    tableData->attrProtos.append( attr );
    tableRow->attrProtos.append( attr );

    attr = new StyleAttrProto( "Font Weight"          , "font-weight"     , StyleAttrProto::Enumerated, TRUE  );
    _attrProtos.append( attr );
    attr->enumMap().append( new StyleAttrProto::EnumMap( "Normal", "normal", Style::Normal ) );
    attr->enumMap().append( new StyleAttrProto::EnumMap( "Bold"  , "bold"  , Style::Bold   ) );
    block->attrProtos.append( attr );
    form->attrProtos.append( attr );
    hyperlink->attrProtos.append( attr );
    Inline->attrProtos.append( attr );
    table->attrProtos.append( attr );
    tableData->attrProtos.append( attr );
    tableRow->attrProtos.append( attr );

    attr = new StyleAttrProto( "Height Attribute"     , "height-attr"     , StyleAttrProto::String    , FALSE );
    _attrProtos.append( attr );
    formImage->attrProtos.append( attr );
    image->attrProtos.append( attr );

    attr = new StyleAttrProto( "Link Attribute"       , "link-attr"       , StyleAttrProto::String    , FALSE );
    _attrProtos.append( attr );
    base->attrProtos.append( attr );
    hyperlink->attrProtos.append( attr );

    attr = new StyleAttrProto( "Is Map Attribute"     , "is-map-attr"     , StyleAttrProto::String    , FALSE );
    _attrProtos.append( attr );
    image->attrProtos.append( attr );

    attr = new StyleAttrProto( "Margin Bottom"        , "margin-bottom"   , StyleAttrProto::Number    , FALSE );
    _attrProtos.append( attr );
    block->attrProtos.append( attr );
    form->attrProtos.append( attr );
    hline->attrProtos.append( attr );
    table->attrProtos.append( attr );
    tableData->attrProtos.append( attr );

    attr = new StyleAttrProto( "Margin Left"          , "margin-left"     , StyleAttrProto::Number    , FALSE );
    _attrProtos.append( attr );
    block->attrProtos.append( attr );
    form->attrProtos.append( attr );
    hline->attrProtos.append( attr );
    table->attrProtos.append( attr );
    tableData->attrProtos.append( attr );

    attr = new StyleAttrProto( "Margin Right"         , "margin-right"    , StyleAttrProto::Number    , FALSE );
    _attrProtos.append( attr );
    block->attrProtos.append( attr );
    form->attrProtos.append( attr );
    hline->attrProtos.append( attr );
    table->attrProtos.append( attr );
    tableData->attrProtos.append( attr );

    attr = new StyleAttrProto( "Margin Top"           , "margin-top"      , StyleAttrProto::Number    , FALSE );
    _attrProtos.append( attr );
    block->attrProtos.append( attr );
    form->attrProtos.append( attr );
    hline->attrProtos.append( attr );
    table->attrProtos.append( attr );
    tableData->attrProtos.append( attr );

    attr = new StyleAttrProto( "Max Length Attribute" , "max-length-attr" , StyleAttrProto::String    , FALSE );
    _attrProtos.append( attr );
    formEntry->attrProtos.append( attr );

    attr = new StyleAttrProto( "Method Attribute"     , "method-attr"     , StyleAttrProto::String    , FALSE );
    _attrProtos.append( attr );
    form->attrProtos.append( attr );

    attr = new StyleAttrProto( "Multiple Attribute"   , "multiple-attr"   , StyleAttrProto::String    , FALSE );
    _attrProtos.append( attr );
    formListBox->attrProtos.append( attr );

    attr = new StyleAttrProto( "Name Attribute"       , "name-attr"       , StyleAttrProto::String    , FALSE );
    _attrProtos.append( attr );
    formButton->attrProtos.append( attr );
    formCheckBox->attrProtos.append( attr );
    formEntry->attrProtos.append( attr );
    formHidden->attrProtos.append( attr );
    formImage->attrProtos.append( attr );
    formListBox->attrProtos.append( attr );
    formMLE->attrProtos.append( attr );
    formOptionMenu->attrProtos.append( attr );
    formRadio->attrProtos.append( attr );

    attr = new StyleAttrProto( "Password"             , "is-password"     , StyleAttrProto::Flag      , FALSE );
    _attrProtos.append( attr );
    formEntry->attrProtos.append( attr );

    attr = new StyleAttrProto( "Prefix"               , "prefix"          , StyleAttrProto::Enumerated, TRUE  );
    _attrProtos.append( attr );
    attr->enumMap().append( new StyleAttrProto::EnumMap( "None"  , "none"  , Style::None   ) );
    attr->enumMap().append( new StyleAttrProto::EnumMap( "Bullet", "bullet", Style::Bullet ) );
    attr->enumMap().append( new StyleAttrProto::EnumMap( "Number", "number", Style::Bullet ) );
    block->attrProtos.append( attr );

    attr = new StyleAttrProto( "Reset"                , "is-reset"        , StyleAttrProto::Flag      , FALSE );
    _attrProtos.append( attr );
    formButton->attrProtos.append( attr );
    
    attr = new StyleAttrProto( "Row Span Attr"        , "row-span-attr"   , StyleAttrProto::String    , FALSE );
    _attrProtos.append( attr );
    tableData->attrProtos.append( attr );

    attr = new StyleAttrProto( "Rows Attribute"       , "rows-attr"       , StyleAttrProto::String    , FALSE );
    _attrProtos.append( attr );
    formMLE->attrProtos.append( attr );

    attr = new StyleAttrProto( "Selected Attribute"   , "selected-attr"   , StyleAttrProto::String    , FALSE );
    _attrProtos.append( attr );
    formOption->attrProtos.append( attr );

    attr = new StyleAttrProto( "Size Attribute"       , "size-attr"       , StyleAttrProto::String    , FALSE );
    _attrProtos.append( attr );
    formEntry->attrProtos.append( attr );
    formListBox->attrProtos.append( attr );

    attr = new StyleAttrProto( "Source Attribute"     , "source-attr"     , StyleAttrProto::String    , FALSE );
    _attrProtos.append( attr );
    image->attrProtos.append( attr );
    formImage->attrProtos.append( attr );

    attr = new StyleAttrProto( "Submit"               , "is-submit"       , StyleAttrProto::Flag      , FALSE );
    _attrProtos.append( attr );
    formButton->attrProtos.append( attr );

    attr = new StyleAttrProto( "Text Decoration"      , "text-decoration" , StyleAttrProto::Enumerated, TRUE  );
    _attrProtos.append( attr );
    attr->enumMap().append( new StyleAttrProto::EnumMap( "Normal"   , "normal"   , Style::Normal    ) );
    attr->enumMap().append( new StyleAttrProto::EnumMap( "Underline", "underline", Style::Underline ) );
    block->attrProtos.append( attr );
    form->attrProtos.append( attr );
    hyperlink->attrProtos.append( attr );
    Inline->attrProtos.append( attr );
    table->attrProtos.append( attr );
    tableData->attrProtos.append( attr );
    tableRow->attrProtos.append( attr );

    attr = new StyleAttrProto( "Use Map Attribute"    , "use-map-attr"    , StyleAttrProto::String    , FALSE );
    _attrProtos.append( attr );
    image->attrProtos.append( attr );

    attr = new StyleAttrProto( "Value Attribute"      , "value-attr"      , StyleAttrProto::String    , FALSE );
    _attrProtos.append( attr );
    formButton->attrProtos.append( attr );
    formCheckBox->attrProtos.append( attr );
    formEntry->attrProtos.append( attr );
    formHidden->attrProtos.append( attr );
    formOption->attrProtos.append( attr );
    formRadio->attrProtos.append( attr );

    attr = new StyleAttrProto( "White Space"          , "white-space"     , StyleAttrProto::Enumerated, TRUE  );
    _attrProtos.append( attr );
    attr->enumMap().append( new StyleAttrProto::EnumMap( "Normal"      , "normal", Style::Normal ) );
    attr->enumMap().append( new StyleAttrProto::EnumMap( "Preformatted", "pre"   , Style::Pre    ) );
    block->attrProtos.append( attr );
    form->attrProtos.append( attr );
    table->attrProtos.append( attr );
    tableData->attrProtos.append( attr );
    tableRow->attrProtos.append( attr );

    attr = new StyleAttrProto( "Width Attribute"      , "width-attr"      , StyleAttrProto::String    , FALSE );
    _attrProtos.append( attr );
    formImage->attrProtos.append( attr );
    image->attrProtos.append( attr );
}

StyleSheetProto::~StyleSheetProto()
{
    while ( _attrProtos.first() ) {
	delete _attrProtos.first();
	_attrProtos.remove();
    }
    while ( _displayProtos.first() ) {
	delete _displayProtos.first();
	_displayProtos.remove();
    }
}

StyleAttrProto* StyleSheetProto::findProto( const QString& name )
{
    for ( _attrProtos.first(); _attrProtos.current(); _attrProtos.next() ) {
        if ( _attrProtos.current()->token() == name ) {
            return _attrProtos.current();
        }
    }

    return 0;
}

StyleSheetProto::DisplayProto* StyleSheetProto::findDisplay( const QString& name )
{
    for ( _displayProtos.first(); _displayProtos.current(); _displayProtos.next() ) {
        if ( _displayProtos.current()->token == name ) {
            return _displayProtos.current();
        }
    }

    return 0;
}
