// QWeb - An SGML Web Browser
// Copyright (C) 1997  Sean Vyain
// svyain@mail.tds.net
// smvyain@softart.com
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#ifndef _StyleParser_h_
#define _StyleParser_h_

#include <qobject.h>
#include <qstrlist.h>
#include "StyleLexer.h"
#include "StyleSheet.h"
#include "StyleSheetProto.h"

//: The StyleParser class parses a data stream into a StylSheet.
class StyleParser : public QObject {
    Q_OBJECT
    StyleSheet*                    _styleSheet;
    Style*                         _style;
    QString                        _attrName;
    QString                        _attrValue;
    StyleSheetProto::DisplayProto* _displayProto;

    enum {
        Selector,
        SelectorAttrs,
        DeclAttr,
        DeclValue
    } _state;

    //. Accumulate a list of elements that will have a group of styles applied
    //. to them.
    void stateSelector( StyleLexer::Token token, QString text );

    void stateSelectorAttrs( StyleLexer::Token token, QString text );

    void stateDeclAttr( StyleLexer::Token token, QString text );

    void stateDeclValue( StyleLexer::Token token, QString text );
public:
    //. Create a new StyleParser for the given style sheet.  Create a
    //. StyleLexer to tokenize the input stream.
    StyleParser( StyleSheet* styleSheet );
    ~StyleParser();
public slots:
    //. Process any remaining tokens, and die.
    void done();

    //. Forward the data signals to the StyleLexer.
    void data( const char* bytes, int length );

    //. Forward the endOfData signal to the StyleLexer.
    void endOfData();

    //. Process a token from the StylLexer.
    void token( StyleLexer::Token token, QString text );
signals:
    //. This signal is used to forward the data signals to the StyleLexer.
    void fwdData( const char* bytes, int length );

    //. This signal is used to forward the endOfData signal to the StyleLexer.
    void fwdEndOfData();

    //. This signal is emitted after the parser has finished.
    void done( StyleSheet* styleSheet );
};

#endif
