// QWeb - An SGML Web Browser
// Copyright (C) 1997  Sean Vyain
// svyain@mail.tds.net
// smvyain@softart.com
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#include <qfontmet.h>
#include "ButtonRenderer.h"
#include "Canvas.h"
#include "CheckBoxRenderer.h"
#include "EntryRenderer.h"
#include "ImageRenderer.h"
#include "ListBoxRenderer.h"
#include "OptionRenderer.h"
#include "PreformatRenderer.h"
#include "RadioRenderer.h"
#include "Style.h"
#include "StyleSheet.h"
#include "TextAreaRenderer.h"

PreformatRenderer::PreformatRenderer( Canvas*      canvas,
                                      SgmlParser*  parser,
                                      int          clipWidth,
                                      QObject*     parent,
                                      const char*  name )
        : TextRenderer( canvas, parser, clipWidth, parent, name ),
          _column( 0 )
{
}

void PreformatRenderer::content( QString text )
{
    if ( _textArea ) {
        _textArea->content( text );
        return;
    } else if ( ( _option ) || ( _listBox ) ) {
        _optionText += text;
        return;
    }
    
    bool          newWords = FALSE;
    int           idx1;
    uint          idx2;
    WordRenderer* word;
    bool          endOfLine;
    QString       url;
    QString       line;
    QString       spaces = "        ";

    _leftover += text;

    // Each word is an entire line with all its spaces preserved.
    while ( _leftover.length() ) {
        idx1 = _leftover.find( '\n' );
        if ( ( idx1 < 0 ) && ( !_done ) ) {
            // Need more data.
            if ( newWords ) needRedraw();
            return;
        } else {
            endOfLine = ( idx1 >= 0 );
            if ( idx1 < 0 ) {
                idx1 = _leftover.length();
            }

            // Expand tabs into spaces.
            line = _leftover.left( idx1 );
            for ( idx2 = 0; idx2 < line.length(); idx2++ ) {
                if ( line[idx2] == '\t' ) {
                    line.replace( idx2, 1, spaces.left( 8 - ( _column + idx2 ) % 8 ) );
                }
            }
            _column += line.length();
            
            word = new WordRenderer( line, FALSE, FALSE, endOfLine, canvas(), 0, this );
            if ( parser() ) {
                url = findHyperlink( FALSE );
                if ( url.length() ) {
                    canvas()->registerMouseZone( word, url );
                }
            }
            _leftover.remove( 0, idx1 + 1 );
            _renderers.append( word );
            newWords = TRUE;
            
            if ( endOfLine ) {
                _column = 0;
            }
        }
    }

    if ( newWords ) needRedraw();
}

bool PreformatRenderer::redraw()
{
    // Give my kids a chance to redraw.
    bool b = FALSE;
    Renderer* r;
    for ( r = _renderers.first(); r; r = _renderers.next() ) {
        if ( r->redraw() ) {
            b = TRUE;
        }
    }

    // Do I really need to do anything?
    if ( !_needRedraw ) return b;
    
    int  lineHeight = 0;
    int  lineWidth = 0;
    int  h = 0;
    bool startNewLine = FALSE;
    StyleRenderer* style = 0;

    // Destroy any existing lines.
    while ( _lines.first() ) {
        delete _lines.first();
        _lines.removeFirst();
    }

    QFontMetrics* fm = 0;

    // Draw the text.
    _lines.append( new Line );
    _lines.last()->style = (StyleRenderer*)_renderers.first();
    for ( r = _renderers.first(); r; r = _renderers.next() ) {
        if ( !strcmp( r->className(), "StyleRenderer" ) ) {
            style = (StyleRenderer*)r;
            delete fm;
            fm = new QFontMetrics( style->font() );
        }

        if ( !strcmp( r->className(), "WordRenderer" ) ) {
            r->resize( fm->width( ((WordRenderer*)r)->word() ), fm->height() );
        }
        
        if ( startNewLine ) {
            // Update minimum width.
            if ( _minimumWidth < lineWidth ) {
                _minimumWidth = _maximumWidth = lineWidth;
            }
            
            // Put the word on the next line.
            _lines.last()->setRect( 0, h, lineWidth, h + lineHeight - 1 );
            _lines.append( new Line );
            _lines.last()->style = style;
            h += lineHeight;
            lineWidth = 0;
            lineHeight = r->height();

            r->move( lineWidth, h );

            lineWidth = r->width();

            _lines.last()->renderers.append( r );
        } else {
            // Put the word on this line.
            if ( lineHeight < r->height() ) {
                lineHeight = r->height();
            }

            r->move( lineWidth, h );

            lineWidth += r->width();
            _lines.last()->renderers.append( r );
        }
        startNewLine = ( ( !strcmp( r->className(), "WordRenderer" ) ) && ((WordRenderer*)r)->endOfLine() );
    }
    _lines.last()->setRect( 0, h, lineWidth, h + lineHeight - 1 );
    h += lineHeight;

    delete fm;

    // Resize the widget.
    if ( clipWidth() < _minimumWidth ) {
        resize( _minimumWidth, h );
    } else {
        resize( clipWidth(), h );
    }

    _needRedraw = FALSE;

    return TRUE;
}
