// QWeb - An SGML Web Browser
// Copyright (C) 1997  Sean Vyain
// svyain@mail.tds.net
// smvyain@softart.com
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#ifndef _Poller_h_
#define _Poller_h_

#include <qobject.h>
#include <qlist.h>

class Connection;

//: The Poller class is responsible for periodically checking for waiting data on a set of file descriptors.
//. There is only one, global poller object that handles all of the open file
//. descriptors for the entire application.  Connections can register and
//. deregister their file descriptors at any time.  Then, every 100ms the
//. poller will check to see if any of the file descriptors have become
//. readable, writable, or had an exception occur.  The appropriate connection
//. is then notified of the event.
class Poller : public QObject {
    class Pair {
    public:
        Pair( Connection* c, int f ) : conn( c ), fd( f ) {}
        Connection* conn;
        int         fd;
    };
	
    QList<Pair> _fdList;
public:
    //. Create a new poller.
    Poller();

    //. Destroy the poller.
    ~Poller() {}

    //. Register a connection/file descriptor pair with the Poller.  Every
    //. 100ms, the Poller will use select to determine if anything interesting
    //. has happened to the file descriptor, and it will notify the connection.
    void reg( Connection* conn, int fd );

    //. Deregister a connection/file descriptor pair.  The Poller will no
    //. longer query the status of the file descriptor.
    void dereg( Connection* conn, int fd );
protected:
    //. Use select() to determine if any of the file descriptors are readable,
    //. writable, or an exception has occurred.  Notify the appropriate
    //. Connection for each type of event.
    virtual void timerEvent( QTimerEvent* e );
};

extern Poller* poller;

#endif
