// QWeb - An SGML Web Browser
// Copyright (C) 1997  Sean Vyain
// svyain@mail.tds.net
// smvyain@softart.com
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#include <qcombo.h>
#include "Canvas.h"
#include "OptionRenderer.h"

OptionRenderer::OptionRenderer( Canvas*     canvas,
                                int         clipWidth,
                                QObject*    parent,
                                const char* name )
        : FormObjectRenderer( canvas, clipWidth, parent, name ),
          _selected( 0 )
{
    _comboBox = new QComboBox( canvas->clip() );
    canvas->registerWidget( this, _comboBox );
    
    int w = _comboBox->sizeHint().width();
    int h = _comboBox->sizeHint().height();

    _comboBox->setGeometry( 4, 4, w, h );

    _minimumWidth = w + 8;
    _maximumWidth = w + 8;
    resize( w + 8, h + 8 );
}

QString OptionRenderer::value()
{
    QString nm  = name();
    QString val = _values.at( _comboBox->currentItem() );

    if ( ( nm.length() == 0 ) || ( val.length() == 0 ) ) {
        return "";
    }

    Url::encode( nm );
    Url::encode( val );

    QString tmp;
    tmp.sprintf( "%s=%s", nm.data(), val.data() );
    return tmp;
}

void OptionRenderer::reset()
{
    _comboBox->setCurrentItem( _selected );
}

bool OptionRenderer::redraw()
{
    int w = _comboBox->sizeHint().width();
    int h = _comboBox->sizeHint().height();

    if ( ( w != _comboBox->width() ) || ( h != _comboBox->height() ) ) {
        _comboBox->resize( w, h );

        _minimumWidth = w + 8;
        _maximumWidth = w + 8;
        resize( w + 8, h + 8 );

        return TRUE;
    }

    return FALSE;
}

void OptionRenderer::endOfData()
{
}

void OptionRenderer::addItem( const char* text,
                              bool        selected,
                              const char* value )
{
    _comboBox->insertItem( text );
    if ( selected ) {
        _comboBox->setCurrentItem( _comboBox->count() - 1 );
        _selected = _comboBox->count() - 1;
    }
    if ( value ) {
        _values.append( value );
    } else {
        _values.append( text );
    }
}
