// QWeb - An SGML Web Browser
// Copyright (C) 1997  Sean Vyain
// svyain@mail.tds.net
// smvyain@softart.com
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#include <qmsgbox.h>
#include <qstring.h>
#include "HostCache.h"

extern "C"
{
#ifndef __linux
// For Solaris ... sheesh!
void bcopy(const void *s1, void *s2, size_t n);
#endif
}

extern int h_errno;

HostCache::HostCache()
{
}

struct in_addr* HostCache::addr( const char* hostname )
{
    struct in_addr* a;
    if ( ( a = _addrs.find( hostname ) ) ) {
        return a;
    }

    struct hostent* remote = gethostbyname( hostname );
    if ( !remote ) {
        QString error;
        error.sprintf( "Cannot find address for host '%s'.\nh_errno = %d.", hostname, h_errno );
        QMessageBox::message( "QWeb: Error", error );
        return 0;
    }

    // Create the remote address.
    a = new in_addr;
    bcopy( remote->h_addr_list[0], a, sizeof( struct in_addr ) );

    _addrs.insert( hostname, a );

    return a;
}
