// QWeb - An SGML Web Browser
// Copyright (C) 1997  Sean Vyain
// svyain@mail.tds.net
// smvyain@softart.com
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#include <qlined.h>
#include "Canvas.h"
#include "EntryRenderer.h"
#include "FormRenderer.h"

EntryRenderer::EntryRenderer( int            maxLength,
                              int            size,
                              bool           password,
                              const QString* value,
                              Canvas*        canvas,
                              int            clipWidth,
                              QObject*       parent,
                              const char*    name )
        : FormObjectRenderer( canvas, clipWidth, parent, name )
{
    if ( value ) {
        _value = value->copy();
    }
    
    _entry = new QLineEdit( canvas->clip() );
    canvas->registerWidget( this, _entry );

    if ( maxLength > -1 ) {
        _entry->setMaxLength( maxLength );
    }

    int w;
    if ( size <= 0 ) {
        size = 20;
    }

    w = size * ( _entry->fontMetrics().width( '0' ) + 1 ) + 4;
    _entry->resize( w, 24 );

    if ( password ) {
        _entry->setEchoMode( QLineEdit::Password );
    }
    
    _entry->setText( _value );

    _minimumWidth = w + 8;
    _maximumWidth = w + 8;

    resize( w + 8, 32 );

    connect( _entry, SIGNAL( returnPressed() ), this, SLOT( submit() ) );
}

QString EntryRenderer::value()
{
    QString nm  = name();
    QString val = _entry->text();

    if ( ( nm.length() == 0 ) || ( val.length() == 0 ) ) {
        return "";
    }

    Url::encode( nm );
    Url::encode( val );

    QString tmp;
    tmp.sprintf( "%s=%s", nm.data(), val.data() );
    return tmp;
}

void EntryRenderer::reset()
{
    _entry->setText( _value );
}

bool EntryRenderer::redraw()
{
    return FALSE;
}

void EntryRenderer::endOfData()
{
}

void EntryRenderer::submit()
{
    FormRenderer* f;
    if ( ( f = form() ) ) {
        f->submit( this );
    }
}
