/*****************************************************************************

			       XCopilot

This code is part of XCopilot, a port of copilot

     Portions of this code are Copyright (C) 1997 Ivan A. Curtis
		       icurtis@radlogic.com.au

The original MS-Windows95 copilot emulator was written by Greg Hewgill.
The following copyright notice appeared on the original copilot sources:

		  Copyright (c) 1996 Greg Hewgill

 MC68000 Emulation code is from Bernd Schmidt's Unix Amiga Emulator.
       The following copyright notice appeared in those files:

	  Original UAE code Copyright (c) 1995 Bernd Schmidt

This code must not be distributed without these copyright notices intact.

*******************************************************************************
*******************************************************************************

Filename:	shared.h

Description:	definition of shared image structure

Update History:   (most recent first)
   Ian Goldberg 25-Sep-97 11:09 -- rewrite of serial and gdb support
   Ian Goldberg 11-Sep-97 09:48 -- added bus error support
   Ian Goldberg 20-Jun-97 14:09 -- added support for greyscale and panning
   Ian Goldberg 10-Apr-97 14:53 -- added entries for logging, sound
   I. Curtis    26-Feb-97 15:02 -- created

******************************************************************************/

#ifndef SHARED_H_INCLUDED
#define SHARED_H_INCLUDED

#include <sysdeps.h>
#include <stdio.h>

/*******************
  union flagu {
  struct {
*/
  /* v must be at the start so that the x86 seto instruction
   * changes the V flag. C must follow after V.
   */
/*
  char v;
char c;
char n;
char z;
} flags;
ULONG longflags;
};
*********************/

  typedef char flagtype; 
  
  struct regstruct {
    ULONG d[8];
    CPTR  a[8],usp;
    UWORD sr;
    flagtype t;
    flagtype s;
    flagtype x;
    flagtype v;
    flagtype c;
    flagtype n;
    flagtype z;
    flagtype stopped;
    int intmask;
    ULONG pc;
    UWORD *pc_p;
    UWORD *pc_oldp;
};

#define FIFO_SIZE 512

struct fifo {
    unsigned char fifo[FIFO_SIZE];
    int head, tail;
};

typedef struct {
  int		CpuState;
  int		CpuReq;

  /*
   * X Input devices (display_thread)
   */
  int pen, pendown, penx, peny;	/* modified by lcd process */
  int key, keydown;		/* modified by lcd process */
  int kbin, kbout;		/* ring-buffer for X11 keyboard */
  char kb[8];			/* ASCII data from X11 keyboard */

  /*
   * X Output devices (display_proc)
   */
  int		Backlight;
  int		LcdReq;
  int		LcdPower;
  unsigned char	grpalette[4];   /* Greyscale palette */
  ULONG		BellFreq;
  UWORD		BellDur;
  UWORD		BellAmp;

  /* (serial_proc) */
  struct fifo	gdb;		/* Input FIFOs from gdb */
  int		gdb_writefd;	/* fd to use to write data to gdb */

  struct fifo	serial;		/* Input FIFOs from the serial port */
  int		serial_writefd;	/* fd to use to write data to serial port */
  int		serial_baud;
  int		serial_flags;

  FILE		*logF;		/* If non-NULL, log to this file */
  int		dolog;		/* Control signal to turn logging on/off */

  /* need to catagorize */
  unsigned long	lssa;		/* shadows dragonball LSSA register */
  unsigned char	PICF;           /* shadows PICF register */
  unsigned char	VPW;		/* shadows VPW register */
  unsigned char	POSR;		/* shadows POSR register */
  int		scrnstart;	/* modified by write to LSSA */
  int		run_updateisr;	/* if TRUE, must update isr */
  int		quit;		/* if TRUE, must quit emulation */
  struct regstruct regs;	/* the CPU registers state */
  int		ExceptionFlags[48];
  int		ErrNo;
  int		allowromwrites;
} shared_img;

/*
 * Cpu States
 */
#define cpuInitial    0
#define cpuLoaded     1
#define cpuRunning    2
#define cpuStopped    3
#define cpuBreakpoint 4
#define cpuException  5

/*
 * Cpu Requests
 */
#define cpuNone    0
#define cpuReset   1
#define cpuStart   2
#define cpuStop    3
#define cpuLoadApp 4
#define cpuExit    5

/*
 * Lcd Requests
 */
#define lcdNone    0
#define lcdBell    1

/*
 * LcdPower
 */
#define lcdOn      1
#define lcdOff     0

#endif
