//
// Many parts of this source code were 'inspired' by the ircII4.4 translat.c source.
// RIPPED FROM KVirc: http://www.kvirc.org
// Original by Szymon Stefanek (kvirc@tin.it).
// Modified by Andrew Frolov (dron@linuxer.net)

// KDE Ready! - Look for comments if you want to add full KDE support on MessageBoxes.

#include "translate.h"
#include <qmessagebox.h>

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

//============ LicqTranslator ============//

LicqTranslator::LicqTranslator()
{
	setDefaultTranslationMap();
	m_szMapFileName="";
}

//============ ~LicqTranslator ============//

LicqTranslator::~LicqTranslator()
{
}

//============ setDefaultTranslationMap ============//

void LicqTranslator::setDefaultTranslationMap()
{
	for(int i=0;i<256;i++){
		serverToClientTab[i]=i;
		clientToServerTab[i]=i;
	}
	m_bDefault=true;
	m_szMapFileName="";
}

//============ setTranslationMap ============//

bool LicqTranslator::setTranslationMap(const char *szMapFileName)
{
	QFile mapFile(szMapFileName);
	QString szM=szMapFileName;
	if(szM.find("LATIN_1") != -1){
		setDefaultTranslationMap();
		return true;
	}
	if(!(mapFile.exists() && mapFile.open(IO_ReadOnly)) ){
#ifdef USE_KDE
		KMsgBox::message(0,"Translation","Could not open the translation file for reading.",KMsgBox::EXCLAMATION,"OK");
#else
                QMessageBox::critical(0, "Licq", "Could not open the translation file for reading.", QMessageBox::Ok, 0);
#endif
		setDefaultTranslationMap();
		return false;
	}

	// translat.c :
	// Any problems in the translation tables between hosts are
	// almost certain to be caused here.
	// many scanf implementations do not work as defined. In particular,
	// scanf should ignore white space including new lines (many stop
	// at the new line character, hence the fgets and sscanf workaround),
	// many fail to read 0xab as a hexadecimal number (failing on the
	// x) despite the 0x being defined as optionally existing on input,
	// and others zero out all the output variables if there is trailing
	// non white space in the format string which doesn't appear on the
	// input. Overall, the standard I/O libraries have a tendancy not
	// to be very standard.

	char buffer[80];
	int inputs[8];
	unsigned char temp_table[512];
	int c=0;

	while((mapFile.readLine(buffer,80)>0)&&(c<512)){
		if(
				sscanf(buffer, "0x%x,0x%x,0x%x,0x%x,0x%x,0x%x,0x%x,0x%x",
		    		inputs+0, inputs+1, inputs+2, inputs+3,
		    		inputs+4, inputs+5, inputs+6, inputs+7)   <8
		) {
#ifdef USE_KDE
			KMsgBox::message(0,"Translation","Syntax error in translation file.",KMsgBox::EXCLAMATION,"OK");
#else			
                        QMessageBox::critical(0, "Licq", "Syntax error in translation file.", QMessageBox::Ok, 0);
#endif			
                        setDefaultTranslationMap();
			mapFile.close();
			return false;
		}
		for (int j = 0; j<8; j++)temp_table[c++] = (unsigned char) inputs[j];
	}

	mapFile.close();

	if(c==512){
		for (c = 0; c < 256; c++)
		{
			serverToClientTab[c] = temp_table[c];
			clientToServerTab[c] = temp_table[c | 256];
		}
	} else {
#ifdef USE_KDE
		KMsgBox::message(0,"Translation","Translation file corrupted.",KMsgBox::EXCLAMATION,"OK");
#else
		QMessageBox::critical(0, "Licq", "Translation file corrupted.", QMessageBox::Ok, 0);
#endif
		setDefaultTranslationMap();
		return false;
	}
	m_bDefault=false;
	m_szMapFileName=szMapFileName;
	return true;
}

//============ translateToClient ============//

void LicqTranslator::translateToClient(char *szString)
{
	if(m_bDefault)return;
	char *pC=szString;
//	printf("Translating string %s\n",pC);
	while(*pC){
//		printf("Char %c (%d) becomes %c (%d)\n",*pC,(unsigned char)(*pC),serverToClientTab[(*pC)],serverToClientTab[(*pC)]);
		(*pC)=serverToClientTab[(unsigned char)(*pC)];
		pC++;
	}
}


//============ translateToServer ============//

void LicqTranslator::translateToServer(char *szString)
{
	if(m_bDefault)return;
	char *pC=szString;
//	printf("Translating string %s\n",pC);
	while(*pC){
//		printf("Char %c (%d) becomes %c (%d)\n",*pC,(unsigned char)(*pC),clientToServerTab[(*pC)],clientToServerTab[(*pC)]);
		(*pC)=clientToServerTab[(unsigned char)(*pC)];
		pC++;
	}
}
