#include <string.h>
#include <stdio.h>

#include "message.h"
#include "icq-defines.h"

//-----Message::constructor------------------------------------------------------------------------
Message::Message(const char *m, unsigned short theCmd, unsigned short theSubCmd, unsigned long theSequence, time_t t = 0, bool isLicq = false, unsigned short theVer = 0)
{
   // set the message
   msgVal = new char[strlen(m) + 1];
   strcpy(msgVal, m);
      
   // set the time received: "Mon Apr 27 20:49:08 1998\n"
   if (t == 0) t = time(NULL);
   sprintf(timeRecVal, "%s", ctime(&t));
   
   // move the year over to where the seconds used to be (don't need seconds)
   for (int i = 16; i < 21; i++) timeRecVal[i] = timeRecVal[i + 3];
   timeRecVal[21] = '\0';
   
   cmdVal = theCmd;
   subCmdVal = theSubCmd;
   sequenceVal = theSequence;
   licqSentVal = isLicq;
   licqVerVal = theVer;
   
   setCmdStr();
}


Message::Message(const char *m, time_t t = 0, bool isLicq = false, unsigned short theVer = 0)
{
   // set the message
   msgVal = new char[strlen(m) + 1];
   strcpy(msgVal, m);

   // set the time received: "Mon Apr 27 20:49:08 1998\n"
   if (t == 0) t = time(NULL);
   sprintf(timeRecVal, "%s", ctime(&t));
   
   // move the year over to where the seconds used to be (don't need seconds)
   for (int i = 16; i < 21; i++) timeRecVal[i] = timeRecVal[i + 3];
   timeRecVal[21] = '\0';
   
   cmdVal = ICQ_CMDxTCP_START;
   subCmdVal = ICQ_CMDxTCP_MSG;
   sequenceVal = 0;
   licqSentVal = isLicq;
   licqVerVal = theVer;

   setCmdStr();
}

Message::Message(Message *m)
{
   // set the message
   msgVal = new char[strlen(m->msgVal) + 1];
   strcpy(msgVal, m->msgVal);
   strcpy(timeRecVal, m->timeRecVal);

   cmdVal = m->cmdVal;
   subCmdVal = m->subCmdVal;
   sequenceVal = m->sequenceVal;
   licqSentVal = m->licqSentVal;
   licqVerVal = m->licqVerVal;

   setCmdStr();
}


void Message::setCmdStr(void)
{
   switch (cmdVal) 
   {
   case ICQ_CMDxTCP_START:
      switch (subCmdVal) 
      {
      case ICQ_CMDxTCP_MSG: strcpy(cmdStrVal, "Message"); break;
      case ICQ_CMDxTCP_URL: strcpy(cmdStrVal, "URL"); break;
      case ICQ_CMDxTCP_CHAT: strcpy(cmdStrVal, "Chat request"); break;
      case ICQ_CMDxTCP_FILE: strcpy(cmdStrVal, "File transfer"); break;
      default: strcpy(cmdStrVal, "Something is messed up"); break;
      }
      if (cmdVal == ICQ_CMDxTCP_CANCEL) 
      {
         sprintf(cmdStrVal, "%s cancelled", cmdStrVal);
      }
      directEventVal = true;
      break;
   case ICQ_CMDxRCV_SYSxMSGxONLINE:
      switch (subCmdVal) 
      {
      case ICQ_CMDxTCP_MSG: strcpy(cmdStrVal, "Message"); break;
      case ICQ_CMDxTCP_URL: strcpy(cmdStrVal, "URL"); break;
      case ICQ_CMDxTCP_CHAT: strcpy(cmdStrVal, "Chat request"); break;
      case ICQ_CMDxTCP_FILE: strcpy(cmdStrVal, "File transfer"); break;
      case ICQ_CMDxRCV_SMxADDED: strcpy(cmdStrVal, "Added to contact list"); break;
      case ICQ_CMDxRCV_SMxREQxAUTH: strcpy(cmdStrVal, "Authorization request"); break;
      default: strcpy(cmdStrVal, "Something is messed up"); break;
      }
      directEventVal = false;
      break;
   default:
      strcpy(cmdStrVal, "Something is very messed up");
      break;
   }
}


char *Message::licqVerStr(void)
{
   static char verStr[8];
   sprintf(verStr, "v0.%d", licqVerVal);
   return (verStr);
}


Message::~Message(void)           { delete (msgVal); }
char *Message::msg(void)         { return (msgVal); }
char *Message::timeRec(void)      { return (timeRecVal); }
unsigned short Message::cmd(void)  { return (cmdVal); }
unsigned short Message::subCmd(void)  { return (subCmdVal); }
char *Message::cmdStr(void)      { return (cmdStrVal); }
unsigned long Message::sequence(void)   { return (sequenceVal); }
bool Message::directEvent(void)   { return (directEventVal); }
bool Message::licqSent(void)     { return (licqSentVal); }
unsigned short Message::licqVer(void)  { return (licqVerVal); }





