#ifndef CHATDLG_H
#define CHATDLG_H

#include <qpushbutton.h>
#include <qgroupbox.h>

#include "mledit.h"
#include "user.h"
#include "socket.h"
#include "icq-defines.h"


class ChatDlg : public QWidget
{
   Q_OBJECT
public:
   ChatDlg(ICQUser *u, ICQUser *o, bool isTheServer, unsigned short thePort = 0, QWidget *parent = NULL, char *name = NULL);
   virtual ~ChatDlg(void);
   
   MLEditWrap *mleLocal, *mleRemote;
   QGroupBox *boxLocal, *boxRemote;
   QPushButton *btnClose;

   unsigned short port(void);

public slots:
   virtual void hide();

protected:
   void resizeEvent (QResizeEvent *);

   ICQUser *user, *owner;
   Packet chatPacket;
   TCPSocket chatSock, chatSockServer;
   unsigned short portVal;
   bool isServer;
   char *remoteName, *localName;
   
protected slots:
   void chatRecv();
   void chatRecvServer();
   void chatRecvHandshake();
   void chatClose();
   void chatSend(QKeyEvent *);

};

#endif



