/*--------------------------------*-C-*---------------------------------*
 * File:	sbar.c
 *
 * Copyright 1992 John Bovey, University of Kent at Canterbury.
 *
 * You can do what you like with this source code as long as you don't
 * try to make money out of it and you include an unaltered copy of this
 * message (including the copyright).
 *
 * This module has been heavily modified by R. Nation
 * (nation@rocket.sanders.lockheed.com).
 * No additional restrictions are applied
 *
 * Extensive modifications by mj olesen <olesen@me.QueensU.CA>
 * No additional restrictions are applied.
 *
 * As usual, the author accepts no responsibility for anything, nor does
 * he guarantee anything whatsoever.
 *----------------------------------------------------------------------*/
#include "main.h"
#include "sbar.h"

/*----------------------------------------------------------------------*
 * extern functions referenced
 */
/*----------------------------------------------------------------------*
 * extern variables referenced
 */
/*----------------------------------------------------------------------*
 * extern variables declared here
 */
sBar_t sBar;

/*----------------------------------------------------------------------*
 * local variables
 */
# ifdef XTERM_SCROLLBAR		/* bitmap scrollbar */
static GC sbarGC;

#  define sb_width 12
#  define sb_height 2
static char sb_bits[] = {
   0x55, 0x05, 0xaa, 0x0a};

#  if (SB_WIDTH != sb_width)
Error, check scrollbar width
#  endif
# else
static GC topShadowGC, bottomShadowGC;
#  ifndef SCROLLBAR_BGFILL
static GC sbarGC;
#  endif	/* SCROLLBAR_BGFILL */
# endif	/* ! XTERM_SCROLLBAR */

/*----------------------------------------------------------------------*
 * local functions referenced
 */

/*----------------------------------------------------------------------*/

/*
 * Initialize scrollbar data structures - called just once.
 *
 * The calculations of topShadow/bottomShadow values are adapted from the
 * fvwm window manager.
 */
void
sbar_init (void)
{
   XGCValues gcvalue;
# ifdef XTERM_SCROLLBAR
   gcvalue.stipple = XCreateBitmapFromData (Xdisplay, sBar.win,
					    sb_bits, sb_width, sb_height);
   if (!gcvalue.stipple)
     {
	print_error ("can't create bitmap");
	exit (EXIT_FAILURE);
     }

   gcvalue.fill_style = FillOpaqueStippled;
   gcvalue.foreground = PixColors [fgColor];
   gcvalue.background = PixColors [bgColor];

   sbarGC = XCreateGC (Xdisplay, sBar.parent,
		       GCForeground|GCBackground|GCFillStyle|GCStipple,
		       &gcvalue);
# else	/* XTERM_SCROLLBAR */
   XColor xcol;

   if (!(Options & Opt_scrollBar))
     return;

   if (Xdepth <= 2)		/* Monochrome */
     PixColors [scrollColor] = PixColors [fgColor];

   /* find bottomShadowColor from scrollColor */
   if (Xdepth <= 2)		/* Monochrome */
     {
	xcol.pixel = PixColors [fgColor];
     }
   else
     {
	xcol.pixel = PixColors [scrollColor];
	XQueryColor (Xdisplay, Xcmap, &xcol);

	xcol.red   = ((xcol.red)   / 2);
	xcol.green = ((xcol.green) / 2);
	xcol.blue  = ((xcol.blue)  / 2);

	if (!XAllocColor (Xdisplay, Xcmap, &xcol))
	  {
	     print_error ("can't allocate %s", "bottomShadowColor");
	     xcol.pixel = PixColors [minColor];
	  }
     }
   gcvalue.foreground = xcol.pixel;
   bottomShadowGC = XCreateGC (Xdisplay, sBar.parent,
			       GCForeground,
			       &gcvalue);

   /* find topShadow color from scrollColor */
   if (Xdepth <= 2)		/* Monochrome */
     {
	xcol.pixel = PixColors [fgColor];
     }
   else				/* Full colour? */
     {
	XColor white;

	white.pixel = WhitePixel (Xdisplay, Xscreen);
	XQueryColor (Xdisplay, Xcmap, &white);

	xcol.pixel = PixColors [scrollColor];
	XQueryColor (Xdisplay, Xcmap, &xcol);

#  ifndef min
#   define min(a,b) (((a)<(b)) ? (a) : (b))
#   define max(a,b) (((a)>(b)) ? (a) : (b))
#  endif
	xcol.red   = max ((white.red   / 5), xcol.red);
	xcol.green = max ((white.green / 5), xcol.green);
	xcol.blue  = max ((white.blue  / 5), xcol.blue);

	xcol.red   = min (white.red,   (xcol.red   * 7) / 5);
	xcol.green = min (white.green, (xcol.green * 7) / 5);
	xcol.blue  = min (white.blue,  (xcol.blue  * 7) / 5);

	if (!XAllocColor (Xdisplay, Xcmap, &xcol))
	  {
	     print_error ("can't allocate %s", "topShadowColor");
	     xcol.pixel = PixColors [whiteColor];
	  }
     }
   gcvalue.foreground = xcol.pixel;
   topShadowGC = XCreateGC (Xdisplay, sBar.parent,
			    GCForeground,
			    &gcvalue);

#  ifndef SCROLLBAR_BGFILL
   gcvalue.foreground = PixColors [scrollColor];
   sbarGC = XCreateGC (Xdisplay, sBar.parent,
		       GCForeground,
		       &gcvalue);
#  else
   XSetWindowBackground (Xdisplay, sBar.win, PixColors [scrollColor]);
#  endif
# endif	/* XTERM_SCROLLBAR */

   sbar_show (1);
}

# ifndef XTERM_SCROLLBAR
/*
 * draw bottomShadow/highlight along top/left sides of the window
 */
static void
Draw_tl (Window win, GC gc, int x, int y, int w, int h)
{
   int i;

   w += (x - 1);
   h += (y - 1);

   for (i = 0; i < SB_SHADOW; i++, x++, y++, w--, h--)
     {
	XDrawLine (Xdisplay, win, gc, x, y, w, y);
	XDrawLine (Xdisplay, win, gc, x, y, x, h);
     }
}

/*
 * draw bottomShadow/highlight along the bottom/right sides of the window
 */
static void
Draw_br (Window win, GC gc, int x, int y, int w, int h)
{
   int i;

   w += (x - 1);
   h += (y - 1);

   x++; y++;
   for (i = 0; i < SB_SHADOW; i++, x++, y++, w--, h--)
     {
	XDrawLine (Xdisplay, win, gc, w, h, w, y);
	XDrawLine (Xdisplay, win, gc, w, h, x, h);
     }
}

/* draw triangular up button with a shadow of 2 pixels */
static void
Draw_up_button (Window win, int x, int y, unsigned int size)
{
   XSegment seg [4];
   int n;

#  ifndef SCROLLBAR_BGFILL
   XPoint pt [4];
   n = 0;

   pt[n].x = x;			pt[n].y = y + size - 1;
   n++;
   pt[n].x = x + size - 1;	pt[n].y = y + size - 1;
   n++;
   pt[n].x = x + size/2;	pt[n].y = y;
   n++;
   pt[n].x = x;			pt[n].y = y + size - 1;
   n++;

   XFillPolygon (Xdisplay, win, sbarGC, pt, n, Convex, CoordModeOrigin);
#  endif

   n = 0;
   seg[n].x1 = x + size/2;	seg[n].y1 = y;
   seg[n].x2 = x;		seg[n].y2 = y + size - 1;
   n++;

   seg[n].x1 = x + size/2;	seg[n].y1 = y + 1;
   seg[n].x2 = x + 1;		seg[n].y2 = y + size - 2;
   n++;

   XDrawSegments (Xdisplay, win,
		  (sbar_isUp () ? bottomShadowGC : topShadowGC),
		  seg, n);

   n = 0;
   seg[n].x1 = x + size/2 + 1;	seg[n].y1 = y + 1;
   seg[n].x2 = x + size - 1;	seg[n].y2 = y + size - 2;
   n++;

   seg[n].x1 = x + size/2 + 1;	seg[n].y1 = y + 2;
   seg[n].x2 = x + size - 2;	seg[n].y2 = y + size - 3;
   n++;

   seg[n].x1 = x + 1;		seg[n].y1 = y + size - 1;
   seg[n].x2 = x + size - 1;	seg[n].y2 = y + size - 1;
   n++;

   seg[n].x1 = x + 2;		seg[n].y1 = y + size - 2;
   seg[n].x2 = x + size - 1;	seg[n].y2 = y + size - 2;
   n++;

   XDrawSegments (Xdisplay, win,
		  (sbar_isUp () ? topShadowGC : bottomShadowGC),
		  seg, n);
}

/* draw triangular down button with a shadow of 2 pixels */
static void
Draw_dn_button (Window win, int x, int y, unsigned int size)
{
   XSegment seg [4];
   int n;

#  ifndef SCROLLBAR_BGFILL
   XPoint pt [4];
   n = 0;

   pt[n].x = x;			pt[n].y = y;
   n++;
   pt[n].x = x + size - 1;	pt[n].y = y;
   n++;
   pt[n].x = x + size/2;	pt[n].y = y + size - 1;
   n++;
   pt[n].x = x;			pt[n].y = y;
   n++;

   XFillPolygon (Xdisplay, win, sbarGC, pt, n, Convex, CoordModeOrigin);
#  endif

   n = 0;
   seg[n].x1 = x;		seg[n].y1 = y;
   seg[n].x2 = x + size/2 - 1;	seg[n].y2 = y + size - 2;
   n++;

   seg[n].x1 = x + 1;		seg[n].y1 = y + 1;
   seg[n].x2 = x + size/2 - 1;	seg[n].y2 = y + size - 3;
   n++;

   seg[n].x1 = x;		seg[n].y1 = y;
   seg[n].x2 = x + size - 2;	seg[n].y2 = y;
   n++;

   seg[n].x1 = x;		seg[n].y1 = y + 1;
   seg[n].x2 = x + size - 3;	seg[n].y2 = y + 1;
   n++;

   XDrawSegments (Xdisplay, win,
		  (sbar_isDn () ? bottomShadowGC : topShadowGC),
		  seg, n);

   n = 0;
   seg[n].x1 = x + size - 1;	seg[n].y1 = y;
   seg[n].x2 = x + size/2;	seg[n].y2 = y + size - 1;
   n++;

   seg[n].x1 = x + size - 2;	seg[n].y1 = y + 1;
   seg[n].x2 = x + size/2;	seg[n].y2 = y + size - 2;
   n++;

   XDrawSegments (Xdisplay, win,
		  (sbar_isDn () ? topShadowGC : bottomShadowGC),
		  seg, n);
}
# endif	/* XTERM_SCROLLBAR */

/*
 * Redraw scrollbar
 */
int
sbar_show (int update)
{
   /* old (drawn) values */
   static int last_top, last_bot, last_len;
   static int sBar_len;		/* length of slider */

   if (update)
     {
	int top, bot, len;
	top = (TermWin.hist_count - TermWin.hist_start);
	bot = top + (TermWin.nrow-1);
	len = (TermWin.hist_count + (TermWin.nrow-1));

	sBar.top = (top * (sBar.end - sBar.beg)) / len + sBar.beg;
	sBar.bot = (bot * (sBar.end - sBar.beg)) / len + sBar.beg;

	if (sBar.top < sBar.beg) sBar.top = sBar.beg;
	if (sBar.bot > sBar.end) sBar.top = sBar.end;
	sBar_len = (sBar.bot - sBar.top);
     }

   if (!(Options & Opt_scrollBar) ||
       (update &&
	(sBar.top == last_top) &&
	(sBar.bot == last_bot) &&
	(sBar_len == last_len)))
     return 0;			/* no change */

   last_top = sBar.top;
   last_bot = sBar.bot;
   last_len = sBar_len;

   XClearWindow (Xdisplay, sBar.win);

# ifdef XTERM_SCROLLBAR
   XFillRectangle (Xdisplay, sBar.win, sbarGC,
		   0, sBar.top, SB_WIDTH, sBar_len);
# else	/* XTERM_SCROLLBAR */

#  define Draw_shadow(win,tlGC,brGC,x,y,w,h)  do {\
Draw_tl (win, tlGC, x, y, w, h);\
Draw_br (win, brGC, x, y, w, h);\
} while (0)

#  ifdef SCROLLBAR_BGFILL
   /* shadow for entire scrollbar */
   Draw_shadow (sBar.parent, bottomShadowGC, topShadowGC,
		0, 0, (SB_WIDTH + 2 * SB_SHADOW),
		((sBar.beg + sBar.end) + 2 * SB_SHADOW));
#  else
   /* scrollbar slider */
   XFillRectangle (Xdisplay, sBar.win, sbarGC,
		   0, sBar.top, SB_WIDTH, sBar_len);
#  endif	/* SCROLLBAR_BGFILL */

   /* shadow for scrollbar slider */
   Draw_shadow (sBar.win,
		topShadowGC, bottomShadowGC,
		0, sBar.top, SB_WIDTH, sBar_len);

   /*
    * Redraw scrollbar arrows
    */
   Draw_up_button (sBar.win, 1, 1, SB_WIDTH - 2);
   Draw_dn_button (sBar.win, 1, sBar.end + 1, SB_WIDTH - 2);
# endif	/* XTERM_SCROLLBAR */
   return 1;
}
/*----------------------- end-of-file (C source) -----------------------*/
