/*
**
** dialog.c
**
** Copyright (C) 1995, 1996 Johannes Plass
** 
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
** 
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
** 
** Author:   Johannes Plass (plass@dipmza.physik.uni-mainz.de)
**           Department of Physic
**           Johannes Gutenberg-University
**           Mainz, Germany
**
*/

#include "config.h"

#include <stdio.h>

/*
#define MESSAGES
*/
#include "message.h"

#include "paths.h"
#include INC_X11(Intrinsic.h)
#include INC_X11(StringDefs.h)
#include INC_X11(Xos.h)
#include INC_XAW(AsciiText.h)
#include INC_XAW(Command.h)
#include INC_XAW(Label.h)
#include INC_X11(Shell.h)
#include "Aaa.h"
#include "Ghostview.h"

#include "main_resources.h"
#include "main_globals.h"
#include "popup_misc.h"
#include "widgets_misc.h"

#ifndef max
#   define max(a, b)    ((a) > (b) ? (a) : (b))
#endif

/*### Application dependencies ##############################################*/

#define DIALOG_TOPLEVEL		toplevel
#define DIALOG_POPUP_NAME	"dialogPopup"
#define DIALOG_POPUP		dialogpopup

#include "gv.h"
#include "note.h"
#include "dialog.h"

static Bool dialogPopupCreated = False;
static Bool dialogPopupVisible = False;
static Widget doneButton=NULL,cancelButton=NULL,dialogText=NULL;
static int preferedButton=0;

/*###############################################################################
   cb_popdownDialogPopup
###############################################################################*/

void cb_popdownDialogPopup(w, client_data, call_data)
   Widget	w;
   XtPointer	client_data, call_data;  
{
   BEGINMESSAGE(cb_popdownDialogPopup)
   if (dialogPopupVisible) {
      cb_popdownNotePopup((Widget)NULL,(XtPointer)NULL,NULL);
      XtPopdown(DIALOG_POPUP);
      dialogPopupVisible=False;
   }
   ENDMESSAGE(cb_popdownDialogPopup)
}

/*###############################################################################
   cb_popupDialogPopup
###############################################################################*/

void cb_popupDialogPopup(w, client_data, call_data)
   Widget	w;
   XtPointer	client_data, call_data;  
{
   BEGINMESSAGE(cb_popupDialogPopup)
   if (!dialogPopupVisible) {
      if (!dialogPopupCreated) makeDialogPopup();
      preferedButton=DIALOG_BUTTON_CANCEL;
      action_preferDialogPopupButton(NULL, NULL, NULL, NULL);
      popup_positionPopup(DIALOG_POPUP,fileButton,POPUP_POSITION_POS,85,25);
      XtPopup(DIALOG_POPUP,XtGrabNone);
      dialogPopupVisible=True;
   }
   ENDMESSAGE(cb_popupDialogPopup)
}

/*###############################################################################
   action_preferDialogPopupButton
###############################################################################*/

void 
action_preferDialogPopupButton(w, event, params, num_params)
   Widget w;
   XEvent *event;
   String *params;
   Cardinal *num_params;
{
   Widget pref,pref_old;

   BEGINMESSAGE(action_preferDialogPopupButton)
   if (preferedButton==DIALOG_BUTTON_DONE) {
      pref=cancelButton;
      pref_old=doneButton;
      preferedButton=DIALOG_BUTTON_CANCEL;
   } else {
      pref=doneButton;
      pref_old=cancelButton;
      preferedButton=DIALOG_BUTTON_DONE;
   }
   widgets_preferButton(pref,1);
   widgets_preferButton(pref_old,0);
   XtInstallAccelerators(dialogText,pref);
   ENDMESSAGE(action_preferDialogPopupButton)
}

/*###############################################################################
   makeDialogPopup
###############################################################################*/

static char *tabTrans =
"\
<Key>Tab: GV_TogDialPrefBut()\
";

void makeDialogPopup()
{
   Arg          args[7];
   Cardinal     n;
   Dimension	minw,minh;
   Widget   dialogAaa;
   static XtTranslations tab_trans=(XtTranslations)NULL;

   BEGINMESSAGE(makeDialogPopup)

					n=0;
        XtSetArg(args[n], XtNallowShellResize, True);  n++;
   DIALOG_POPUP = XtCreatePopupShell(DIALOG_POPUP_NAME,transientShellWidgetClass,DIALOG_TOPLEVEL, args, n);

					n=0;
        XtSetArg(args[n], XtNresizeWidth, True);	n++;
        XtSetArg(args[n], XtNresizeHeight, True);	n++;
        XtSetArg(args[n], XtNconditionedResize, False);	n++;
        XtSetArg(args[n], XtNmaximumWidth, 0);	 	n++;
        XtSetArg(args[n], XtNmaximumHeight,0);	 	n++;
   dialogAaa = XtCreateManagedWidget("dialogAaa",aaaWidgetClass,DIALOG_POPUP,args,n);
 
        				n=0;
   XtCreateManagedWidget("message", labelWidgetClass,dialogAaa, args, n);

        				n=0;
   doneButton=XtCreateManagedWidget("done",commandWidgetClass,dialogAaa,args,n);
   cancelButton=XtCreateManagedWidget("cancel",commandWidgetClass,dialogAaa,args,n);
 
   dialogText=widgets_createLabeledTextField("dialog_text", dialogAaa);

   XtRealizeWidget(DIALOG_POPUP);

   AaaWidgetGetNaturalSize((AaaWidget)dialogAaa,&minw,&minh);
   IMESSAGE(minw) IMESSAGE(minh)

                                          n=0;
   XtSetArg(args[n], XtNminWidth, minw);  ++n;
   XtSetArg(args[n], XtNminHeight, minh); ++n;
   XtSetArg(args[n], XtNmaxWidth, XtUnspecifiedShellInt);  ++n;
   XtSetArg(args[n], XtNmaxHeight, minh); ++n;
   XtSetValues(DIALOG_POPUP, args, n);

   /*>>>*/
      XtSetKeyboardFocus(dialogAaa,dialogText);
					      n=0;
      XtSetArg(args[n],XtNdisplayCaret,True); n++;
      XtSetValues(dialogText, args, n);
      if (!tab_trans) tab_trans=XtParseTranslationTable(tabTrans);
      XtOverrideTranslations(dialogText,tab_trans);
   /*<<<*/


   XSetWMProtocols(XtDisplay(DIALOG_POPUP),XtWindow(DIALOG_POPUP),&wm_delete_window,1);
   dialogPopupCreated=True;
                              
   ENDMESSAGE(makeDialogPopup)
}

/*###############################################################################
    DialogPopupSetButton
###############################################################################*/

void DialogPopupSetButton(button,label,callback)
 int button;
 String label;
 XtCallbackProc callback;
 {
    Arg args[5];
    Cardinal n;
    Widget response=NULL;

    BEGINMESSAGE(DialogPopupSetButton)
    if (!dialogPopupCreated) makeDialogPopup();
    if       (button&DIALOG_BUTTON_DONE)   response = doneButton;
    else if  (button&DIALOG_BUTTON_CANCEL) response = cancelButton;

    if (response) {
       if (label) {
          n=0;
          XtSetArg(args[n], XtNlabel, label);  n++;
          XtSetValues(response, args, n);
       }
       if (callback) {
          XtRemoveAllCallbacks(response,XtNcallback);
          XtAddCallback(response, XtNcallback,callback,NULL);
       }
    }
    ENDMESSAGE(DialogPopupSetButton)
}

/*###############################################################################
    DialogPopupClearText
###############################################################################*/

void DialogPopupClearText()
 {
    Arg args[5];
    Cardinal n;
    Widget response;

    BEGINMESSAGE(DialogPopupClearText)
    if (!dialogPopupCreated) makeDialogPopup();
    response = XtNameToWidget(DIALOG_POPUP, "*dialog_text");
    n=0;
    XtSetArg(args[n], XtNstring, "");  n++;
    XtSetValues(response, args, n);
    ENDMESSAGE(DialogPopupClearText)
}

/*###############################################################################
    DialogPopupSetText
###############################################################################*/

void DialogPopupSetText(s)
    String s;
{
    Arg args[10];
    Cardinal n;
    Widget response;
    Dimension width;
#   define DIALOG_POPUP_FREE_SPACE 50
#   define DIALOG_POPUP_TEXT_MIN_WIDTH 100
    String os;
    Dimension lm,rm,bw,nw;
    XFontStruct *font;

    BEGINMESSAGE(DialogPopupSetText)
    if (!s) {INFMESSAGE(no text) ENDMESSAGE(DialogPopupSetText) return;}
    if (!dialogPopupCreated) makeDialogPopup();
    response = XtNameToWidget(DIALOG_POPUP, "*dialog_text");

    						n=0;
    XtSetArg(args[n], XtNfont, &font);		n++;
    XtSetArg(args[n], XtNleftMargin, &lm);	n++;
    XtSetArg(args[n], XtNrightMargin, &rm);	n++;
    XtSetArg(args[n], XtNborderWidth, &bw);	n++;
    XtSetArg(args[n], XtNstring, &os);		n++;
    XtSetArg(args[n], XtNwidth, &width);	n++;
    XtGetValues(response, args, n);
    if (!os) os="";
    if (strcmp(os,s)) {
    						n=0;
       nw= ((font->max_bounds.width+font->min_bounds.width)*((Dimension)strlen(s))+1)/2
	   +lm+rm+DIALOG_POPUP_FREE_SPACE+2*bw;
       if (nw<DIALOG_POPUP_TEXT_MIN_WIDTH) nw=DIALOG_POPUP_TEXT_MIN_WIDTH;
       if (nw>width) {
	  INFIMESSAGE(new width,nw)
	  XtSetArg(args[n], XtNwidth,nw);	n++;
       }
       XtSetArg(args[n], XtNstring, s);		n++;
       XtSetValues(response, args, n);
 
    }
    ENDMESSAGE(DialogPopupSetText)
}

/*###############################################################################
    DialogPopupGetText
###############################################################################*/
 
String DialogPopupGetText()
{
    Arg args[5];
    Cardinal n;
    Widget response;
    String s;
    static char string[256];
    int l;

    BEGINMESSAGE(DialogPopupGetText)
    if (!dialogPopupCreated) makeDialogPopup();
    response = XtNameToWidget(DIALOG_POPUP, "*dialog_text");
    n=0;
    XtSetArg(args[n], XtNstring, &s);   n++;
    XtGetValues(response, args, n);
    l= strlen(s);
    if (l<255) strcpy(string,s);
    else { strncpy(string,s,255); string[255]='\0'; }
    ENDMESSAGE(DialogPopupGetText)
    return string;
}

/*###############################################################################
    DialogPopupSetPrompt
###############################################################################*/

void DialogPopupSetPrompt(newprompt)
    String newprompt;
{
    Arg args[5];
    Cardinal n;
    Widget label;

    BEGINMESSAGE(DialogPopupSetPrompt)
    if (!dialogPopupCreated) makeDialogPopup();
    label = XtNameToWidget(DIALOG_POPUP, "*dialog_textLabel");
    n=0;
    XtSetArg(args[n], XtNlabel, newprompt); n++;
    XtSetValues(label, args, n);
    ENDMESSAGE(DialogPopupSetPrompt)
}

/*###############################################################################
    DialogPopupSetMessage
###############################################################################*/

void DialogPopupSetMessage(message)
    String message;
{
    Arg args[5];
    Cardinal n;
    Widget label;

    BEGINMESSAGE(DialogPopupSetMessage)
    if (!dialogPopupCreated) makeDialogPopup();
    label = XtNameToWidget(DIALOG_POPUP, "*message");
    n=0;
    XtSetArg(args[n], XtNlabel, message); n++;
    XtSetValues(label, args, n);
    ENDMESSAGE(DialogPopupSetMessage)
}
