#include "config.h"

#include <stdio.h>
#include <stdarg.h>
#include <sys/types.h>
#include <fcntl.h>
#include <unistd.h>
#include <malloc.h>
#include <string.h>
#include <sys/stat.h>
#include <stdlib.h>
#include <errno.h>

#include "McApp.h"
#include "McFileRequest.h"
#include "McInfoRequest.h"

#include "version.h"
#include "xg3.h"
#include "filegui.h"
#include "confirm.h"

/**************************************************************************/

typedef struct confirm_t {
  unsigned char *file;
  void (*callbackName)(unsigned char *);
  void (*callbackFile)(FILE *);
} confirm_t;

/**************************************************************************/

static void confirm_func(int yes, void *data);
static void do_callback(unsigned char *,
			void (callbackName)(unsigned char *),
			void (callbackFile)(FILE *));

/**************************************************************************/

void confirm_overwrite(unsigned char *file,
		       void (callbackName)(unsigned char *),
		       void (callbackFile)(FILE *)) {
  struct stat st;

  BeepAssert(old_request);

  if (!stat(file, &st)) {
    unsigned char buf[1000];
    confirm_t *confirm=malloc(sizeof(confirm_t));
    confirm->file=strdup(file);
    confirm->callbackName=callbackName;
    confirm->callbackFile=callbackFile;
    sprintf(buf, "Do you want to overwrite existing file\n`%s' ?\n", file);
    old_request=McCreateInfoRequest(app, "Confirmation", buf,
				    "Yes", NULL, "No", confirm_func);
    ((McInfoRequest *)old_request)->customData=confirm;
  } else {
    do_callback(file, callbackName, callbackFile);
  }
}

/**************************************************************************/

static void confirm_func(int yes, void *data) {
  confirm_t *confirm=(confirm_t *)data;
  old_request=NULL;
  if (yes>0)
    do_callback(confirm->file, confirm->callbackName, confirm->callbackFile);
  free(confirm->file);
  free(confirm);
}

/**************************************************************************/

static void do_callback(unsigned char *file,
			void (callbackName)(unsigned char *),
			void (callbackFile)(FILE *)) {
  if (callbackName) {
    (*callbackName)(file);
  } else if (callbackFile) {
    FILE *fp;
    fp=fopen(file, "w");
    if (!fp) {
      McError(app, "Cannot open `%s' for writing.\nReason: %s\n",
	      file, strerror(errno));
    } else {
      (*callbackFile)(fp);
      fclose(fp);
    }
  }
}

