/* Copyright (C) 1994 
            Olav Woelfelschneider (wosch@rbg.informatik.th-darmstadt.de)

 This library is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xatom.h>
#include <stdio.h>
#include <string.h>
#include "McAlloc.h"

#include "McApp.h"
#include "McText.h"

McText *McCreateText(McWindow *mcw, char *text, GC gc, XFontStruct *font, 
		     int x, int y) {

  McText *txt = (McText *) McAlloc(sizeof(McText));
  txt->x = x;
  txt->y = y;
  txt->text = NULL;
  txt->font = font;
  txt->next = NULL;
  McChangeText(mcw, txt, text, gc);
  return txt;
}

void McChangeText(McWindow *mcw, McText *txt, char *text, GC gc) {
  int		direction, ascent, descent;
  XCharStruct	overall;

  XTextExtents(txt->font, text, strlen(text), &direction, &ascent,
	       &descent, &overall);

  txt->width = overall.width;
  txt->height = ascent + descent;
  if (text) {
    if (txt->text)
      McFree(txt->text);
    txt->text = strdup(text);
  }
  if (gc) txt->gc = gc;
}

void McFreeText(McText *txt) {
  if (txt->text)
    McFree(txt->text);
  McFree(txt);
}

void McWriteText(McWindow *mcw, Window win, McText *txt, GC gc, int x, int y) {
  GC ggc;
  if (!win) win=mcw->window;
  while(txt) {
    if (gc) ggc=gc; else ggc=txt->gc;
    XSetFont(mcw->app->display, ggc, txt->font->fid);
    XDrawImageString(mcw->app->display, win, gc?gc:txt->gc,
		     txt->x+x, txt->y+y+txt->font->ascent,
		     txt->text,strlen(txt->text));
    txt=txt->next;
  }
}
