/* filename: rlprd.h
 * project: rlpr
 * author: meem  --  meem@sherilyn.wustl.edu
 * version: $Id: rlprd.h,v 1.2 1996/10/12 09:17:30 meem Exp $
 * content: general definitions/declarations for rlprd.c
 *
 * Time-stamp: <1996/10/12 03:02 -- meem@sherilyn.wustl.edu>
 */

#ifndef RLPRD_H
#define RLPRD_H

/* function prototypes */

struct daemon_options {
  u_short   port;		/* port number to listen on */
  int       timeout;		/* how long before giving up on a client */
  int       quiet:1;		/* quiet mode on */
  int       daemon:1;		/* user requested daemon */
  int       is_daemon:1;	/* currently is daemon == no ctty */
};

#define DEFAULT_TIMEOUT  20 	/* seconds */

static void daemon_init(void);
static void register_sigchld(void);
static void register_sigalrm(void);
static RETSIGTYPE reapchild(int unused);
static RETSIGTYPE sigalrm(int unused);
static const char * inc_host(struct sockaddr_in *sin);
static void parse_args(int argc, char *argv[]);
static void set_default_options(void);

#endif /* RLPRD_H */
