
/* Copyright (c) Mark J. Kilgard, 1994, 1996. */

/* This program is freely distributable without licensing fees 
   and is provided without guarantee or warrantee expressed or 
   implied. This program is -not- in the public domain. */

#ifdef __sgi
#include <malloc.h>
#endif
#include <stdlib.h>
#include <stdio.h>
#include <GL/glut.h>
#include <glutint.h>

int count = 0, save_count;
int start, end, diff;

void
idle(void)
{
  count++;
}

void
timer2(int value)
{
  if (value != 36)
    __glutFatalError("FAIL: timer value wrong");
  if (count != save_count)
    __glutFatalError("FAIL: counter still counting");
  printf("PASS: test2\n");
  exit(0);
}

void
timer(int value)
{
  if (value != 42)
    __glutFatalError("FAIL: timer value wrong");
  if (count <= 0)
    __glutFatalError("FAIL: idle func not running");
  glutIdleFunc(NULL);
  save_count = count;
  end = glutGet(GLUT_ELAPSED_TIME);
  diff = end - start;
  printf("diff = %d (%d - %d)\n", diff, end, start);
  if (diff > ((int) 500 * 1.2)) {
    __glutFatalError("FAIL: timer too late");
  }
  if (diff < ((int) 500 * .9)) {
    __glutFatalError("FAIL: timer too soon");
  }
  glutTimerFunc(100, timer2, 36);
}

void
menuSelect(int value)
{
}

void
NeverVoid(void)
{
  __glutFatalError("FAIL: NeverVoid should never be called");
}

void
NeverValue(int value)
{
  __glutFatalError("FAIL: NeverValue should never be called");
}

#define NUM 15

void
display(void)
{
  glClear(GL_COLOR_BUFFER_BIT);
}

int
main(int argc, char **argv)
{
  int win, menu;
  int marray[NUM];
  int warray[NUM];
  int i, j;
  GLint isIndex;

#if defined(__sgi)  && !defined(REDWOOD)
  /* XXX IRIX 6.0.1 mallopt(M_DEBUG, 1) busted. */
  mallopt(M_DEBUG, 1);
#endif
  glutInit(&argc, argv);
  glutInitWindowPosition(10, 10);
  glutInitWindowSize(200, 200);
  glutInitDisplayMode(GLUT_SINGLE | GLUT_RGB | GLUT_DEPTH);
  win = glutCreateWindow("test2");
  glGetIntegerv(GL_INDEX_MODE, &isIndex);
  if (isIndex != 0) {
    __glutFatalError("FAIL: window should be RGBA");
  }
  glutSetWindow(win);
  glutDisplayFunc(display);
  menu = glutCreateMenu(menuSelect);
  glutSetMenu(menu);
  glutReshapeFunc(NULL);
  glutReshapeFunc(NULL);
  glutKeyboardFunc(NULL);
  glutKeyboardFunc(NULL);
  glutMouseFunc(NULL);
  glutMouseFunc(NULL);
  glutMotionFunc(NULL);
  glutMotionFunc(NULL);
  glutVisibilityFunc(NULL);
  glutVisibilityFunc(NULL);
  glutMenuStateFunc(NULL);
  glutMenuStateFunc(NULL);
  glutMenuStatusFunc(NULL);
  glutMenuStatusFunc(NULL);
  glutSpecialFunc(NULL);
  glutSpecialFunc(NULL);
  glutSpaceballMotionFunc(NULL);
  glutSpaceballMotionFunc(NULL);
  glutSpaceballRotateFunc(NULL);
  glutSpaceballRotateFunc(NULL);
  glutSpaceballButtonFunc(NULL);
  glutSpaceballButtonFunc(NULL);
  glutButtonBoxFunc(NULL);
  glutButtonBoxFunc(NULL);
  glutDialsFunc(NULL);
  glutDialsFunc(NULL);
  glutTabletMotionFunc(NULL);
  glutTabletMotionFunc(NULL);
  glutTabletButtonFunc(NULL);
  glutTabletButtonFunc(NULL);
  for (i = 0; i < NUM; i++) {
    marray[i] = glutCreateMenu(menuSelect);
    warray[i] = glutCreateWindow("test");
    glutDisplayFunc(display);
    for (j = 0; j < i; j++) {
      glutAddMenuEntry("Hello", 1);
      glutAddSubMenu("Submenu", menu);
    }
    if (marray[i] != glutGetMenu()) {
      __glutFatalError("FAIL: current menu not %d", marray[i]);
    }
    if (warray[i] != glutGetWindow()) {
      __glutFatalError("FAIL: current window not %d", warray[i]);
    }
    glutDisplayFunc(NeverVoid);
    glutVisibilityFunc(NeverValue);
  }
  for (i = 0; i < NUM; i++) {
    glutDestroyMenu(marray[i]);
    glutDestroyWindow(warray[i]);
  }
  glutTimerFunc(500, timer, 42);
  start = glutGet(GLUT_ELAPSED_TIME);
  glutIdleFunc(idle);
  glutMainLoop();
  return 0;             /* ANSI C requires main to return int. */
}
