#include <stdio.h>

#ifndef SLANG_VERSION
# include <slang.h>
#endif

typedef struct
{
   unsigned int row, col, nrows, ncols;
   unsigned int crow, ccol;
   unsigned short *b;
   unsigned short *buf;
   unsigned short *bufmax;
   unsigned short color;
}
SLcurses_Window_Type;

extern int SLcurses_wclrtobot (SLcurses_Window_Type *);
extern int SLcurses_scroll (SLcurses_Window_Type *);
extern int SLcurses_wrefresh (SLcurses_Window_Type *);
extern int SLcurses_delwin (SLcurses_Window_Type *);
extern int SLcurses_waddch (SLcurses_Window_Type *, char);
extern int SLcurses_wmove (SLcurses_Window_Type *, unsigned int, unsigned int);
extern SLcurses_Window_Type *SLcurses_newwin (unsigned int, unsigned int,
					      unsigned int, unsigned int);

extern int SLcurses_wnoutrefresh (SLcurses_Window_Type *);
extern int SLcurses_wclrtoeol (SLcurses_Window_Type *);
extern int SLcurses_waddstr (SLcurses_Window_Type *, char *);

#define WINDOW SLcurses_Window_Type 
#define stdscr NULL

#define wclrtobot	SLcurses_wclrtobot
#define scroll		SLcurses_scroll
#define wrefresh	SLcurses_wrefresh
#define delwin		SLcurses_delwin
#define waddch		SLcurses_waddch
#define wmove		SLcurses_wmove
#define newwin		SLcurses_newwin
#define wnoutrefresh	SLcurses_wnoutrefresh
#define werase(w)	SLcurses_wmove((w),0,0); SLcurses_wclrtobot(w)

#define winch(w) \
  (((w) == NULL) ? SLsmg_char_at () \
    : (((w)->b < (w)->bufmax) ? *((w)->b) : 0))

#define doupdate	SLsmg_refresh
extern int SLcurses_mvprintw (int, int, char *, ...);
extern int SLcurses_has_colors(void);
extern int SLcurses_nil (void);
extern int SLcurses_getch (void);
extern int SLcurses_mvaddch (int, int, SLtt_Char_Type);
extern int SLcurses_addch (SLtt_Char_Type attr);
#define addch SLcurses_addch
#define mvaddch SLcurses_mvaddch

extern int SLcurses_attrset (SLtt_Char_Type);
extern int SLcurses_attron (SLtt_Char_Type);
extern int SLcurses_attroff (SLtt_Char_Type);
#define attrset SLcurses_attrset
#define attron SLcurses_attron
#define attroff SLcurses_attroff
#define COLOR_PAIR(x) ((x) << 8) 

extern int SLcurses_start_color (void);
#define start_color SLcurses_start_color

#define ERR 0xFFFF
#define wgetch(x) SLcurses_getch ()

extern int SLcurses_nodelay (SLcurses_Window_Type *, int);
extern int SLcurses_initscr (void);
#define initscr SLcurses_initscr

extern int SLcurses_cbreak (void);
extern int SLcurses_raw (void);
#define cbreak SLcurses_cbreak
#define crmode SLcurses_cbreak
#define raw SLcurses_raw
#define noraw SLang_reset_tty
#define nocbreak SLang_reset_tty


#define mvprintw SLcurses_mvprintw
#define has_colors SLcurses_has_colors
#define getch SLcurses_getch
#define nodelay SLcurses_nodelay

#define ungetch SLang_ungetkey

#define COLS SLtt_Screen_Cols
#define LINES SLtt_Screen_Rows

#define move SLsmg_gotorc
#define clrtoeol SLsmg_erase_eol


#define printw SLsmg_printf
#define mvprintw SLcurses_mvprintw
#define clrtobot SLsmg_erase_eos
#define clrtoeol SLsmg_erase_eol
#define standout SLsmg_reverse_video
#define standend  SLsmg_normal_video

#define addstr SLsmg_write_string
#define refresh SLsmg_refresh
#define clear SLsmg_cls
#define erase SLsmg_gotorc (0,0), SLsmg_erase_eos
#define mvaddstr(y, x, s) SLsmg_gotorc(y, x), SLsmg_write_string(s)
#define touchline SLsmg_touch_lines
#define inch SLsmg_char_at
#define endwin SLsmg_reset_smg(),SLang_reset_tty
#define resetterm SLang_reset_tty


/* Ugly Hacks that may not work */
#define ACS_ULCORNER '+'
#define ACS_URCORNER '+'
#define ACS_LRCORNER '+'
#define ACS_LLCORNER '+'
#define ACS_TTEE '+'
#define ACS_LTEE '+'
#define ACS_RTEE '+'
#define ACS_BTEE '+'
#define ACS_PLUS '+'
#define ACS_VLINE '|'
#define ACS_HLINE '-'

#define hline(x,y) SLsmg_draw_hline (y)
#define vline(x,y) SLsmg_draw_vline (y)

#define A_NORMAL 0
#define A_BOLD		0x1000
#define A_REVERSE	0x2000
#define A_STANDOUT	A_REVERSE
#define A_UNDERLINE	0x4000
#define A_BLINK		0
#define A_COLOR 0x7
#define A_ALTCHARSET	0x8000

#define COLOR_BLACK	SLSMG_COLOR_BLACK
#define COLOR_RED	SLSMG_COLOR_RED
#define COLOR_GREEN	SLSMG_COLOR_GREEN
#define COLOR_YELLOW	SLSMG_COLOR_BROWN
#define COLOR_BLUE	SLSMG_COLOR_BLUE
#define COLOR_MAGENTA	SLSMG_COLOR_MAGENTA
#define COLOR_CYAN	SLSMG_COLOR_CYAN
#define COLOR_WHITE	SLSMG_COLOR_LGRAY

#define init_pair(_x,_f,_b) SLtt_set_color_fgbg((_x), (_f), (_b))


#define scrollok(a,b) SLsmg_Newline_Moves = ((b) ? 1 : -1)
#define getyx(a,y,x)  y=SLsmg_get_row(), x=SLsmg_get_column()
#define napms(x) SLang_input_pending(-(x))
typedef SLtt_Char_Type chtype;
#define beep SLtt_beep
#define curs_set(x) SLtt_set_cursor_visibility(x)


/* These functions do nothing */
#define savetty SLcurses_nil
#define wscrl(a,b) SLcurses_nil()
#define nonl    SLcurses_nil
#define echo SLcurses_nil
#define noecho SLcurses_nil
#define saveterm SLcurses_nil
#define clearok(x,y) SLcurses_nil
#define box(x,y,z) SLcurses_nil()
#define leaveok(a,b) SLcurses_nil()
#define nl() SLcurses_nil()
#define trace(x) SLcurses_nil()

#define tigetstr(x) NULL

/* Fake keypad.  This can be fixed.... */
#define keypad(x,y) SLcurses_nil()
#define KEY_DOWN -1
#define KEY_UP -2
#define KEY_LEFT -3
#define KEY_RIGHT -4
#define KEY_A1	-5
#define KEY_B1	-6
#define KEY_C1	-7
#define KEY_A2	-8
#define KEY_B2	-9
#define KEY_C2	-10
#define KEY_A3	-11
#define KEY_B3	-12
#define KEY_C3	-13
#define KEY_REDO -14
#define KEY_UNDO -15
#define KEY_BACKSPACE -16



/* These have no place in C */
#define TRUE 1
#define FALSE 0
#define bool int
