.TH gk_views n "22 September 1995" "GroupKit"
.SH NAME
gk_views \- A controller for a group graphical environment.
.SH SYNOPSIS
.TP 
\fBgk_views\fI pathName groupId\fR
.TP 
\fBgk_viewsGetCoords\fI groupId userId\fR
.TP 
\fBgk_viewsSetCoords\fI groupId userId coords\fR
.TP 
\fBgk_viewsGetAttribute\fI groupId userId attribute\fR
.TP 
\fBgk_viewsSetAttribute\fI groupId userId attribute value\fR
.TP 
\fBgk_viewsAttributes\fI groupId userId\fR
.TP 
\fBgk_viewsUsers\fI groupId\fR

.SH DESCRIPTION
This command sets-up a shared environment, for more information on
environments see the gk_newenv manual page.  The shared environment
maintains user information, in particular what a particular user is 
viewing in a given application as well as some other user attribute
information.  An example of what might be stored in the user attribute
is the user's color.  Gk_views does not automatically initialize the
coordinates nor the attributes, therefore, this must be done by the
application if it is required.  

The information is controlled with the various commands.
The interaction between the environment and an application is two-way.
The application changes and queries the environment through the various
supplied commands.  In the other direction the environment 
informs the application of changes 
by calling particular procedures that are supplied by the application, 
see the default bindings section for more information.

.SH COMMANDS

.TP
\fBgk_views\fI pathName groupId\fR
Creates the shared environment and necessary procedures.  Also sets-up
the default environment bindings.
This must be done before any of the other commands can be used. The
\fIpathName\fR refers to the window pathName that has the expected 
subcommands - adduser, deleteuser, moveuser, and changedAttribute.

The 
\fIgroupId\fR is any identification that will distinguish your views 
environment from any other views environment, different applications 
should have 
different \fIgroupId's \fR unless the information is intended to be shared 
between them.

.TP 
\fBgk_viewsAttributes\fI groupId userId\fR
Returns the list of attributes for the user.

.TP
\fBgk_viewsCopy\fI pathName oldGroupId newGroupId\fR
Copies all of the information stored in the old group to the new group.
If the new group does not currently exist then it is created, including
the default bindings.  The \fIpathName\fR refers to the window path name
that has the expected subcommands.  The group identifiers, \fIoldGroupId\fR
and \fInewGroupId\fR, are for the group being copied from and the group
being copied to, respectively.  

.TP
\fBgk_viewsDelete\fI groupId ?userId?\fR
Removes a user or a group users from the views environment.  If the
user identification is specified then that user is the only one removed
from the environment.  However, if it is not specified the entire
group of user's associated with the given \fIgroupId\fR are removed and the
default bindings are also removed.

.TP 
\fBgk_viewsGetAttribute\fI groupId userId attribute\fR
Returns the stored attribute information for\fIuserId\fR.
The format of the attribute may vary, it depends on
the value given to the \fBgk_viewsSetAttribute\fR command.  
The \fIgroupId\fR is the one specified in the 
\fBgk_views\fR command and the \fIuserId\fR is any identification
that will uniquely determine different users, typically the value
used by GroupKit is used, i.e. \fBusers local.usernum\fR

.TP
\fBgk_viewsGetCoords\fI groupId userId\fR
Returns the current location of \fIuserId\fR.  The format of the
returned coordinates is varied, it depends on the value
given to the \fBgk_viewsSetCoords\fR command.  
The \fIgroupId\fR is the one specified in the 
\fBgk_views\fR command and the \fIuserId\fR is any identification
that will uniquely determine different users, typically the value
used by GroupKit is used, i.e. \fBusers local.usernum\fR

.TP 
\fBgk_viewsSetAttribute\fI groupId userId attribute value\fR
Sets the attribute(s) of a particular user.  The attribute may be in any 
format as long as it is a single item.
The \fIgroupId\fR is the one 
specified in the \fBgk_views\fR command and the \fIuserId\fR is any 
identification that will uniquely determine different users, typically 
the value used by GroupKit is used, i.e. \fBusers local.usernum\fR

.TP 
\fBgk_viewsSetCoords\fI groupId userId coords\fR
Set the coordinates of a particular user.  The coordinates may be in
any format, however, they should be in a format that is useful to the
particular application.  The \fIgroupId\fR is the one specified in the 
\fBgk_views\fR command and the \fIuserId\fR is any identification
that will uniquely determine different users, typically the value
used by GroupKit is used, i.e. \fBusers local.usernum\fR

.TP 
\fBgk_viewsUsers\fI groupId\fR
Returns the list of users currently in the environment, the list is
sorted so it should be consistent between different users. The 
\fIgroupId\fR is the one specified in the \fBgk_views\fR command.

.SH "DEFAULT BINDINGS"
The environment used allows bindings to the environment.  There are
default bindings made to events that occur within an application and
within the environment themselves.  Some of these binding call the
widget subcommand for the window provided by to the \fBgk_views\fR
command.  The subcommand is invoked only if the event is 
``interesting'' to the particular widget.  An event is interesting
if and only if the event contains the \fIgroupId\fR that was 
supplied to the \fBgk_views\fR command.  
.PP
Besides the bindings to the widget's subcommands there is one additional
binding.  This one binds the given window path name to Configure to handle
resizing of the window.  This bind will destroy any current bindings for
Configure for the given widget.

.TP
\fIpathName \fBadduser \fIgroupId user coordinates\fR
Allows the application to act on the addition of new information to the
views environment.  When the \fBaddInfo\fR event occurs within the 
views environment it executes the procedure the subcommand \fBadduser\fI
for the window pathName supplied to the \fBgk_views\fR command.
An error will occur if this subcommand does not exist for the widget.

.TP
\fIpathName \fBmoveuser \fIgroupId user coordinates\fR
Allows the application to act on a change to the \fIuser\fR's
coordinates within the
views environment.  When the \fBchangeInfo\fR event occurs within the 
views environment and a change in the coordinates has caused the
event to occur this subcommand will be invoked.  An error will 
occur if this subcommand does not exist for the widget.

.TP
\fIpathName \fBdeleteuser \fIgroupId user\fR
Allows the application take action when information is removed from
the environment.  When the \fBdeleteInfo\fR event occurs within the 
views environment it executes this subcommand.  An error will occur if 
this subcommand does not exist for the widget.

.TP
\fIpathName \fBchangeattribute \fIgroupId user attribute value\fR
Allows the application to act on a change to the \fIuser\fR's
attribute within the
views environment.  When the \fBchangeInfo\fR event occurs within the 
views environment and a change to the attribute has caused the
event to occur this subcommand will be invoked.  An error will occur 
if this subcommand does not exist for the widget.

.SH NOTE
There is a possibility of strange results if the \fIgroupId\fR is \fBnot\fR
unique between gk_views associated with different objects.
.PP
There are two elements in the environment, tags and deltag, for each user.
They store environment binding tags so that they can be removed if need
be.  Changes to these elments should never cause any of the subcommands 
to be invoked, to the user they should appear to not exist.

.SH BUGS
For some unknown reason current users are not always informed about new 
entrants.  This is probably  due to the fact that the environment can
generate events before a conference/application knows what to do with
the events.

.SH "SEE ALSO"
.PP
gk_newenv(n) and gk_event(n)
.br
gk_scrollbar.tcl and gk_miniText.tcl

.SH AUTHOR
Shannon Jaeger (jaeger@cpsc.ucalgary.ca)


