.TH gk_notifier n "25 Apr 1995" "GroupKit"
.SH NAME
gk_notifier - create a bind like mechanism for general notifications
.SH SYNOPSIS
.TP 
\fBgk_notifier\fI name\fR

.SH DESCRIPTION
The gk_notifier command creates a new gk_notifier object.  A notification
object provides the same type of functionality as Tk's bind command --
attaching callbacks to events -- but generalizes the notion away from
X11 events.  Users of the gk_notifier object can both generate arbitrary
events, as well as bind callbacks to arbitrary events.  Multiple 
gk_notifier objects can exist in an application, and multiple bind callbacks
can fire on a single event.

Events consist of two parts: an event type and a list of event attributes.
In general, all events of the same type will have the same attributes,
though the specific values of the attributes may differ.  Attributes
are specified when the event is generated, and can be retrieved via
substitutions in event bindings.

The gk_notifier command creates a Tcl command which is used to access
the created gk_notifier object.  If the name of the object is specified as 
"-anonymous", the gk_notifier command will assign a name.  The name of the
gk_notifier object is returned.

.SH GK_NOTIFIER OBJECT COMMAND

The gk_notifier command creates a new Tcl command whose name is \fIname\fR.
This command may be used to invoke various operations on the gk_notifier
object.  The following operations are allowed:

.TP 
\fIname \fBnotify \fItype attributes\fR
Generate an event of type \fItype\fR.  The event attributes are
specified by \fIattributes\fR, which is a list of pair.  The first
element of each pair is a single character used to refer to the attribute
in bindings.  The second element of each pair is the value of the
attribute.

.TP
\fIname \fBbind \fItype handler\fR
Create a new binding for events having type \fItype\fR.  When an event
of that type is generated, the Tcl script specified in \fIhandler\fR is
invoked.  The \fIhandler\fR is first searched for any percent signs,
which flag event substitutions.  For each percent sign, the character
after the percent sign is examined.  If it matches one of the event
attribute characters specified when the event was generated, the
corresponding value of the attribute from the event is substituted.
Two special cases exist: the string "%%" is used to specify a single
percent sign, and the string "%E" is substituted with the event type.
The command returns an identifier for the binding, which can be used
to later remove the binding with the \fBdelete\fR subcommand.

.TP
\fIname \fBdelete \fIbinding\fR
Delete a binding previously created using the \fBbind\fR subcommand.
The \fIbinding\fR parameter is the name of the binding to delete,
returned from \fBbind\fR.

.TP
\fIname \fBdestroy\fR
Destroy the gk_notifier object and its Tcl command.

.SH EXAMPLE
.IP
.nf
gk_notifier announce

announce bind someEvent "doEvent %U %R %E"

proc doEvent {usernum roomname event} {
  puts "u->$usernum r->$roomname e->$event"
}

announce notify someEvent [list [list U 25] [list R Foyer]]
.fi
.LP
.SH NOTE
Currently, bindings are fired in the order they are created.  Future
versions may include a "-before" option on the bind subcommand, to 
insert the new binding relative to other bindings.

.SH AUTHOR
Mark Roseman (roseman@cpsc.ucalgary.ca)
